/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.level.block.entity;

import io.izzel.arclight.common.bridge.core.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.core.tileentity.AbstractFurnaceTileEntityBridge;
import io.izzel.arclight.common.bridge.core.world.item.crafting.RecipeHolderBridge;
import io.izzel.arclight.common.mixin.core.world.level.block.entity.LockableBlockEntityMixin;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import io.izzel.arclight.mixin.Decorate;
import io.izzel.arclight.mixin.DecorationOps;
import io.izzel.arclight.mixin.Local;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8786;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;

@Mixin(value={class_2609.class})
public abstract class AbstractFurnaceBlockEntityMixin
extends LockableBlockEntityMixin
implements AbstractFurnaceTileEntityBridge {
    @Shadow
    protected class_2371<class_1799> field_11984;
    @Shadow
    @Final
    private Object2IntOpenHashMap<class_2960> field_11986;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 64;
    private static class_2609 arclight$captureFurnace;
    private static class_1657 arclight$capturePlayer;
    private static class_1799 arclight$item;
    private static int arclight$captureAmount;

    @Shadow
    protected abstract int method_11200(class_1799 var1);

    @Shadow
    protected abstract boolean method_11201();

    @Shadow
    public abstract List<class_8786<?>> method_27354(class_3218 var1, class_243 var2);

    @Decorate(method={"burn"}, at=@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/core/NonNullList;get(I)Ljava/lang/Object;"))
    private static <E> E arclight$furnaceSmelt(class_2371<E> instance, int i, @Local(ordinal=-1) class_1799 itemStack2, @Local(ordinal=-2) class_1799 itemStack1) throws Throwable {
        Object blockEntity = ArclightCaptures.getTickingBlockEntity();
        if (blockEntity != null) {
            CraftItemStack source = CraftItemStack.asCraftMirror(itemStack1);
            ItemStack result = CraftItemStack.asBukkitCopy(itemStack2);
            FurnaceSmeltEvent furnaceSmeltEvent = new FurnaceSmeltEvent(CraftBlock.at((class_1936)blockEntity.method_10997(), blockEntity.method_11016()), source, result);
            Bukkit.getPluginManager().callEvent(furnaceSmeltEvent);
            if (furnaceSmeltEvent.isCancelled()) {
                return (E)DecorationOps.cancel().invoke(false);
            }
            result = furnaceSmeltEvent.getResult();
            itemStack2 = CraftItemStack.asNMSCopy(result);
            if (itemStack2.method_7960()) {
                itemStack1.method_7934(1);
                return (E)DecorationOps.cancel().invoke(true);
            }
        }
        return (E)DecorationOps.callsite().invoke(instance, i);
    }

    @Decorate(method={"serverTick"}, at=@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;isLit()Z"), slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;litDuration:I")))
    private static boolean arclight$setBurnTime(class_2609 furnace) throws Throwable {
        class_1799 itemStack = furnace.method_5438(1);
        CraftItemStack fuel = CraftItemStack.asCraftMirror(itemStack);
        FurnaceBurnEvent furnaceBurnEvent = new FurnaceBurnEvent(CraftBlock.at((class_1936)furnace.field_11863, furnace.method_11016()), fuel, furnace.field_11981);
        Bukkit.getPluginManager().callEvent(furnaceBurnEvent);
        if (furnaceBurnEvent.isCancelled()) {
            return DecorationOps.cancel().invoke();
        }
        furnace.field_11981 = furnaceBurnEvent.getBurnTime();
        return DecorationOps.callsite().invoke(furnace) && furnaceBurnEvent.isBurning();
    }

    @Decorate(method={"serverTick"}, inject=true, at=@At(value="FIELD", ordinal=0, target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;cookingProgress:I"))
    private static void arclight$startSmelt(class_1937 level, class_2338 pos, class_2680 state, class_2609 furnace, @Local(ordinal=-1) class_8786<?> recipe) {
        if (recipe != null && furnace.field_11989 == 0) {
            CraftItemStack source = CraftItemStack.asCraftMirror(furnace.method_5438(0));
            Recipe recipe2 = ((RecipeHolderBridge)recipe).bridge$toBukkitRecipe();
            if (recipe2 instanceof CookingRecipe) {
                CookingRecipe cookingRecipe = (CookingRecipe)recipe2;
                FurnaceStartSmeltEvent event = new FurnaceStartSmeltEvent(CraftBlock.at((class_1936)level, pos), source, cookingRecipe);
                Bukkit.getPluginManager().callEvent(event);
                furnace.field_11988 = event.getTotalCookTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<class_8786<?>> getRecipesToAwardAndPopExperience(class_3218 world, class_243 vec, class_2338 pos, class_1657 entity, class_1799 itemStack, int amount) {
        try {
            arclight$item = itemStack;
            arclight$captureAmount = amount;
            arclight$captureFurnace = (class_2609)this;
            arclight$capturePlayer = entity;
            List<class_8786<?>> list = this.method_27354(world, vec);
            entity.method_7254(list);
            this.field_11986.clear();
            List<class_8786<?>> list2 = list;
            return list2;
        }
        finally {
            arclight$item = null;
            arclight$captureAmount = 0;
            arclight$captureFurnace = null;
            arclight$capturePlayer = null;
        }
    }

    @Override
    public List<class_8786<?>> bridge$dropExp(class_3222 entity, class_1799 itemStack, int amount) {
        return this.getRecipesToAwardAndPopExperience(entity.method_51469(), entity.method_19538(), this.field_11867, (class_1657)entity, itemStack, amount);
    }

    @Redirect(method={"createExperience"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ExperienceOrb;award(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/Vec3;I)V"))
    private static void arclight$expEvent(class_3218 level, class_243 vec3, int amount) {
        if (arclight$capturePlayer != null && arclight$captureAmount != 0) {
            FurnaceExtractEvent event = new FurnaceExtractEvent(((ServerPlayerEntityBridge)arclight$capturePlayer).bridge$getBukkitEntity(), CraftBlock.at((class_1936)level, arclight$captureFurnace.method_11016()), CraftItemType.minecraftToBukkit(arclight$item.method_7909()), arclight$captureAmount, amount);
            Bukkit.getPluginManager().callEvent(event);
            amount = event.getExpToDrop();
        }
        class_1303.method_31493((class_3218)level, (class_243)vec3, (int)amount);
    }

    @Override
    public List<class_1799> getContents() {
        return this.field_11984;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public void setOwner(InventoryHolder owner) {
    }

    public int method_5444() {
        if (this.maxStack == 0) {
            this.maxStack = 64;
        }
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    @Override
    public int bridge$getBurnDuration(class_1799 stack) {
        return this.method_11200(stack);
    }

    @Override
    public boolean bridge$isLit() {
        return this.method_11201();
    }

    public Object2IntOpenHashMap<class_2960> getRecipesUsed() {
        return this.field_11986;
    }
}

