/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.level.block.entity;

import io.izzel.arclight.common.bridge.core.entity.EntityBridge;
import io.izzel.arclight.common.bridge.core.inventory.IInventoryBridge;
import io.izzel.arclight.common.bridge.core.tileentity.TileEntityBridge;
import io.izzel.arclight.common.bridge.core.world.WorldBridge;
import io.izzel.arclight.common.mixin.core.world.level.block.entity.LockableBlockEntityMixin;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import io.izzel.arclight.common.mod.util.DistValidate;
import io.izzel.arclight.mixin.Eject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2614;
import net.minecraft.class_2615;
import net.minecraft.class_2680;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.inventory.HopperInventorySearchEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2614.class})
public abstract class HopperBlockEntityMixin
extends LockableBlockEntityMixin {
    @Shadow
    private class_2371<class_1799> field_12024;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 64;

    @Shadow
    public abstract void method_5447(int var1, class_1799 var2);

    @Shadow
    private static boolean method_11243(class_1937 p_155579_, class_2338 p_155580_, class_2680 p_155581_, class_2614 p_155582_, BooleanSupplier p_155583_) {
        return false;
    }

    @Redirect(method={"pushItemsTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/HopperBlockEntity;tryMoveItems(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/HopperBlockEntity;Ljava/util/function/BooleanSupplier;)Z"))
    private static boolean arclight$hopperCheck(class_1937 level, class_2338 pos, class_2680 state, class_2614 hopper, BooleanSupplier flag) {
        boolean result = HopperBlockEntityMixin.method_11243(level, pos, state, hopper, flag);
        if (!result && DistValidate.isValid((class_1936)level) && ((WorldBridge)level).bridge$spigotConfig().hopperCheck > 1) {
            hopper.method_11238(((WorldBridge)level).bridge$spigotConfig().hopperCheck);
        }
        return result;
    }

    @Eject(method={"ejectItems"}, require=0, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/HopperBlockEntity;addItem(Lnet/minecraft/world/Container;Lnet/minecraft/world/Container;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/core/Direction;)Lnet/minecraft/world/item/ItemStack;"))
    private static class_1799 arclight$moveItem(class_1263 source, class_1263 destination, class_1799 stack, class_2350 direction, CallbackInfoReturnable<Boolean> cir) {
        class_2614 entity = (class_2614)ArclightCaptures.getTickingBlockEntity();
        if (entity == null) {
            return class_2614.method_11260((class_1263)source, (class_1263)destination, (class_1799)stack, (class_2350)direction);
        }
        CraftItemStack original = CraftItemStack.asCraftMirror(stack);
        Inventory destinationInventory = destination instanceof class_1258 ? new CraftInventoryDoubleChest((class_1258)destination) : ((IInventoryBridge)destination).getOwnerInventory();
        InventoryMoveItemEvent event = new InventoryMoveItemEvent(((TileEntityBridge)entity).bridge$getOwner().getInventory(), original.clone(), destinationInventory, true);
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            entity.method_11238(((WorldBridge)entity.method_10997()).bridge$spigotConfig().hopperTransfer);
            cir.setReturnValue((Object)false);
            return null;
        }
        return class_2614.method_11260((class_1263)source, (class_1263)destination, (class_1799)CraftItemStack.asNMSCopy(event.getItem()), (class_2350)direction);
    }

    @Eject(method={"tryTakeInItemFromSlot"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/HopperBlockEntity;addItem(Lnet/minecraft/world/Container;Lnet/minecraft/world/Container;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/core/Direction;)Lnet/minecraft/world/item/ItemStack;"))
    private static class_1799 arclight$pullItem(class_1263 source, class_1263 destination, class_1799 stack, class_2350 direction, CallbackInfoReturnable<Boolean> cir, class_2615 hopper, class_1263 inv, int index) {
        class_1799 origin = inv.method_5438(index).method_7972();
        CraftItemStack original = CraftItemStack.asCraftMirror(stack);
        Inventory sourceInventory = source instanceof class_1258 ? new CraftInventoryDoubleChest((class_1258)source) : ((IInventoryBridge)source).getOwnerInventory();
        InventoryMoveItemEvent event = new InventoryMoveItemEvent(sourceInventory, original.clone(), ((IInventoryBridge)destination).getOwnerInventory(), false);
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            inv.method_5447(index, origin);
            if (destination instanceof class_2614) {
                ((class_2614)destination).method_11238(8);
            }
            cir.setReturnValue((Object)false);
            return null;
        }
        return class_2614.method_11260((class_1263)source, (class_1263)destination, (class_1799)CraftItemStack.asNMSCopy(event.getItem()), (class_2350)direction);
    }

    @Inject(method={"addItem(Lnet/minecraft/world/Container;Lnet/minecraft/world/entity/item/ItemEntity;)Z"}, cancellable=true, at={@At(value="HEAD")})
    private static void arclight$pickupItem(class_1263 inventory, class_1542 itemEntity, CallbackInfoReturnable<Boolean> cir) {
        InventoryPickupItemEvent event = new InventoryPickupItemEvent(((IInventoryBridge)inventory).getOwnerInventory(), (Item)((Object)((EntityBridge)itemEntity).bridge$getBukkitEntity()));
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"addItem(Lnet/minecraft/world/Container;Lnet/minecraft/world/entity/item/ItemEntity;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;discard()V")})
    private static void arclight$pickupCause(class_1263 container, class_1542 itemEntity, CallbackInfoReturnable<Boolean> cir) {
        itemEntity.bridge().bridge$pushEntityRemoveCause(EntityRemoveEvent.Cause.PICKUP);
    }

    private static class_1263 runHopperInventorySearchEvent(class_1263 inventory, CraftBlock hopper, CraftBlock searchLocation, HopperInventorySearchEvent.ContainerType containerType) {
        HopperInventorySearchEvent event = new HopperInventorySearchEvent(inventory != null ? new CraftInventory(inventory) : null, containerType, hopper, searchLocation);
        Bukkit.getServer().getPluginManager().callEvent(event);
        CraftInventory craftInventory = (CraftInventory)event.getInventory();
        return craftInventory != null ? craftInventory.getInventory() : null;
    }

    @Inject(method={"getAttachedContainer"}, cancellable=true, at={@At(value="RETURN")})
    private static void arclight$searchTo(class_1937 level, class_2338 pos, class_2614 hopperBlockEntity, CallbackInfoReturnable<class_1263> cir) {
        class_1263 container = (class_1263)cir.getReturnValue();
        CraftBlock hopper = CraftBlock.at((class_1936)level, pos);
        CraftBlock searchBlock = CraftBlock.at((class_1936)level, pos.method_10093(hopperBlockEntity.field_49101));
        cir.setReturnValue((Object)HopperBlockEntityMixin.runHopperInventorySearchEvent(container, hopper, searchBlock, HopperInventorySearchEvent.ContainerType.DESTINATION));
    }

    @Inject(method={"getSourceContainer"}, cancellable=true, at={@At(value="RETURN")})
    private static void arclight$searchFrom(class_1937 level, class_2615 hopper, class_2338 blockposition, class_2680 iblockdata, CallbackInfoReturnable<class_1263> cir) {
        class_1263 container = (class_1263)cir.getReturnValue();
        class_2338 blockPos = class_2338.method_49637((double)hopper.method_11266(), (double)hopper.method_11264(), (double)hopper.method_11265());
        CraftBlock hopperBlock = CraftBlock.at((class_1936)level, blockPos);
        CraftBlock containerBlock = CraftBlock.at((class_1936)level, blockPos.method_10084());
        cir.setReturnValue((Object)HopperBlockEntityMixin.runHopperInventorySearchEvent(container, hopperBlock, containerBlock, HopperInventorySearchEvent.ContainerType.SOURCE));
    }

    @Override
    public List<class_1799> getContents() {
        return this.field_12024;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public void setOwner(InventoryHolder owner) {
    }

    public int method_5444() {
        if (this.maxStack == 0) {
            this.maxStack = 64;
        }
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }
}

