/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.storage;

import com.mojang.datafixers.DataFixer;
import io.izzel.arclight.common.bridge.core.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.core.world.storage.PlayerDataBridge;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_29;
import net.minecraft.class_3222;
import net.minecraft.class_4284;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_29.class})
public class PlayerDataMixin
implements PlayerDataBridge {
    @Shadow
    @Final
    private File field_144;
    @Shadow
    @Final
    private static Logger field_149;
    @Shadow
    @Final
    private static DateTimeFormatter field_47840;
    @Shadow
    @Final
    protected DataFixer field_148;

    @Inject(method={"load(Lnet/minecraft/world/entity/player/Player;Ljava/lang/String;)Ljava/util/Optional;"}, at={@At(value="RETURN")})
    private void arclight$lastSeenTime(class_1657 player, String string, CallbackInfoReturnable<Optional<class_2487>> cir) {
        ((Optional)cir.getReturnValue()).ifPresent(tag -> {
            if (player instanceof class_3222) {
                CraftPlayer craftPlayer = ((ServerPlayerEntityBridge)player).bridge$getBukkitEntity();
                long modified = new File(this.field_144, String.valueOf(player.method_5667()) + ".dat").lastModified();
                if (modified < craftPlayer.getFirstPlayed()) {
                    craftPlayer.setFirstPlayed(modified);
                }
            }
        });
    }

    public File getPlayerDir() {
        return this.field_144;
    }

    public class_2487 getPlayerData(String uuid) {
        try {
            File file1 = new File(this.field_144, uuid + ".dat");
            if (file1.exists()) {
                return class_2507.method_10629((InputStream)new FileInputStream(file1), (class_2505)class_2505.method_53898());
            }
        }
        catch (Exception exception) {
            field_149.warn("Failed to load player data for " + uuid);
        }
        return null;
    }

    private void backup(String name, String s1, String s) {
        Path path = this.field_144.toPath();
        Path path1 = path.resolve(s1 + s);
        Path path2 = path.resolve(s1 + "_corrupted_" + LocalDateTime.now().format(field_47840) + s);
        if (Files.isRegularFile(path1, new LinkOption[0])) {
            try {
                Files.copy(path1, path2, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            }
            catch (Exception exception) {
                field_149.warn("Failed to copy the player.dat file for {}", (Object)name, (Object)exception);
            }
        }
    }

    private Optional<class_2487> load(String name, String s1, String s) {
        File file = this.field_144;
        File file1 = new File(file, s1 + s);
        boolean usingWrongFile = false;
        if (!file1.exists() && (file1 = new File(file, UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8)).toString() + s)).exists()) {
            usingWrongFile = true;
            Bukkit.getServer().getLogger().warning("Using offline mode UUID file for player " + name + " as it is the only copy we can find.");
        }
        if (file1.exists() && file1.isFile()) {
            try {
                Optional<class_2487> optional = Optional.of(class_2507.method_30613((Path)file1.toPath(), (class_2505)class_2505.method_53898()));
                if (usingWrongFile) {
                    file1.renameTo(new File(file1.getPath() + ".offline-read"));
                }
                return optional;
            }
            catch (Exception exception) {
                field_149.warn("Failed to load player data for {}", (Object)name);
            }
        }
        return Optional.empty();
    }

    public Optional<class_2487> load(class_1657 entityhuman) {
        return this.load(entityhuman.method_5477().getString(), entityhuman.method_5845()).map(nbttagcompound -> {
            if (entityhuman instanceof class_3222) {
                CraftPlayer player = (CraftPlayer)entityhuman.bridge$getBukkitEntity();
                long modified = new File(this.field_144, entityhuman.method_5845() + ".dat").lastModified();
                if (modified < player.getFirstPlayed()) {
                    player.setFirstPlayed(modified);
                }
            }
            entityhuman.method_5651(nbttagcompound);
            return nbttagcompound;
        });
    }

    public Optional<class_2487> load(String name, String uuid) {
        Optional<class_2487> optional = this.load(name, uuid, ".dat");
        if (optional.isEmpty()) {
            this.backup(name, uuid, ".dat");
        }
        return optional.or(() -> this.load(name, uuid, ".dat_old")).map(nbttagcompound -> {
            int i = class_2512.method_48309((class_2487)nbttagcompound, (int)-1);
            nbttagcompound = class_4284.field_19213.method_48130(this.field_148, nbttagcompound, i);
            return nbttagcompound;
        });
    }

    @Override
    public File bridge$getPlayerDir() {
        return this.getPlayerDir();
    }

    @Override
    public class_2487 bridge$getPlayerData(String uuid) {
        return this.getPlayerData(uuid);
    }
}

