/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mod.mixins;

import io.izzel.arclight.common.mod.mixins.MixinProcessor;
import io.izzel.arclight.common.mod.mixins.annotation.CreateConstructor;
import io.izzel.arclight.common.mod.mixins.annotation.ShadowConstructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class CreateConstructorProcessor
implements MixinProcessor {
    private static final String SHADOW = Type.getDescriptor(ShadowConstructor.class);
    private static final String SUPER = Type.getDescriptor(ShadowConstructor.Super.class);
    private static final String CREATE = Type.getDescriptor(CreateConstructor.class);
    private static final String MERGED = Type.getDescriptor(CreateConstructor.Merged.class);

    @Override
    public void accept(String className, ClassNode classNode, IMixinInfo mixinInfo) {
        HashSet<String> shadow = new HashSet<String>();
        HashSet<String> superCall = new HashSet<String>();
        ArrayList<Object> create = new ArrayList<Object>();
        Iterator iterator = classNode.methods.iterator();
        block0: while (iterator.hasNext()) {
            MethodNode method = (MethodNode)iterator.next();
            if (Modifier.isStatic(method.access) || method.invisibleAnnotations == null) continue;
            for (AnnotationNode ann : method.invisibleAnnotations) {
                if (SHADOW.equals(ann.desc)) {
                    shadow.add(method.name + method.desc);
                    iterator.remove();
                    continue block0;
                }
                if (CREATE.equals(ann.desc)) {
                    create.add(method);
                    continue block0;
                }
                if (!SUPER.equals(ann.desc)) continue;
                superCall.add(method.name + method.desc);
                iterator.remove();
                continue block0;
            }
        }
        if (!create.isEmpty()) {
            HashSet<String> present = new HashSet<String>();
            for (MethodNode method : classNode.methods) {
                if (!method.name.equals("<init>")) continue;
                present.add(method.desc);
            }
            List<String> invalid = shadow.stream().filter(it -> present.stream().noneMatch(it::endsWith)).toList();
            if (!invalid.isEmpty()) {
                throw new IllegalArgumentException("@ShadowConstructor refers to missing constructor. Class " + className + ", desc: " + String.join((CharSequence)", ", invalid));
            }
            List<String> duplicate = create.stream().filter(it -> present.contains(it.desc)).map(it -> it.name + it.desc).toList();
            if (!duplicate.isEmpty()) {
                throw new IllegalArgumentException("@CreateConstructor refers to present constructor. Class " + className + ", desc: " + String.join((CharSequence)", ", duplicate));
            }
            for (MethodNode methodNode : create) {
                this.remapCtor(classNode, methodNode, shadow, superCall);
            }
        }
    }

    private void remapCtor(ClassNode classNode, MethodNode methodNode, Set<String> shadow, Set<String> superCall) {
        boolean initialized = false;
        for (AbstractInsnNode node : methodNode.instructions) {
            if (!(node instanceof MethodInsnNode)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)node;
            String sig = methodInsnNode.name + methodInsnNode.desc;
            if (shadow.contains(sig)) {
                if (initialized) {
                    throw new ClassFormatError("Duplicate constructor call");
                }
                methodInsnNode.setOpcode(183);
                methodInsnNode.name = "<init>";
                initialized = true;
            }
            if (!superCall.contains(sig)) continue;
            if (initialized) {
                throw new ClassFormatError("Duplicate constructor call");
            }
            methodInsnNode.setOpcode(183);
            methodInsnNode.owner = classNode.superName;
            methodInsnNode.name = "<init>";
            initialized = true;
        }
        if (!initialized) {
            if (classNode.superName.equals("java/lang/Object")) {
                InsnList insnList = new InsnList();
                insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                insnList.add((AbstractInsnNode)new MethodInsnNode(183, "java/lang/Object", "<init>", "()V", false));
                methodNode.instructions.insert(insnList);
            } else {
                throw new ClassFormatError("No super constructor call present: " + classNode.name);
            }
        }
        for (AnnotationNode ann : methodNode.invisibleAnnotations) {
            if (!ann.desc.equals(CREATE)) continue;
            ann.desc = MERGED;
        }
        methodNode.name = "<init>";
    }
}

