/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mod.mixins;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import io.izzel.arclight.common.mod.mixins.MixinProcessor;
import io.izzel.arclight.common.mod.mixins.annotation.InlineField;
import java.lang.invoke.CallSite;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.throwables.MixinApplicatorException;

public class InlineFieldProcessor
implements MixinProcessor {
    private static final String TYPE = Type.getDescriptor(InlineField.class);

    @Override
    public void accept(String className, ClassNode classNode, IMixinInfo mixinInfo) {
        HashMap<CallSite, FieldNode> inlineFields = new HashMap<CallSite, FieldNode>();
        for (FieldNode field : classNode.fields) {
            if (field.invisibleAnnotations == null) continue;
            for (AnnotationNode ann : field.invisibleAnnotations) {
                if (!ann.desc.equals(TYPE)) continue;
                inlineFields.put((CallSite)((Object)(field.name + ";" + field.desc)), field);
            }
        }
        if (!inlineFields.isEmpty()) {
            SetMultimap fieldAccess = MultimapBuilder.hashKeys().hashSetValues().build();
            for (MethodNode method : classNode.methods) {
                for (AbstractInsnNode insn : method.instructions) {
                    if (!(insn instanceof FieldInsnNode)) continue;
                    FieldInsnNode fi = (FieldInsnNode)insn;
                    if (!fi.owner.equals(classNode.name) || !inlineFields.containsKey(fi.name + ";" + fi.desc)) continue;
                    fieldAccess.put((Object)(fi.name + ";" + fi.desc), (Object)method);
                }
            }
            for (String field : fieldAccess.keys()) {
                if (fieldAccess.get((Object)field).size() > 1) {
                    throw new MixinApplicatorException(mixinInfo, "@InlineField field " + field + " is accessed by multiple methods: " + fieldAccess.get((Object)field).stream().map(it -> it.name + it.desc).collect(Collectors.joining(", ")));
                }
                this.doInline(classNode, (FieldNode)inlineFields.get(field), (MethodNode)fieldAccess.get((Object)field).iterator().next());
            }
            classNode.fields.removeAll(inlineFields.values());
        }
    }

    private void doInline(ClassNode classNode, FieldNode fieldNode, MethodNode methodNode) {
        int indice = methodNode.maxLocals;
        methodNode.maxLocals += Type.getType((String)fieldNode.desc).getSize();
        ListIterator iterator = methodNode.instructions.iterator();
        while (iterator.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)iterator.next();
            if (!(node instanceof FieldInsnNode)) continue;
            FieldInsnNode fi = (FieldInsnNode)node;
            if (!fi.owner.equals(classNode.name) || !fi.name.equals(fieldNode.name) || !fi.desc.equals(fieldNode.desc)) continue;
            if (Modifier.isStatic(fieldNode.access) && !Modifier.isStatic(methodNode.access)) {
                methodNode.instructions.insertBefore(node, (AbstractInsnNode)new InsnNode(87));
            }
            int opcode = node.getOpcode() == 180 || node.getOpcode() == 178 ? 21 : 54;
            iterator.set(new VarInsnNode(Type.getType((String)fieldNode.desc).getOpcode(opcode), indice));
        }
        LOGGER.debug("Inlined field " + classNode.name + " " + fieldNode.name + " " + fieldNode.desc);
    }
}

