/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mod.mixins;

import io.izzel.arclight.common.mod.mixins.MixinProcessor;
import io.izzel.arclight.common.mod.mixins.annotation.InlineMethod;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.ListIterator;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.util.Locals;

public class InlineMethodProcessor
implements MixinProcessor {
    private static final String TYPE = Type.getDescriptor(InlineMethod.class);
    private static final String MERGED = Type.getDescriptor(InlineMethod.Merged.class);

    @Override
    public void accept(String className, ClassNode classNode, IMixinInfo mixinInfo) {
        Iterator iterator = classNode.methods.iterator();
        while (iterator.hasNext()) {
            MethodNode methodNode = (MethodNode)iterator.next();
            if (methodNode.invisibleAnnotations == null) continue;
            for (AnnotationNode ann : methodNode.invisibleAnnotations) {
                if (!ann.desc.equals(TYPE)) continue;
                new MethodInliner(methodNode, classNode).accept();
                ann.desc = MERGED;
                iterator.remove();
            }
        }
    }

    private record MethodInliner(MethodNode target, ClassNode callerClass) {
        public void accept() {
            for (MethodNode node : this.callerClass.methods) {
                this.accept(node);
            }
        }

        public void accept(MethodNode node) {
            ListIterator iterator = node.instructions.iterator();
            while (iterator.hasNext()) {
                AbstractInsnNode insn = (AbstractInsnNode)iterator.next();
                if (!(insn instanceof MethodInsnNode)) continue;
                MethodInsnNode method = (MethodInsnNode)insn;
                if (!method.owner.equals(this.callerClass.name) || !method.name.equals(this.target.name) || !method.desc.equals(this.target.desc)) continue;
                MethodNode buf = new MethodNode(589824, node.access, node.name, node.desc, node.signature, (String[])node.exceptions.toArray(String[]::new));
                this.target.accept((MethodVisitor)new RemappingVisitor(589824, (MethodVisitor)buf, Locals.getLocalsAt((ClassNode)this.callerClass, (MethodNode)node, (AbstractInsnNode)insn, (Locals.Settings)Locals.Settings.DEFAULT)));
                node.instructions.insertBefore(insn, buf.instructions);
                node.tryCatchBlocks.addAll(buf.tryCatchBlocks);
                node.localVariables.addAll(buf.localVariables);
                node.maxLocals = Math.max(node.maxLocals, buf.maxLocals);
                node.maxStack = Math.max(node.maxStack, buf.maxStack);
                iterator.remove();
            }
        }

        protected class RemappingVisitor
        extends MethodVisitor {
            private final Label end;
            private final Type returnType;
            private final LocalVariableNode[] locals;
            private final int localOffset;
            private final int localCount;

            protected RemappingVisitor(int api, MethodVisitor mv, LocalVariableNode[] locals) {
                super(api, mv);
                this.end = new Label();
                this.returnType = Type.getReturnType((String)MethodInliner.this.target.desc);
                this.locals = locals;
                int offset = 0;
                int count = 0;
                for (int i = 0; i < locals.length; ++i) {
                    LocalVariableNode local = locals[i];
                    if (local == null) continue;
                    offset = Math.max(offset, local.index + Type.getType((String)local.desc).getSize());
                    count = i + 1;
                }
                this.localOffset = offset;
                this.localCount = count;
                this.visitStart();
            }

            protected void visitStart() {
                int offset = Modifier.isStatic(MethodInliner.this.target.access) ? 0 : 1;
                Type[] args = Type.getArgumentTypes((String)MethodInliner.this.target.desc);
                for (int i = args.length - 1; i >= 0; --i) {
                    super.visitVarInsn(args[i].getOpcode(54), this.localOffset + i + offset);
                }
                if (offset > 0) {
                    super.visitVarInsn(58, this.localOffset);
                }
            }

            public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                if (owner.equals(MethodInliner.this.callerClass.name) && name.equals(MethodInliner.this.target.name) && descriptor.equals(MethodInliner.this.target.desc)) {
                    throw new IllegalStateException("Inlining recursive method");
                }
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            }

            public void visitVarInsn(int opcode, int varIndex) {
                super.visitVarInsn(opcode, this.localOffset + varIndex);
            }

            public void visitIincInsn(int varIndex, int increment) {
                super.visitIincInsn(this.localOffset + varIndex, increment);
            }

            public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
                super.visitLocalVariable(name, descriptor, signature, start, end, this.localOffset + index);
            }

            public void visitMaxs(int maxStack, int maxLocals) {
                super.visitMaxs(maxStack, this.localOffset + maxLocals);
            }

            public void visitInsn(int opcode) {
                if (opcode == this.returnType.getOpcode(172)) {
                    super.visitJumpInsn(167, this.end);
                } else {
                    super.visitInsn(opcode);
                }
            }

            public void visitEnd() {
                super.visitLabel(this.end);
                Object[] locals = new Object[this.localCount];
                for (int i = 0; i < this.localCount; ++i) {
                    Object v;
                    LocalVariableNode local = this.locals[i];
                    if (local == null) {
                        locals[i] = null;
                        continue;
                    }
                    Type type = Type.getType((String)local.desc);
                    locals[i] = v = (switch (type.getSort()) {
                        case 1, 2, 3, 4, 5 -> Opcodes.INTEGER;
                        case 6 -> Opcodes.FLOAT;
                        case 7 -> Opcodes.LONG;
                        case 8 -> Opcodes.DOUBLE;
                        case 9, 10 -> type.getInternalName();
                        default -> Opcodes.TOP;
                    });
                }
                super.visitFrame(0, this.localCount, locals, 0, null);
                super.visitEnd();
            }
        }
    }
}

