/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mod.util;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_3176;
import net.minecrell.terminalconsole.TerminalConsoleAppender;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.ParsedLine;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;

public class ArclightTerminalReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean handleCommands(class_3176 server) {
        Terminal terminal = TerminalConsoleAppender.getTerminal();
        if (terminal == null) {
            return false;
        }
        LineReader reader = LineReaderBuilder.builder().appName("Arclight").terminal(terminal).completer((Completer)new ConsoleCommandCompleter(server)).build();
        reader.setOpt(LineReader.Option.DISABLE_EVENT_EXPANSION);
        reader.unsetOpt(LineReader.Option.INSERT_TAB);
        TerminalConsoleAppender.setReader((LineReader)reader);
        try {
            while (!server.method_3750() && server.method_3806()) {
                String line;
                try {
                    line = reader.readLine("> ");
                }
                catch (EndOfFileException ignored) {
                    continue;
                }
                if (line == null) {
                    break;
                }
                if ((line = line.trim()).isEmpty()) continue;
                server.method_13947(line, server.method_3739());
            }
        }
        catch (UserInterruptException e) {
            server.close();
        }
        finally {
            TerminalConsoleAppender.setReader(null);
        }
        return true;
    }

    static final class ConsoleCommandCompleter
    implements Completer {
        private static final Logger logger = LogManager.getLogger();
        private final class_3176 server;

        public ConsoleCommandCompleter(class_3176 server) {
            this.server = (class_3176)Preconditions.checkNotNull((Object)server, (Object)"server");
        }

        public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
            boolean prefix;
            Object buffer = line.line();
            if (((String)buffer).isEmpty() || ((String)buffer).charAt(0) != '/') {
                buffer = "/" + (String)buffer;
                prefix = false;
            } else {
                prefix = true;
            }
            Object input = buffer;
            StringReader stringReader = new StringReader((String)input);
            if (stringReader.canRead() && stringReader.peek() == '/') {
                stringReader.skip();
            }
            try {
                ParseResults results = this.server.method_3734().method_9235().parse(stringReader, (Object)this.server.method_3739());
                Suggestions tabComplete = (Suggestions)this.server.method_3734().method_9235().getCompletionSuggestions(results).get();
                for (Suggestion suggestion : tabComplete.getList()) {
                    String completion = suggestion.getText();
                    if (completion.isEmpty()) continue;
                    boolean hasPrefix = prefix || completion.charAt(0) != '/';
                    Candidate candidate = new Candidate(hasPrefix ? completion : completion.substring(1));
                    candidates.add(candidate);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                logger.error("Failed to tab complete", (Throwable)e);
            }
        }
    }
}

