/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mod.util;

import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.izzel.arclight.i18n.ArclightConfig;
import io.netty.buffer.Unpooled;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_7428;
import net.minecraft.class_8595;
import org.jetbrains.annotations.NotNull;

public class VelocitySupport {
    private static final int SUPPORTED_FORWARDING_VERSION = 1;
    public static final int MODERN_FORWARDING_WITH_KEY = 2;
    public static final int MODERN_FORWARDING_WITH_KEY_V2 = 3;
    public static final int MODERN_LAZY_SESSION = 4;
    public static final byte MAX_SUPPORTED_FORWARDING_VERSION = 4;
    public static final class_2960 PLAYER_INFO_CHANNEL = class_2960.method_60654((String)"velocity:player_info");

    public static boolean isEnabled() {
        return ArclightConfig.spec().getVelocity().isEnable();
    }

    public static class_8595 createPacket() {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_52997(4);
        return new VelocityForwardQuery(buf);
    }

    public static boolean checkIntegrity(class_2540 buf) {
        byte[] signature = new byte[32];
        buf.method_52979(signature);
        byte[] data = new byte[buf.readableBytes()];
        buf.method_52952(buf.readerIndex(), data);
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(ArclightConfig.spec().getVelocity().getSecret().getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
            byte[] mySignature = mac.doFinal(data);
            if (!MessageDigest.isEqual(signature, mySignature)) {
                return false;
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        return true;
    }

    public static InetAddress readAddress(class_2540 buf) {
        return InetAddresses.forString((String)buf.method_10800(Short.MAX_VALUE));
    }

    public static GameProfile createProfile(class_2540 buf) {
        GameProfile profile = new GameProfile(buf.method_10790(), buf.method_10800(16));
        VelocitySupport.readProperties(buf, profile);
        return profile;
    }

    private static void readProperties(class_2540 buf, GameProfile profile) {
        int properties = buf.method_10816();
        for (int i1 = 0; i1 < properties; ++i1) {
            String name = buf.method_10800(Short.MAX_VALUE);
            String value = buf.method_10800(Short.MAX_VALUE);
            String signature = buf.readBoolean() ? buf.method_10800(Short.MAX_VALUE) : null;
            profile.getProperties().put((Object)name, (Object)new Property(name, value, signature));
        }
    }

    public static class_7428.class_7443 readForwardedKey(class_2540 buf) {
        return new class_7428.class_7443(buf);
    }

    public static UUID readSignerUuidOrElse(class_2540 buf, UUID orElse) {
        return buf.readBoolean() ? buf.method_10790() : orElse;
    }

    private record VelocityForwardQuery(class_2540 data) implements class_8595
    {
        @NotNull
        public class_2960 comp_1571() {
            return PLAYER_INFO_CHANNEL;
        }

        public void method_52296(@NotNull class_2540 buf) {
            buf.method_52975(this.data.slice());
        }
    }
}

