/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.fabric.boot;

import io.izzel.arclight.boot.asm.AsyncCatcher;
import io.izzel.arclight.boot.asm.EnumDefinalizer;
import io.izzel.arclight.boot.asm.Implementer;
import io.izzel.arclight.boot.asm.InventoryImplementer;
import io.izzel.arclight.boot.asm.LoggerTransformer;
import io.izzel.arclight.boot.asm.SwitchTableFixer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.LogManager;
import net.fabricmc.loader.impl.game.patch.GamePatch;
import net.fabricmc.loader.impl.game.patch.GameTransformer;
import net.fabricmc.loader.impl.launch.FabricLauncher;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class ArclightImplementer
extends GameTransformer {
    private final GameTransformer delegate;
    private final MethodHandle getRawClassByteArray;
    private final Map<String, Implementer> implementers = new HashMap<String, Implementer>();

    public ArclightImplementer(GameTransformer delegate, FabricLauncher launcher) throws Exception {
        super(new GamePatch[0]);
        this.delegate = delegate;
        Field field = launcher.getClass().getDeclaredField("classLoader");
        field.setAccessible(true);
        Object knotCl = field.get(launcher);
        Method method = knotCl.getClass().getDeclaredMethod("getRawClassByteArray", String.class, Boolean.TYPE);
        method.setAccessible(true);
        this.getRawClassByteArray = MethodHandles.lookup().unreflect(method).bindTo(knotCl);
        this.implementers.put("inventory", new InventoryImplementer());
        this.implementers.put("switch", SwitchTableFixer.INSTANCE);
        this.implementers.put("async", AsyncCatcher.INSTANCE);
        this.implementers.put("enum", new EnumDefinalizer());
        boolean logger = ArclightImplementer.detectTransformLogger();
        if (logger) {
            this.implementers.put("logger", new LoggerTransformer());
        }
    }

    public void locateEntrypoints(FabricLauncher launcher, List<Path> gameJars) {
        this.delegate.locateEntrypoints(launcher, gameJars);
    }

    public byte[] transform(String className) {
        byte[] bytes = this.delegate.transform(className);
        if (bytes == null) {
            try {
                bytes = this.getRawClassByteArray.invokeExact(className, false);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        if (bytes != null) {
            ClassReader reader = new ClassReader(bytes);
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 0);
            for (Map.Entry<String, Implementer> entry : this.implementers.entrySet()) {
                Implementer implementer = entry.getValue();
                implementer.processClass(node);
            }
            ClassWriter cw = new ClassWriter(0);
            node.accept((ClassVisitor)cw);
            bytes = cw.toByteArray();
        }
        return bytes;
    }

    private static boolean detectTransformLogger() {
        boolean transformLogger;
        boolean bl = transformLogger = !LogManager.getLogManager().getClass().getName().equals("org.apache.logging.log4j.jul.LogManager");
        if (transformLogger && !System.getProperties().contains("log4j.jul.LoggerAdapter")) {
            System.setProperty("log4j.jul.LoggerAdapter", "io.izzel.arclight.boot.log.ArclightLoggerAdapter");
        }
        return transformLogger;
    }
}

