/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3763;
import net.minecraft.class_3765;
import org.bukkit.Location;
import org.bukkit.Raid;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.Raider;

public final class CraftRaid
implements Raid {
    private final class_3765 handle;

    public CraftRaid(class_3765 handle) {
        this.handle = handle;
    }

    @Override
    public boolean isStarted() {
        return this.handle.method_16524();
    }

    @Override
    public long getActiveTicks() {
        return this.handle.field_16605;
    }

    @Override
    public int getBadOmenLevel() {
        return this.handle.field_16623;
    }

    @Override
    public void setBadOmenLevel(int badOmenLevel) {
        int max = this.handle.method_16514();
        Preconditions.checkArgument((0 <= badOmenLevel && badOmenLevel <= max ? 1 : 0) != 0, (String)"Bad Omen level must be between 0 and %s", (int)max);
        this.handle.field_16623 = badOmenLevel;
    }

    @Override
    public Location getLocation() {
        class_2338 pos = this.handle.method_16495();
        class_1937 world = this.handle.method_16831();
        return CraftLocation.toBukkit(pos, (World)world.getWorld());
    }

    @Override
    public Raid.RaidStatus getStatus() {
        if (this.handle.method_20022()) {
            return Raid.RaidStatus.STOPPED;
        }
        if (this.handle.method_20023()) {
            return Raid.RaidStatus.VICTORY;
        }
        if (this.handle.method_20024()) {
            return Raid.RaidStatus.LOSS;
        }
        return Raid.RaidStatus.ONGOING;
    }

    @Override
    public int getSpawnedGroups() {
        return this.handle.method_16490();
    }

    @Override
    public int getTotalGroups() {
        return this.handle.field_19022 + (this.handle.field_16623 > 1 ? 1 : 0);
    }

    @Override
    public int getTotalWaves() {
        return this.handle.field_19022;
    }

    @Override
    public float getTotalHealth() {
        return this.handle.method_16513();
    }

    @Override
    public Set<UUID> getHeroes() {
        return Collections.unmodifiableSet(this.handle.field_19021);
    }

    @Override
    public List<Raider> getRaiders() {
        return (List)this.handle.getRaiders().stream().map(new Function<class_3763, Raider>(this){

            @Override
            public Raider apply(class_3763 entityRaider) {
                return (Raider)((Object)entityRaider.getBukkitEntity());
            }
        }).collect(ImmutableList.toImmutableList());
    }

    public class_3765 getHandle() {
        return this.handle;
    }
}

