/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_274;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3442;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import net.minecraft.class_7923;
import net.minecraft.class_9015;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemType;
import org.bukkit.entity.EntityType;

public enum CraftStatistic {
    DAMAGE_DEALT(class_3468.field_15399),
    DAMAGE_TAKEN(class_3468.field_15388),
    DEATHS(class_3468.field_15421),
    MOB_KILLS(class_3468.field_15414),
    PLAYER_KILLS(class_3468.field_15404),
    FISH_CAUGHT(class_3468.field_15391),
    ANIMALS_BRED(class_3468.field_15410),
    LEAVE_GAME(class_3468.field_15389),
    JUMP(class_3468.field_15428),
    DROP_COUNT(class_3468.field_15406),
    DROP(class_2960.method_60656((String)"dropped")),
    PICKUP(class_2960.method_60656((String)"picked_up")),
    PLAY_ONE_MINUTE(class_3468.field_15417),
    TOTAL_WORLD_TIME(class_3468.field_33558),
    WALK_ONE_CM(class_3468.field_15377),
    WALK_ON_WATER_ONE_CM(class_3468.field_15394),
    FALL_ONE_CM(class_3468.field_15386),
    SNEAK_TIME(class_3468.field_15422),
    CLIMB_ONE_CM(class_3468.field_15413),
    FLY_ONE_CM(class_3468.field_15426),
    WALK_UNDER_WATER_ONE_CM(class_3468.field_15401),
    MINECART_ONE_CM(class_3468.field_15409),
    BOAT_ONE_CM(class_3468.field_15415),
    PIG_ONE_CM(class_3468.field_15387),
    HORSE_ONE_CM(class_3468.field_15396),
    SPRINT_ONE_CM(class_3468.field_15364),
    CROUCH_ONE_CM(class_3468.field_15376),
    AVIATE_ONE_CM(class_3468.field_15374),
    MINE_BLOCK(class_2960.method_60656((String)"mined")),
    USE_ITEM(class_2960.method_60656((String)"used")),
    BREAK_ITEM(class_2960.method_60656((String)"broken")),
    CRAFT_ITEM(class_2960.method_60656((String)"crafted")),
    KILL_ENTITY(class_2960.method_60656((String)"killed")),
    ENTITY_KILLED_BY(class_2960.method_60656((String)"killed_by")),
    TIME_SINCE_DEATH(class_3468.field_15400),
    TALKED_TO_VILLAGER(class_3468.field_15384),
    TRADED_WITH_VILLAGER(class_3468.field_15378),
    CAKE_SLICES_EATEN(class_3468.field_15369),
    CAULDRON_FILLED(class_3468.field_15430),
    CAULDRON_USED(class_3468.field_15373),
    ARMOR_CLEANED(class_3468.field_15382),
    BANNER_CLEANED(class_3468.field_15390),
    BREWINGSTAND_INTERACTION(class_3468.field_15407),
    BEACON_INTERACTION(class_3468.field_15416),
    DROPPER_INSPECTED(class_3468.field_15367),
    HOPPER_INSPECTED(class_3468.field_15366),
    DISPENSER_INSPECTED(class_3468.field_15371),
    NOTEBLOCK_PLAYED(class_3468.field_15385),
    NOTEBLOCK_TUNED(class_3468.field_15393),
    FLOWER_POTTED(class_3468.field_15412),
    TRAPPED_CHEST_TRIGGERED(class_3468.field_15402),
    ENDERCHEST_OPENED(class_3468.field_15424),
    ITEM_ENCHANTED(class_3468.field_15420),
    RECORD_PLAYED(class_3468.field_15375),
    FURNACE_INTERACTION(class_3468.field_15379),
    CRAFTING_TABLE_INTERACTION(class_3468.field_15368),
    CHEST_OPENED(class_3468.field_15395),
    SLEEP_IN_BED(class_3468.field_15381),
    SHULKER_BOX_OPENED(class_3468.field_15418),
    TIME_SINCE_REST(class_3468.field_15429),
    SWIM_ONE_CM(class_3468.field_15423),
    DAMAGE_DEALT_ABSORBED(class_3468.field_15408),
    DAMAGE_DEALT_RESISTED(class_3468.field_15397),
    DAMAGE_BLOCKED_BY_SHIELD(class_3468.field_15380),
    DAMAGE_ABSORBED(class_3468.field_15365),
    DAMAGE_RESISTED(class_3468.field_15425),
    CLEAN_SHULKER_BOX(class_3468.field_15398),
    OPEN_BARREL(class_3468.field_17271),
    INTERACT_WITH_BLAST_FURNACE(class_3468.field_17272),
    INTERACT_WITH_SMOKER(class_3468.field_17273),
    INTERACT_WITH_LECTERN(class_3468.field_17485),
    INTERACT_WITH_CAMPFIRE(class_3468.field_17486),
    INTERACT_WITH_CARTOGRAPHY_TABLE(class_3468.field_19252),
    INTERACT_WITH_LOOM(class_3468.field_19253),
    INTERACT_WITH_STONECUTTER(class_3468.field_19254),
    BELL_RING(class_3468.field_19255),
    RAID_TRIGGER(class_3468.field_19256),
    RAID_WIN(class_3468.field_19257),
    INTERACT_WITH_ANVIL(class_3468.field_21778),
    INTERACT_WITH_GRINDSTONE(class_3468.field_21779),
    TARGET_HIT(class_3468.field_22413),
    INTERACT_WITH_SMITHING_TABLE(class_3468.field_22464),
    STRIDER_ONE_CM(class_3468.field_24458);

    private final class_2960 minecraftKey;
    private final Statistic bukkit;
    private static final BiMap<class_2960, Statistic> statistics;

    private CraftStatistic(class_2960 minecraftKey) {
        this.minecraftKey = minecraftKey;
        this.bukkit = Statistic.valueOf(this.name());
        Preconditions.checkState((this.bukkit != null ? 1 : 0) != 0, (String)"Bukkit statistic %s does not exist", (Object)this.name());
    }

    public static Statistic getBukkitStatistic(class_3445<?> statistic) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"NMS Statistic cannot be null");
        class_2378 statRegistry = statistic.method_14949().method_14959();
        class_2960 nmsKey = class_7923.field_41193.method_10221((Object)statistic.method_14949());
        if (statRegistry == class_7923.field_41183) {
            nmsKey = (class_2960)statistic.method_14951();
        }
        return (Statistic)statistics.get((Object)nmsKey);
    }

    public static class_3445 getNMSStatistic(Statistic bukkit) {
        Preconditions.checkArgument((bukkit.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (Object)"This method only accepts untyped statistics");
        class_3445 nms = class_3468.field_15419.method_14956((Object)((class_2960)statistics.inverse().get((Object)bukkit)));
        Preconditions.checkArgument((nms != null ? 1 : 0) != 0, (String)"NMS Statistic %s does not exist", (Object)bukkit);
        return nms;
    }

    public static class_3445 getMaterialStatistic(Statistic stat, Material material) {
        try {
            if (stat == Statistic.MINE_BLOCK) {
                return class_3468.field_15427.method_14956((Object)CraftBlockType.bukkitToMinecraft(material));
            }
            if (stat == Statistic.CRAFT_ITEM) {
                return class_3468.field_15370.method_14956((Object)CraftItemType.bukkitToMinecraft(material));
            }
            if (stat == Statistic.USE_ITEM) {
                return class_3468.field_15372.method_14956((Object)CraftItemType.bukkitToMinecraft(material));
            }
            if (stat == Statistic.BREAK_ITEM) {
                return class_3468.field_15383.method_14956((Object)CraftItemType.bukkitToMinecraft(material));
            }
            if (stat == Statistic.PICKUP) {
                return class_3468.field_15392.method_14956((Object)CraftItemType.bukkitToMinecraft(material));
            }
            if (stat == Statistic.DROP) {
                return class_3468.field_15405.method_14956((Object)CraftItemType.bukkitToMinecraft(material));
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
        return null;
    }

    public static class_3445 getEntityStatistic(Statistic stat, EntityType entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"EntityType cannot be null");
        if (entity.getName() != null) {
            class_1299<?> nmsEntity = CraftEntityType.bukkitToMinecraft(entity);
            if (stat == Statistic.KILL_ENTITY) {
                return class_3468.field_15403.method_14956(nmsEntity);
            }
            if (stat == Statistic.ENTITY_KILLED_BY) {
                return class_3468.field_15411.method_14956(nmsEntity);
            }
        }
        return null;
    }

    public static EntityType getEntityTypeFromStatistic(class_3445<class_1299<?>> statistic) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"NMS Statistic cannot be null");
        return CraftEntityType.minecraftToBukkit((class_1299)statistic.method_14951());
    }

    public static Material getMaterialFromStatistic(class_3445<?> statistic) {
        Object object = statistic.method_14951();
        if (object instanceof class_1792) {
            class_1792 statisticItemValue = (class_1792)object;
            return CraftItemType.minecraftToBukkit(statisticItemValue);
        }
        object = statistic.method_14951();
        if (object instanceof class_2248) {
            class_2248 statisticBlockValue = (class_2248)object;
            return CraftBlockType.minecraftToBukkit(statisticBlockValue);
        }
        return null;
    }

    public static void incrementStatistic(class_3442 manager, Statistic statistic, class_3222 player) {
        CraftStatistic.incrementStatistic(manager, statistic, 1, player);
    }

    public static void decrementStatistic(class_3442 manager, Statistic statistic, class_3222 player) {
        CraftStatistic.decrementStatistic(manager, statistic, 1, player);
    }

    public static int getStatistic(class_3442 manager, Statistic statistic) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (Object)"Must supply additional parameter for this statistic");
        return manager.method_15025(CraftStatistic.getNMSStatistic(statistic));
    }

    public static void incrementStatistic(class_3442 manager, Statistic statistic, int amount, class_3222 player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, CraftStatistic.getStatistic(manager, statistic) + amount, player);
    }

    public static void decrementStatistic(class_3442 manager, Statistic statistic, int amount, class_3222 player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, CraftStatistic.getStatistic(manager, statistic) - amount, player);
    }

    public static void setStatistic(class_3442 manager, Statistic statistic, int newValue, class_3222 player) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (Object)"Must supply additional parameter for this statistic");
        Preconditions.checkArgument((newValue >= 0 ? 1 : 0) != 0, (Object)"Value must be greater than or equal to 0");
        class_3445 nmsStatistic = CraftStatistic.getNMSStatistic(statistic);
        manager.method_15023(null, nmsStatistic, newValue);
        if (player != null) {
            player.method_37908().getCraftServer().getScoreboardManager().forAllObjectives((class_274)nmsStatistic, (class_9015)player, score -> score.method_55410(newValue));
        }
    }

    public static void incrementStatistic(class_3442 manager, Statistic statistic, Material material, class_3222 player) {
        CraftStatistic.incrementStatistic(manager, statistic, material, 1, player);
    }

    public static void decrementStatistic(class_3442 manager, Statistic statistic, Material material, class_3222 player) {
        CraftStatistic.decrementStatistic(manager, statistic, material, 1, player);
    }

    public static int getStatistic(class_3442 manager, Statistic statistic, Material material) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM ? 1 : 0) != 0, (Object)"This statistic does not take a Material parameter");
        class_3445 nmsStatistic = CraftStatistic.getMaterialStatistic(statistic, material);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied Material %s does not have a corresponding statistic", (Object)material);
        return manager.method_15025(nmsStatistic);
    }

    public static void incrementStatistic(class_3442 manager, Statistic statistic, Material material, int amount, class_3222 player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, material, CraftStatistic.getStatistic(manager, statistic, material) + amount, player);
    }

    public static void decrementStatistic(class_3442 manager, Statistic statistic, Material material, int amount, class_3222 player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, material, CraftStatistic.getStatistic(manager, statistic, material) - amount, player);
    }

    public static void setStatistic(class_3442 manager, Statistic statistic, Material material, int newValue, class_3222 player) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((newValue >= 0 ? 1 : 0) != 0, (Object)"Value must be greater than or equal to 0");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM ? 1 : 0) != 0, (Object)"This statistic does not take a Material parameter");
        class_3445 nmsStatistic = CraftStatistic.getMaterialStatistic(statistic, material);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied Material %s does not have a corresponding statistic", (Object)material);
        manager.method_15023(null, nmsStatistic, newValue);
        if (player != null) {
            player.method_37908().getCraftServer().getScoreboardManager().forAllObjectives((class_274)nmsStatistic, (class_9015)player, score -> score.method_55410(newValue));
        }
    }

    public static void incrementStatistic(class_3442 manager, Statistic statistic, EntityType entityType, class_3222 player) {
        CraftStatistic.incrementStatistic(manager, statistic, entityType, 1, player);
    }

    public static void decrementStatistic(class_3442 manager, Statistic statistic, EntityType entityType, class_3222 player) {
        CraftStatistic.decrementStatistic(manager, statistic, entityType, 1, player);
    }

    public static int getStatistic(class_3442 manager, Statistic statistic, EntityType entityType) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((entityType != null ? 1 : 0) != 0, (Object)"EntityType cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.ENTITY ? 1 : 0) != 0, (Object)"This statistic does not take an EntityType parameter");
        class_3445 nmsStatistic = CraftStatistic.getEntityStatistic(statistic, entityType);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied EntityType %s does not have a corresponding statistic", (Object)entityType);
        return manager.method_15025(nmsStatistic);
    }

    public static void incrementStatistic(class_3442 manager, Statistic statistic, EntityType entityType, int amount, class_3222 player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, entityType, CraftStatistic.getStatistic(manager, statistic, entityType) + amount, player);
    }

    public static void decrementStatistic(class_3442 manager, Statistic statistic, EntityType entityType, int amount, class_3222 player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, entityType, CraftStatistic.getStatistic(manager, statistic, entityType) - amount, player);
    }

    public static void setStatistic(class_3442 manager, Statistic statistic, EntityType entityType, int newValue, class_3222 player) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((entityType != null ? 1 : 0) != 0, (Object)"EntityType cannot be null");
        Preconditions.checkArgument((newValue >= 0 ? 1 : 0) != 0, (Object)"Value must be greater than or equal to 0");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.ENTITY ? 1 : 0) != 0, (Object)"This statistic does not take an EntityType parameter");
        class_3445 nmsStatistic = CraftStatistic.getEntityStatistic(statistic, entityType);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied EntityType %s does not have a corresponding statistic", (Object)entityType);
        manager.method_15023(null, nmsStatistic, newValue);
        if (player != null) {
            player.method_37908().getCraftServer().getScoreboardManager().forAllObjectives((class_274)nmsStatistic, (class_9015)player, score -> score.method_55410(newValue));
        }
    }

    static {
        ImmutableBiMap.Builder statisticBuilder = ImmutableBiMap.builder();
        for (CraftStatistic statistic : CraftStatistic.values()) {
            statisticBuilder.put((Object)statistic.minecraftKey, (Object)statistic.bukkit);
        }
        statistics = statisticBuilder.build();
    }
}

