/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.attribute;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;

public class CraftAttributeInstance
implements AttributeInstance {
    private final class_1324 handle;
    private final Attribute attribute;

    public CraftAttributeInstance(class_1324 handle, Attribute attribute) {
        this.handle = handle;
        this.attribute = attribute;
    }

    @Override
    public Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    public double getBaseValue() {
        return this.handle.method_6201();
    }

    @Override
    public void setBaseValue(double d) {
        this.handle.method_6192(d);
    }

    @Override
    public Collection<AttributeModifier> getModifiers() {
        ArrayList<AttributeModifier> result = new ArrayList<AttributeModifier>();
        for (class_1322 nms : this.handle.method_6195()) {
            result.add(CraftAttributeInstance.convert(nms));
        }
        return result;
    }

    @Override
    public void addModifier(AttributeModifier modifier) {
        Preconditions.checkArgument((modifier != null ? 1 : 0) != 0, (Object)"modifier");
        this.handle.method_26837(CraftAttributeInstance.convert(modifier));
    }

    @Override
    public void removeModifier(AttributeModifier modifier) {
        Preconditions.checkArgument((modifier != null ? 1 : 0) != 0, (Object)"modifier");
        this.handle.method_6202(CraftAttributeInstance.convert(modifier));
    }

    @Override
    public double getValue() {
        return this.handle.method_6194();
    }

    @Override
    public double getDefaultValue() {
        return ((class_1320)this.handle.method_6198().comp_349()).method_6169();
    }

    public static class_1322 convert(AttributeModifier bukkit) {
        return new class_1322(CraftNamespacedKey.toMinecraft(bukkit.getKey()), bukkit.getAmount(), class_1322.class_1323.values()[bukkit.getOperation().ordinal()]);
    }

    public static AttributeModifier convert(class_1322 nms) {
        return new AttributeModifier(CraftNamespacedKey.fromMinecraft(nms.comp_2447()), nms.comp_2449(), AttributeModifier.Operation.values()[nms.comp_2450().ordinal()], EquipmentSlotGroup.ANY);
    }

    public static AttributeModifier convert(class_1322 nms, EquipmentSlot slot) {
        return new AttributeModifier(CraftNamespacedKey.fromMinecraft(nms.comp_2447()), nms.comp_2449(), AttributeModifier.Operation.values()[nms.comp_2450().ordinal()], slot.getGroup());
    }
}

