/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.block;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_4482;
import net.minecraft.class_5819;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;

public final class CapturedBlockState
extends CraftBlockState {
    private final boolean treeBlock;

    public CapturedBlockState(Block block, int flag, boolean treeBlock) {
        super(block, flag);
        this.treeBlock = treeBlock;
    }

    protected CapturedBlockState(CapturedBlockState state, Location location) {
        super(state, location);
        this.treeBlock = state.treeBlock;
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        boolean result = super.update(force, applyPhysics);
        this.addBees();
        return result;
    }

    private void updatedTree() {
        this.world.getHandle().method_8652(CraftLocation.toBlockPosition(this.getLocation()), this.getHandle(), this.getFlag());
        this.addBees();
    }

    private void addBees() {
        if (this.treeBlock && this.getType() == Material.BEE_NEST) {
            class_3218 generatoraccessseed = this.world.getHandle();
            class_2338 blockposition1 = this.getPosition();
            class_5819 random = generatoraccessseed.method_8409();
            class_2586 tileentity = generatoraccessseed.method_8321(blockposition1);
            if (tileentity instanceof class_4482) {
                class_4482 tileentitybeehive = (class_4482)tileentity;
                int j = 2 + random.method_43048(2);
                for (int k = 0; k < j; ++k) {
                    tileentitybeehive.method_35292(class_4482.class_9309.method_57584((int)random.method_43048(599)));
                }
            }
        }
    }

    @Override
    public CapturedBlockState copy() {
        return new CapturedBlockState(this, null);
    }

    @Override
    public CapturedBlockState copy(Location location) {
        return new CapturedBlockState(this, location);
    }

    public static CapturedBlockState getBlockState(class_1937 world, class_2338 pos, int flag) {
        return new CapturedBlockState(world.getWorld().getBlockAt(pos.method_10263(), pos.method_10264(), pos.method_10260()), flag, false);
    }

    public static CapturedBlockState getTreeBlockState(class_1937 world, class_2338 pos, int flag) {
        return new CapturedBlockState(world.getWorld().getBlockAt(pos.method_10263(), pos.method_10264(), pos.method_10260()), flag, true);
    }

    public static void setBlockState(BlockState blockState) {
        if (blockState instanceof CapturedBlockState) {
            CapturedBlockState capturedBlockState = (CapturedBlockState)blockState;
            capturedBlockState.updatedTree();
        } else {
            blockState.update(true);
        }
    }
}

