/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.block;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1767;
import net.minecraft.class_2185;
import net.minecraft.class_2573;
import net.minecraft.class_2582;
import net.minecraft.class_6880;
import net.minecraft.class_9307;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Banner;
import org.bukkit.block.banner.Pattern;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R1.block.banner.CraftPatternType;

public class CraftBanner
extends CraftBlockEntityState<class_2573>
implements Banner {
    private DyeColor base;
    private List<Pattern> patterns;

    public CraftBanner(World world, class_2573 tileEntity) {
        super(world, tileEntity);
    }

    protected CraftBanner(CraftBanner state, Location location) {
        super(state, location);
    }

    @Override
    public void load(class_2573 banner) {
        super.load(banner);
        this.base = DyeColor.getByWoolData((byte)((class_2185)this.data.method_26204()).method_9303().method_7789());
        this.patterns = new ArrayList<Pattern>();
        if (banner.method_58122() != null) {
            for (int i = 0; i < banner.method_58122().comp_2428().size(); ++i) {
                class_9307.class_9308 p = (class_9307.class_9308)banner.method_58122().comp_2428().get(i);
                this.patterns.add(new Pattern(DyeColor.getByWoolData((byte)p.comp_2430().method_7789()), CraftPatternType.minecraftHolderToBukkit((class_6880<class_2582>)p.comp_2429())));
            }
        }
    }

    @Override
    public DyeColor getBaseColor() {
        return this.base;
    }

    @Override
    public void setBaseColor(DyeColor color) {
        Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"color");
        this.base = color;
    }

    @Override
    public List<Pattern> getPatterns() {
        return new ArrayList<Pattern>(this.patterns);
    }

    @Override
    public void setPatterns(List<Pattern> patterns) {
        this.patterns = new ArrayList<Pattern>(patterns);
    }

    @Override
    public void addPattern(Pattern pattern) {
        this.patterns.add(pattern);
    }

    @Override
    public Pattern getPattern(int i) {
        return this.patterns.get(i);
    }

    @Override
    public Pattern removePattern(int i) {
        return this.patterns.remove(i);
    }

    @Override
    public void setPattern(int i, Pattern pattern) {
        this.patterns.set(i, pattern);
    }

    @Override
    public int numberOfPatterns() {
        return this.patterns.size();
    }

    @Override
    public void applyTo(class_2573 banner) {
        super.applyTo(banner);
        banner.field_11774 = class_1767.method_7791((int)this.base.getWoolData());
        ArrayList<class_9307.class_9308> newPatterns = new ArrayList<class_9307.class_9308>();
        for (Pattern p : this.patterns) {
            newPatterns.add(new class_9307.class_9308(CraftPatternType.bukkitToMinecraftHolder(p.getPattern()), class_1767.method_7791((int)p.getColor().getWoolData())));
        }
        banner.setPatterns(new class_9307(newPatterns));
    }

    @Override
    public CraftBanner copy() {
        return new CraftBanner(this, null);
    }

    @Override
    public CraftBanner copy(Location location) {
        return new CraftBanner(this, location);
    }
}

