/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.block;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_4482;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Beehive;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftBee;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.Bee;

public class CraftBeehive
extends CraftBlockEntityState<class_4482>
implements Beehive {
    public CraftBeehive(World world, class_4482 tileEntity) {
        super(world, tileEntity);
    }

    protected CraftBeehive(CraftBeehive state, Location location) {
        super(state, location);
    }

    @Override
    public Location getFlower() {
        class_2338 flower = ((class_4482)this.getSnapshot()).field_20424;
        return flower == null ? null : CraftLocation.toBukkit(flower, this.getWorld());
    }

    @Override
    public void setFlower(Location location) {
        Preconditions.checkArgument((location == null || this.getWorld().equals(location.getWorld()) ? 1 : 0) != 0, (Object)"Flower must be in same world");
        ((class_4482)this.getSnapshot()).field_20424 = location == null ? null : CraftLocation.toBlockPosition(location);
    }

    @Override
    public boolean isFull() {
        return ((class_4482)this.getSnapshot()).method_21856();
    }

    @Override
    public boolean isSedated() {
        return this.isPlaced() && ((class_4482)this.getTileEntity()).method_23904();
    }

    @Override
    public int getEntityCount() {
        return ((class_4482)this.getSnapshot()).method_23903();
    }

    @Override
    public int getMaxEntities() {
        return ((class_4482)this.getSnapshot()).maxBees;
    }

    @Override
    public void setMaxEntities(int max) {
        Preconditions.checkArgument((max > 0 ? 1 : 0) != 0, (Object)"Max bees must be more than 0");
        ((class_4482)this.getSnapshot()).maxBees = max;
    }

    @Override
    public List<Bee> releaseEntities() {
        this.ensureNoWorldGeneration();
        ArrayList<Bee> bees = new ArrayList<Bee>();
        if (this.isPlaced()) {
            class_4482 beehive = (class_4482)this.getTileEntityFromWorld();
            for (class_1297 bee : beehive.releaseBees(this.getHandle(), class_4482.class_4484.field_20429, true)) {
                bees.add((Bee)((Object)bee.getBukkitEntity()));
            }
        }
        return bees;
    }

    @Override
    public void addEntity(Bee entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity must not be null");
        ((class_4482)this.getSnapshot()).method_21848((class_1297)((CraftBee)entity).getHandle());
    }

    @Override
    public CraftBeehive copy() {
        return new CraftBeehive(this, null);
    }

    @Override
    public CraftBeehive copy(Location location) {
        return new CraftBeehive(this, location);
    }
}

