/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.block;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1917;
import net.minecraft.class_1952;
import net.minecraft.class_2487;
import net.minecraft.class_2636;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6005;
import net.minecraft.class_6008;
import net.minecraft.class_6497;
import net.minecraft.class_9652;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.spawner.SpawnRule;
import org.bukkit.block.spawner.SpawnerEntry;
import org.bukkit.craftbukkit.v1_21_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntityType;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;

public class CraftCreatureSpawner
extends CraftBlockEntityState<class_2636>
implements CreatureSpawner {
    public CraftCreatureSpawner(World world, class_2636 tileEntity) {
        super(world, tileEntity);
    }

    protected CraftCreatureSpawner(CraftCreatureSpawner state, Location location) {
        super(state, location);
    }

    @Override
    public EntityType getSpawnedType() {
        class_1952 spawnData = ((class_2636)this.getSnapshot()).method_11390().field_9155;
        if (spawnData == null) {
            return null;
        }
        Optional type = class_1299.method_17684((class_2487)spawnData.method_38093());
        return type.map(CraftEntityType::minecraftToBukkit).orElse(null);
    }

    @Override
    public void setSpawnedType(EntityType entityType) {
        if (entityType == null) {
            ((class_2636)this.getSnapshot()).method_11390().field_9152 = class_6005.method_38062();
            ((class_2636)this.getSnapshot()).method_11390().field_9155 = new class_1952();
            return;
        }
        Preconditions.checkArgument((entityType != EntityType.UNKNOWN ? 1 : 0) != 0, (String)"Can't spawn EntityType %s from mob spawners!", (Object)entityType);
        class_5819 rand = this.isPlaced() ? this.getWorldHandle().method_8409() : class_5819.method_43047();
        ((class_2636)this.getSnapshot()).method_46408(CraftEntityType.bukkitToMinecraft(entityType), rand);
    }

    @Override
    public EntitySnapshot getSpawnedEntity() {
        class_1952 spawnData = ((class_2636)this.getSnapshot()).method_11390().field_9155;
        if (spawnData == null) {
            return null;
        }
        return CraftEntitySnapshot.create(spawnData.method_38093());
    }

    @Override
    public void setSpawnedEntity(EntitySnapshot snapshot) {
        CraftCreatureSpawner.setSpawnedEntity(((class_2636)this.getSnapshot()).method_11390(), snapshot, null, null);
    }

    @Override
    public void setSpawnedEntity(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftCreatureSpawner.setSpawnedEntity(((class_2636)this.getSnapshot()).method_11390(), spawnerEntry.getSnapshot(), spawnerEntry.getSpawnRule(), spawnerEntry.getEquipment());
    }

    public static void setSpawnedEntity(class_1917 spawner, EntitySnapshot snapshot, SpawnRule spawnRule, SpawnerEntry.Equipment equipment) {
        spawner.field_9152 = class_6005.method_38062();
        if (snapshot == null) {
            spawner.field_9155 = new class_1952();
            return;
        }
        class_2487 compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        spawner.field_9155 = new class_1952(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnRule)), CraftCreatureSpawner.getEquipment(equipment));
    }

    @Override
    public void addPotentialSpawn(EntitySnapshot snapshot, int weight, SpawnRule spawnRule) {
        CraftCreatureSpawner.addPotentialSpawn(((class_2636)this.getSnapshot()).method_11390(), snapshot, weight, spawnRule, null);
    }

    public static void addPotentialSpawn(class_1917 spawner, EntitySnapshot snapshot, int weight, SpawnRule spawnRule, SpawnerEntry.Equipment equipment) {
        Preconditions.checkArgument((snapshot != null ? 1 : 0) != 0, (Object)"Snapshot cannot be null");
        class_2487 compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        class_6005.class_6006 builder = class_6005.method_34971();
        spawner.field_9152.method_34994().forEach(entry -> builder.method_34975((Object)((class_1952)entry.comp_2542()), entry.method_34979().method_34976()));
        builder.method_34975((Object)new class_1952(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnRule)), CraftCreatureSpawner.getEquipment(equipment)), weight);
        spawner.field_9152 = builder.method_34974();
    }

    @Override
    public void addPotentialSpawn(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        this.addPotentialSpawn(spawnerEntry.getSnapshot(), spawnerEntry.getSpawnWeight(), spawnerEntry.getSpawnRule());
    }

    @Override
    public void setPotentialSpawns(Collection<SpawnerEntry> entries) {
        CraftCreatureSpawner.setPotentialSpawns(((class_2636)this.getSnapshot()).method_11390(), entries);
    }

    public static void setPotentialSpawns(class_1917 spawner, Collection<SpawnerEntry> entries) {
        Preconditions.checkArgument((entries != null ? 1 : 0) != 0, (Object)"Entries cannot be null");
        class_6005.class_6006 builder = class_6005.method_34971();
        for (SpawnerEntry spawnerEntry : entries) {
            class_2487 compoundTag = ((CraftEntitySnapshot)spawnerEntry.getSnapshot()).getData();
            builder.method_34975((Object)new class_1952(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnerEntry.getSpawnRule())), CraftCreatureSpawner.getEquipment(spawnerEntry.getEquipment())), spawnerEntry.getSpawnWeight());
        }
        spawner.field_9152 = builder.method_34974();
    }

    @Override
    public List<SpawnerEntry> getPotentialSpawns() {
        return CraftCreatureSpawner.getPotentialSpawns(((class_2636)this.getSnapshot()).method_11390());
    }

    public static List<SpawnerEntry> getPotentialSpawns(class_1917 spawner) {
        ArrayList<SpawnerEntry> entries = new ArrayList<SpawnerEntry>();
        for (class_6008.class_6010 entry : spawner.field_9152.method_34994()) {
            CraftEntitySnapshot snapshot = CraftEntitySnapshot.create(((class_1952)entry.comp_2542()).method_38093());
            if (snapshot == null) continue;
            SpawnRule rule = ((class_1952)entry.comp_2542()).comp_65().map(CraftCreatureSpawner::fromMinecraftRule).orElse(null);
            entries.add(new SpawnerEntry(snapshot, entry.method_34979().method_34976(), rule, CraftCreatureSpawner.getEquipment(((class_1952)entry.comp_2542()).comp_2648())));
        }
        return entries;
    }

    public static class_1952.class_6542 toMinecraftRule(SpawnRule rule) {
        if (rule == null) {
            return null;
        }
        return new class_1952.class_6542(new class_6497((Comparable)Integer.valueOf(rule.getMinBlockLight()), (Comparable)Integer.valueOf(rule.getMaxBlockLight())), new class_6497((Comparable)Integer.valueOf(rule.getMinSkyLight()), (Comparable)Integer.valueOf(rule.getMaxSkyLight())));
    }

    public static SpawnRule fromMinecraftRule(class_1952.class_6542 rule) {
        class_6497 blockLight = rule.comp_66();
        class_6497 skyLight = rule.comp_67();
        return new SpawnRule((Integer)blockLight.comp_2(), (Integer)blockLight.comp_2(), (Integer)skyLight.comp_1(), (Integer)skyLight.comp_2());
    }

    @Override
    public String getCreatureTypeName() {
        class_1952 spawnData = ((class_2636)this.getSnapshot()).method_11390().field_9155;
        if (spawnData == null) {
            return null;
        }
        Optional type = class_1299.method_17684((class_2487)spawnData.method_38093());
        return type.map(CraftEntityType::minecraftToBukkit).map(CraftEntityType::bukkitToString).orElse(null);
    }

    @Override
    public void setCreatureTypeByName(String creatureType) {
        EntityType type = CraftEntityType.stringToBukkit(creatureType);
        if (type == null) {
            this.setSpawnedType(null);
            return;
        }
        this.setSpawnedType(type);
    }

    @Override
    public int getDelay() {
        return ((class_2636)this.getSnapshot()).method_11390().field_9154;
    }

    @Override
    public void setDelay(int delay) {
        ((class_2636)this.getSnapshot()).method_11390().field_9154 = delay;
    }

    @Override
    public int getMinSpawnDelay() {
        return ((class_2636)this.getSnapshot()).method_11390().field_9151;
    }

    @Override
    public void setMinSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay <= this.getMaxSpawnDelay() ? 1 : 0) != 0, (Object)"Minimum Spawn Delay must be less than or equal to Maximum Spawn Delay");
        ((class_2636)this.getSnapshot()).method_11390().field_9151 = spawnDelay;
    }

    @Override
    public int getMaxSpawnDelay() {
        return ((class_2636)this.getSnapshot()).method_11390().field_9150;
    }

    @Override
    public void setMaxSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay > 0 ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than 0.");
        Preconditions.checkArgument((spawnDelay >= this.getMinSpawnDelay() ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than or equal to Minimum Spawn Delay");
        ((class_2636)this.getSnapshot()).method_11390().field_9150 = spawnDelay;
    }

    @Override
    public int getMaxNearbyEntities() {
        return ((class_2636)this.getSnapshot()).method_11390().field_9160;
    }

    @Override
    public void setMaxNearbyEntities(int maxNearbyEntities) {
        ((class_2636)this.getSnapshot()).method_11390().field_9160 = maxNearbyEntities;
    }

    @Override
    public int getSpawnCount() {
        return ((class_2636)this.getSnapshot()).method_11390().field_9149;
    }

    @Override
    public void setSpawnCount(int count) {
        ((class_2636)this.getSnapshot()).method_11390().field_9149 = count;
    }

    @Override
    public int getRequiredPlayerRange() {
        return ((class_2636)this.getSnapshot()).method_11390().field_9158;
    }

    @Override
    public void setRequiredPlayerRange(int requiredPlayerRange) {
        ((class_2636)this.getSnapshot()).method_11390().field_9158 = requiredPlayerRange;
    }

    @Override
    public int getSpawnRange() {
        return ((class_2636)this.getSnapshot()).method_11390().field_9157;
    }

    @Override
    public void setSpawnRange(int spawnRange) {
        ((class_2636)this.getSnapshot()).method_11390().field_9157 = spawnRange;
    }

    @Override
    public CraftCreatureSpawner copy() {
        return new CraftCreatureSpawner(this, null);
    }

    @Override
    public CraftCreatureSpawner copy(Location location) {
        return new CraftCreatureSpawner(this, location);
    }

    public static Optional<class_9652> getEquipment(SpawnerEntry.Equipment bukkit) {
        if (bukkit == null) {
            return Optional.empty();
        }
        return Optional.of(new class_9652(CraftLootTable.bukkitToMinecraft(bukkit.getEquipmentLootTable()), bukkit.getDropChances().entrySet().stream().collect(Collectors.toMap(entry -> CraftEquipmentSlot.getNMS((EquipmentSlot)((Object)((Object)entry.getKey()))), Map.Entry::getValue))));
    }

    public static SpawnerEntry.Equipment getEquipment(Optional<class_9652> optional) {
        return optional.map(nms -> new SpawnerEntry.Equipment(CraftLootTable.minecraftToBukkit((class_5321<class_52>)nms.comp_2621()), new HashMap<EquipmentSlot, Float>(nms.comp_2622().entrySet().stream().collect(Collectors.toMap(entry -> CraftEquipmentSlot.getSlot((class_1304)entry.getKey()), Map.Entry::getValue))))).orElse(null);
    }
}

