/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_8960;
import net.minecraft.class_8961;
import net.minecraft.class_8966;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.TrialSpawner;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftTrialSpawnerConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.spawner.TrialSpawnerConfiguration;

public class CraftTrialSpawner
extends CraftBlockEntityState<class_8961>
implements TrialSpawner {
    private final CraftTrialSpawnerConfiguration normalConfig;
    private final CraftTrialSpawnerConfiguration ominousConfig;

    public CraftTrialSpawner(World world, class_8961 tileEntity) {
        super(world, tileEntity);
        this.normalConfig = new CraftTrialSpawnerConfiguration(tileEntity.method_55150().method_58703(), (class_8961)this.getSnapshot());
        this.ominousConfig = new CraftTrialSpawnerConfiguration(tileEntity.method_55150().method_58704(), (class_8961)this.getSnapshot());
    }

    protected CraftTrialSpawner(CraftTrialSpawner state, Location location) {
        super(state, location);
        this.normalConfig = state.normalConfig;
        this.ominousConfig = state.ominousConfig;
    }

    @Override
    public int getCooldownLength() {
        return ((class_8961)this.getSnapshot()).field_47355.method_58706();
    }

    @Override
    public void setCooldownLength(int ticks) {
        ((class_8961)this.getSnapshot()).field_47355.field_50184 = ticks;
    }

    @Override
    public int getRequiredPlayerRange() {
        return ((class_8961)this.getSnapshot()).field_47355.method_58707();
    }

    @Override
    public void setRequiredPlayerRange(int requiredPlayerRange) {
        ((class_8961)this.getSnapshot()).field_47355.field_50183 = requiredPlayerRange;
    }

    @Override
    public Collection<Player> getTrackedPlayers() {
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (UUID uuid : this.getTrialData().field_47371) {
            Player player = Bukkit.getPlayer(uuid);
            if (player == null) continue;
            players.add((Object)player);
        }
        return players.build();
    }

    @Override
    public boolean isTrackingPlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        return this.getTrialData().field_47371.contains(player.getUniqueId());
    }

    @Override
    public void startTrackingPlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        this.getTrialData().field_47371.add(player.getUniqueId());
    }

    @Override
    public void stopTrackingPlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        this.getTrialData().field_47371.remove(player.getUniqueId());
    }

    @Override
    public Collection<Entity> getTrackedEntities() {
        ImmutableSet.Builder entities = ImmutableSet.builder();
        for (UUID uuid : this.getTrialData().field_47372) {
            Entity entity = Bukkit.getEntity(uuid);
            if (entity == null) continue;
            entities.add((Object)entity);
        }
        return entities.build();
    }

    @Override
    public boolean isTrackingEntity(Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        return this.getTrialData().field_47372.contains(entity.getUniqueId());
    }

    @Override
    public void startTrackingEntity(Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        this.getTrialData().field_47372.add(entity.getUniqueId());
    }

    @Override
    public void stopTrackingEntity(Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        this.getTrialData().field_47372.remove(entity.getUniqueId());
    }

    @Override
    public boolean isOminous() {
        return (Boolean)this.getHandle().method_11654((class_2769)class_8960.field_50170);
    }

    @Override
    public void setOminous(boolean ominous) {
        ((class_8961)this.getSnapshot()).field_47355.field_50185 = ominous;
        if (ominous) {
            this.setData((class_2680)this.getHandle().method_11657((class_2769)class_8960.field_50170, (Comparable)Boolean.valueOf(true)));
            return;
        }
        this.setData((class_2680)this.getHandle().method_11657((class_2769)class_8960.field_50170, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public TrialSpawnerConfiguration getNormalConfiguration() {
        return this.normalConfig;
    }

    @Override
    public TrialSpawnerConfiguration getOminousConfiguration() {
        return this.ominousConfig;
    }

    @Override
    protected void applyTo(class_8961 tileEntity) {
        super.applyTo(tileEntity);
        tileEntity.field_47355.field_50181 = this.normalConfig.toMinecraft();
        tileEntity.field_47355.field_50182 = this.ominousConfig.toMinecraft();
    }

    private class_8966 getTrialData() {
        return ((class_8961)this.getSnapshot()).method_55150().method_55174();
    }

    @Override
    public CraftTrialSpawner copy() {
        return new CraftTrialSpawner(this, null);
    }

    @Override
    public CraftTrialSpawner copy(Location location) {
        return new CraftTrialSpawner(this, location);
    }
}

