/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.damage;

import com.google.common.base.Preconditions;
import net.minecraft.class_2378;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8108;
import net.minecraft.class_8110;
import net.minecraft.class_8112;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.damage.CraftDamageEffect;
import org.bukkit.craftbukkit.v1_21_R1.util.Handleable;
import org.bukkit.damage.DamageEffect;
import org.bukkit.damage.DamageScaling;
import org.bukkit.damage.DamageType;
import org.bukkit.damage.DeathMessageType;

public class CraftDamageType
implements DamageType,
Handleable<class_8110> {
    private final NamespacedKey key;
    private final class_8110 damageType;

    public CraftDamageType(NamespacedKey key, class_8110 damageType) {
        this.key = key;
        this.damageType = damageType;
    }

    @Override
    public class_8110 getHandle() {
        return this.damageType;
    }

    @Override
    public String getTranslationKey() {
        return this.getHandle().comp_1242();
    }

    @Override
    public DamageScaling getDamageScaling() {
        return CraftDamageType.damageScalingToBukkit(this.getHandle().comp_1243());
    }

    @Override
    public DamageEffect getDamageEffect() {
        return CraftDamageEffect.toBukkit(this.getHandle().comp_1245());
    }

    @Override
    public DeathMessageType getDeathMessageType() {
        return CraftDamageType.deathMessageTypeToBukkit(this.getHandle().comp_1246());
    }

    @Override
    public float getExhaustion() {
        return this.getHandle().comp_1244();
    }

    @Override
    public NamespacedKey getKey() {
        return this.key;
    }

    public String toString() {
        return "CraftDamageType{key=" + String.valueOf(this.getKey()) + ",damageScaling=" + String.valueOf((Object)this.getDamageScaling()) + ",damageEffect=" + String.valueOf(this.getDamageEffect()) + ",deathMessageType=" + String.valueOf((Object)this.getDeathMessageType()) + ",exhaustion=" + this.getExhaustion() + "}";
    }

    public static DeathMessageType deathMessageTypeToBukkit(class_8112 deathMessageType) {
        return switch (deathMessageType) {
            case class_8112.field_42361 -> DeathMessageType.DEFAULT;
            case class_8112.field_42362 -> DeathMessageType.FALL_VARIANTS;
            case class_8112.field_42363 -> DeathMessageType.INTENTIONAL_GAME_DESIGN;
            default -> throw new IllegalArgumentException("NMS DeathMessageType." + String.valueOf(deathMessageType) + " cannot be converted to a Bukkit DeathMessageType.");
        };
    }

    public static class_8112 deathMessageTypeToNMS(DeathMessageType deathMessageType) {
        return switch (deathMessageType) {
            case DeathMessageType.DEFAULT -> class_8112.field_42361;
            case DeathMessageType.FALL_VARIANTS -> class_8112.field_42362;
            case DeathMessageType.INTENTIONAL_GAME_DESIGN -> class_8112.field_42363;
            default -> throw new IllegalArgumentException("Bukkit DeathMessageType." + String.valueOf((Object)deathMessageType) + " cannot be converted to a NMS DeathMessageType.");
        };
    }

    public static DamageScaling damageScalingToBukkit(class_8108 damageScaling) {
        return switch (damageScaling) {
            case class_8108.field_42287 -> DamageScaling.ALWAYS;
            case class_8108.field_42286 -> DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER;
            case class_8108.field_42285 -> DamageScaling.NEVER;
            default -> throw new IllegalArgumentException("NMS DamageScaling." + String.valueOf(damageScaling) + " cannot be converted to a Bukkit DamageScaling");
        };
    }

    public static class_8108 damageScalingToNMS(DamageScaling damageScaling) {
        return switch (damageScaling) {
            case DamageScaling.ALWAYS -> class_8108.field_42287;
            case DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER -> class_8108.field_42286;
            case DamageScaling.NEVER -> class_8108.field_42285;
            default -> throw new IllegalArgumentException("Bukkit DamageScaling." + String.valueOf((Object)damageScaling) + " cannot be converted to a NMS DamageScaling");
        };
    }

    public static DamageType minecraftHolderToBukkit(class_6880<class_8110> minecraftHolder) {
        return CraftDamageType.minecraftToBukkit((class_8110)minecraftHolder.comp_349());
    }

    public static class_6880<class_8110> bukkitToMinecraftHolder(DamageType bukkitDamageType) {
        Preconditions.checkArgument((bukkitDamageType != null ? 1 : 0) != 0);
        class_2378 registry = CraftRegistry.getMinecraftRegistry(class_7924.field_42534);
        class_6880 class_68802 = registry.method_47983((Object)CraftDamageType.bukkitToMinecraft(bukkitDamageType));
        if (class_68802 instanceof class_6880.class_6883) {
            class_6880.class_6883 holder = (class_6880.class_6883)class_68802;
            return holder;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkitDamageType) + ", this can happen if a plugin creates its own damage type with out properly registering it.");
    }

    public static class_8110 bukkitToMinecraft(DamageType bukkitDamageType) {
        return (class_8110)CraftRegistry.bukkitToMinecraft(bukkitDamageType);
    }

    public static DamageType minecraftToBukkit(class_8110 minecraftDamageType) {
        return CraftRegistry.minecraftToBukkit(minecraftDamageType, class_7924.field_42534, Registry.DAMAGE_TYPE);
    }
}

