/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1844;
import net.minecraft.class_6880;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.craftbukkit.v1_21_R1.CraftParticle;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R1.potion.CraftPotionType;
import org.bukkit.craftbukkit.v1_21_R1.potion.CraftPotionUtil;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.projectiles.ProjectileSource;

public class CraftAreaEffectCloud
extends CraftEntity
implements AreaEffectCloud {
    public CraftAreaEffectCloud(CraftServer server, class_1295 entity) {
        super(server, (class_1297)entity);
    }

    public class_1295 getHandle() {
        return (class_1295)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftAreaEffectCloud";
    }

    @Override
    public int getDuration() {
        return this.getHandle().method_5605();
    }

    @Override
    public void setDuration(int duration) {
        this.getHandle().method_5604(duration);
    }

    @Override
    public int getWaitTime() {
        return this.getHandle().field_5941;
    }

    @Override
    public void setWaitTime(int waitTime) {
        this.getHandle().method_5595(waitTime);
    }

    @Override
    public int getReapplicationDelay() {
        return this.getHandle().field_5937;
    }

    @Override
    public void setReapplicationDelay(int delay) {
        this.getHandle().field_5937 = delay;
    }

    @Override
    public int getDurationOnUse() {
        return this.getHandle().field_5932;
    }

    @Override
    public void setDurationOnUse(int duration) {
        this.getHandle().field_5932 = duration;
    }

    @Override
    public float getRadius() {
        return this.getHandle().method_5599();
    }

    @Override
    public void setRadius(float radius) {
        this.getHandle().method_5603(radius);
    }

    @Override
    public float getRadiusOnUse() {
        return this.getHandle().field_5929;
    }

    @Override
    public void setRadiusOnUse(float radius) {
        this.getHandle().method_5609(radius);
    }

    @Override
    public float getRadiusPerTick() {
        return this.getHandle().field_5930;
    }

    @Override
    public void setRadiusPerTick(float radius) {
        this.getHandle().method_5596(radius);
    }

    @Override
    public Particle getParticle() {
        return CraftParticle.minecraftToBukkit(this.getHandle().method_5600().method_10295());
    }

    @Override
    public void setParticle(Particle particle) {
        this.setParticle(particle, null);
    }

    @Override
    public <T> void setParticle(Particle particle, T data) {
        this.getHandle().method_5608(CraftParticle.createParticleParam(particle, data));
    }

    @Override
    public Color getColor() {
        return Color.fromRGB(this.getHandle().field_49209.method_8064());
    }

    @Override
    public void setColor(Color color) {
        class_1844 old = this.getHandle().field_49209;
        this.getHandle().method_57280(new class_1844(old.comp_2378(), Optional.of(color.asRGB()), old.comp_2380()));
    }

    @Override
    public boolean addCustomEffect(PotionEffect effect, boolean override) {
        if (this.hasCustomEffect(effect.getType())) {
            if (!override) {
                return false;
            }
            this.removeCustomEffect(effect.getType());
        }
        this.getHandle().method_5610(CraftPotionUtil.fromBukkit(effect));
        this.getHandle().method_5597();
        return true;
    }

    @Override
    public void clearCustomEffects() {
        class_1844 old = this.getHandle().field_49209;
        this.getHandle().method_57280(new class_1844(old.comp_2378(), old.comp_2379(), List.of()));
        this.getHandle().method_5597();
    }

    @Override
    public List<PotionEffect> getCustomEffects() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (class_1293 effect : this.getHandle().field_49209.comp_2380()) {
            builder.add((Object)CraftPotionUtil.toBukkit(effect));
        }
        return builder.build();
    }

    @Override
    public boolean hasCustomEffect(PotionEffectType type) {
        for (class_1293 effect : this.getHandle().field_49209.comp_2380()) {
            if (!CraftPotionUtil.equals((class_6880<class_1291>)effect.method_5579(), type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCustomEffects() {
        return !this.getHandle().field_49209.comp_2380().isEmpty();
    }

    @Override
    public boolean removeCustomEffect(PotionEffectType effect) {
        if (!this.hasCustomEffect(effect)) {
            return false;
        }
        class_6880<class_1291> minecraft = CraftPotionEffectType.bukkitToMinecraftHolder(effect);
        class_1844 old = this.getHandle().field_49209;
        this.getHandle().method_57280(new class_1844(old.comp_2378(), old.comp_2379(), old.comp_2380().stream().filter(mobEffect -> !mobEffect.method_5579().equals((Object)minecraft)).toList()));
        return true;
    }

    @Override
    public void setBasePotionData(PotionData data) {
        this.setBasePotionType(CraftPotionUtil.fromBukkit(data));
    }

    @Override
    public PotionData getBasePotionData() {
        return CraftPotionUtil.toBukkit(this.getBasePotionType());
    }

    @Override
    public void setBasePotionType(PotionType potionType) {
        if (potionType != null) {
            this.getHandle().method_57280(this.getHandle().field_49209.method_57403(CraftPotionType.bukkitToMinecraftHolder(potionType)));
        } else {
            class_1844 old = this.getHandle().field_49209;
            this.getHandle().method_57280(new class_1844(Optional.empty(), old.comp_2379(), old.comp_2380()));
        }
    }

    @Override
    public PotionType getBasePotionType() {
        return this.getHandle().field_49209.comp_2378().map(CraftPotionType::minecraftHolderToBukkit).orElse(null);
    }

    @Override
    public ProjectileSource getSource() {
        class_1309 source = this.getHandle().method_5601();
        return source == null ? null : (LivingEntity)((Object)source.getBukkitEntity());
    }

    @Override
    public void setSource(ProjectileSource shooter) {
        if (shooter instanceof CraftLivingEntity) {
            CraftLivingEntity craftLivingEntity = (CraftLivingEntity)shooter;
            this.getHandle().method_5607(craftLivingEntity.getHandle());
        } else {
            this.getHandle().method_5607(null);
        }
    }
}

