/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import java.util.Random;
import net.minecraft.class_1309;
import net.minecraft.class_1671;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftProjectile;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.meta.FireworkMeta;

public class CraftFirework
extends CraftProjectile
implements Firework {
    private final Random random = new Random();
    private final CraftItemStack item;

    public CraftFirework(CraftServer server, class_1671 entity) {
        super(server, (class_1676)entity);
        class_1799 item = (class_1799)this.getHandle().method_5841().method_12789(class_1671.field_7614);
        if (item.method_7960()) {
            item = new class_1799((class_1935)class_1802.field_8639);
            this.getHandle().method_5841().method_12778(class_1671.field_7614, (Object)item);
        }
        this.item = CraftItemStack.asCraftMirror(item);
        if (this.item.getType() != Material.FIREWORK_ROCKET) {
            this.item.setType(Material.FIREWORK_ROCKET);
        }
    }

    public class_1671 getHandle() {
        return (class_1671)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFirework";
    }

    @Override
    public FireworkMeta getFireworkMeta() {
        return (FireworkMeta)this.item.getItemMeta();
    }

    @Override
    public void setFireworkMeta(FireworkMeta meta) {
        this.item.setItemMeta(meta);
        this.getHandle().field_7612 = 10 * (1 + meta.getPower()) + this.random.nextInt(6) + this.random.nextInt(7);
        this.getHandle().method_5841().markDirty(class_1671.field_7614);
    }

    @Override
    public boolean setAttachedTo(LivingEntity entity) {
        if (this.isDetonated()) {
            return false;
        }
        this.getHandle().field_7616 = entity != null ? ((CraftLivingEntity)entity).getHandle() : null;
        return true;
    }

    @Override
    public LivingEntity getAttachedTo() {
        class_1309 entity = this.getHandle().field_7616;
        return entity != null ? (LivingEntity)((Object)entity.getBukkitEntity()) : null;
    }

    @Override
    public boolean setLife(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be greater than or equal to 0");
        if (this.isDetonated()) {
            return false;
        }
        this.getHandle().field_7613 = ticks;
        return true;
    }

    @Override
    public int getLife() {
        return this.getHandle().field_7613;
    }

    @Override
    public boolean setMaxLife(int ticks) {
        Preconditions.checkArgument((ticks > 0 ? 1 : 0) != 0, (Object)"ticks must be greater than 0");
        if (this.isDetonated()) {
            return false;
        }
        this.getHandle().field_7612 = ticks;
        return true;
    }

    @Override
    public int getMaxLife() {
        return this.getHandle().field_7612;
    }

    @Override
    public void detonate() {
        this.setLife(this.getMaxLife() + 1);
    }

    @Override
    public boolean isDetonated() {
        return this.getHandle().field_7613 > this.getHandle().field_7612;
    }

    @Override
    public boolean isShotAtAngle() {
        return this.getHandle().method_7477();
    }

    @Override
    public void setShotAtAngle(boolean shotAtAngle) {
        this.getHandle().method_5841().method_12778(class_1671.field_7615, (Object)shotAtAngle);
    }
}

