/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.class_1530;
import net.minecraft.class_1533;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import org.bukkit.Rotation;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHanging;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.ItemStack;

public class CraftItemFrame
extends CraftHanging
implements ItemFrame {
    public CraftItemFrame(CraftServer server, class_1533 entity) {
        super(server, (class_1530)entity);
    }

    @Override
    public boolean setFacingDirection(BlockFace face, boolean force) {
        class_1533 hanging = this.getHandle();
        class_2350 oldDir = hanging.method_5735();
        class_2350 newDir = CraftBlock.blockFaceToNotch(face);
        Preconditions.checkArgument((newDir != null ? 1 : 0) != 0, (String)"%s is not a valid facing direction", (Object)((Object)face));
        this.getHandle().method_6892(newDir);
        if (!(force || this.getHandle().generation || hanging.method_6888())) {
            hanging.method_6892(oldDir);
            return false;
        }
        this.update();
        return true;
    }

    @Override
    protected void update() {
        super.update();
        this.getHandle().method_5841().markDirty(class_1533.field_7130);
        this.getHandle().method_5841().markDirty(class_1533.field_7132);
        if (!this.getHandle().generation) {
            this.getHandle().method_37908().method_8455(this.getHandle().method_59940(), class_2246.field_10124);
        }
    }

    @Override
    public void setItem(ItemStack item) {
        this.setItem(item, true);
    }

    @Override
    public void setItem(ItemStack item, boolean playSound) {
        this.getHandle().setItem(CraftItemStack.asNMSCopy(item), !this.getHandle().generation, !this.getHandle().generation && playSound);
    }

    @Override
    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().method_6940());
    }

    @Override
    public float getItemDropChance() {
        return this.getHandle().field_7129;
    }

    @Override
    public void setItemDropChance(float chance) {
        Preconditions.checkArgument((0.0 <= (double)chance && (double)chance <= 1.0 ? 1 : 0) != 0, (String)"Chance (%s) outside range [0, 1]", (Object)Float.valueOf(chance));
        this.getHandle().field_7129 = chance;
    }

    @Override
    public Rotation getRotation() {
        return this.toBukkitRotation(this.getHandle().method_6934());
    }

    Rotation toBukkitRotation(int value) {
        switch (value) {
            case 0: {
                return Rotation.NONE;
            }
            case 1: {
                return Rotation.CLOCKWISE_45;
            }
            case 2: {
                return Rotation.CLOCKWISE;
            }
            case 3: {
                return Rotation.CLOCKWISE_135;
            }
            case 4: {
                return Rotation.FLIPPED;
            }
            case 5: {
                return Rotation.FLIPPED_45;
            }
            case 6: {
                return Rotation.COUNTER_CLOCKWISE;
            }
            case 7: {
                return Rotation.COUNTER_CLOCKWISE_45;
            }
        }
        throw new AssertionError((Object)("Unknown rotation " + value + " for " + String.valueOf(this.getHandle())));
    }

    @Override
    public void setRotation(Rotation rotation) {
        Preconditions.checkArgument((rotation != null ? 1 : 0) != 0, (Object)"Rotation cannot be null");
        this.getHandle().method_6939(CraftItemFrame.toInteger(rotation));
    }

    static int toInteger(Rotation rotation) {
        switch (rotation) {
            case NONE: {
                return 0;
            }
            case CLOCKWISE_45: {
                return 1;
            }
            case CLOCKWISE: {
                return 2;
            }
            case CLOCKWISE_135: {
                return 3;
            }
            case FLIPPED: {
                return 4;
            }
            case FLIPPED_45: {
                return 5;
            }
            case COUNTER_CLOCKWISE: {
                return 6;
            }
            case COUNTER_CLOCKWISE_45: {
                return 7;
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)rotation) + " is not applicable to an ItemFrame");
    }

    @Override
    public boolean isVisible() {
        return !this.getHandle().method_5767();
    }

    @Override
    public void setVisible(boolean visible) {
        this.getHandle().method_5648(!visible);
    }

    @Override
    public boolean isFixed() {
        return this.getHandle().field_22476;
    }

    @Override
    public void setFixed(boolean fixed) {
        this.getHandle().field_22476 = fixed;
    }

    public class_1533 getHandle() {
        return (class_1533)this.entity;
    }

    @Override
    public String toString() {
        return "CraftItemFrame{item=" + String.valueOf(this.getItem()) + ", rotation=" + String.valueOf((Object)this.getRotation()) + "}";
    }
}

