/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory;

import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1704;
import net.minecraft.class_1706;
import net.minecraft.class_1707;
import net.minecraft.class_1708;
import net.minecraft.class_1714;
import net.minecraft.class_1716;
import net.minecraft.class_1718;
import net.minecraft.class_1722;
import net.minecraft.class_1726;
import net.minecraft.class_1728;
import net.minecraft.class_1733;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3705;
import net.minecraft.class_3706;
import net.minecraft.class_3803;
import net.minecraft.class_3858;
import net.minecraft.class_3910;
import net.minecraft.class_3913;
import net.minecraft.class_3916;
import net.minecraft.class_3917;
import net.minecraft.class_3919;
import net.minecraft.class_8881;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftAbstractInventoryView;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryCustom;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;

public class CraftContainer
extends class_1703 {
    private final InventoryView view;
    private InventoryType cachedType;
    private class_1703 delegate;

    public CraftContainer(InventoryView view, class_1657 player, int id) {
        super(CraftContainer.getNotchInventoryType(view.getTopInventory()), id);
        this.view = view;
        class_1263 top = ((CraftInventory)view.getTopInventory()).getInventory();
        class_1661 bottom = (class_1661)((CraftInventory)view.getBottomInventory()).getInventory();
        this.cachedType = view.getType();
        this.setupSlots(top, bottom, player);
    }

    public CraftContainer(final Inventory inventory, final class_1657 player, int id) {
        this(new CraftAbstractInventoryView(){
            private final String originalTitle;
            private String title;
            {
                this.title = this.originalTitle = inventory instanceof CraftInventoryCustom ? ((CraftInventoryCustom.MinecraftInventory)((CraftInventory)inventory).getInventory()).getTitle() : inventory.getType().getDefaultTitle();
            }

            @Override
            public Inventory getTopInventory() {
                return inventory;
            }

            @Override
            public Inventory getBottomInventory() {
                return this.getPlayer().getInventory();
            }

            @Override
            public HumanEntity getPlayer() {
                return player.getBukkitEntity();
            }

            @Override
            public InventoryType getType() {
                return inventory.getType();
            }

            @Override
            public String getTitle() {
                return this.title;
            }

            @Override
            public String getOriginalTitle() {
                return this.originalTitle;
            }

            @Override
            public void setTitle(String title) {
                CraftInventoryView.sendInventoryTitleChange(this, title);
                this.title = title;
            }
        }, player, id);
    }

    public InventoryView getBukkitView() {
        return this.view;
    }

    public static class_3917 getNotchInventoryType(Inventory inventory) {
        switch (inventory.getType()) {
            case PLAYER: 
            case CHEST: 
            case ENDER_CHEST: 
            case BARREL: {
                switch (inventory.getSize()) {
                    case 9: {
                        return class_3917.field_18664;
                    }
                    case 18: {
                        return class_3917.field_18665;
                    }
                    case 27: {
                        return class_3917.field_17326;
                    }
                    case 36: 
                    case 41: {
                        return class_3917.field_18666;
                    }
                    case 45: {
                        return class_3917.field_18667;
                    }
                    case 54: {
                        return class_3917.field_17327;
                    }
                }
                throw new IllegalArgumentException("Unsupported custom inventory size " + inventory.getSize());
            }
            case WORKBENCH: {
                return class_3917.field_17333;
            }
            case FURNACE: {
                return class_3917.field_17335;
            }
            case DISPENSER: {
                return class_3917.field_17328;
            }
            case ENCHANTING: {
                return class_3917.field_17334;
            }
            case BREWING: {
                return class_3917.field_17332;
            }
            case BEACON: {
                return class_3917.field_17330;
            }
            case ANVIL: {
                return class_3917.field_17329;
            }
            case HOPPER: {
                return class_3917.field_17337;
            }
            case DROPPER: {
                return class_3917.field_17328;
            }
            case SHULKER_BOX: {
                return class_3917.field_17341;
            }
            case BLAST_FURNACE: {
                return class_3917.field_17331;
            }
            case LECTERN: {
                return class_3917.field_17338;
            }
            case SMOKER: {
                return class_3917.field_17342;
            }
            case LOOM: {
                return class_3917.field_17339;
            }
            case CARTOGRAPHY: {
                return class_3917.field_17343;
            }
            case GRINDSTONE: {
                return class_3917.field_17336;
            }
            case STONECUTTER: {
                return class_3917.field_17625;
            }
            case SMITHING: 
            case SMITHING_NEW: {
                return class_3917.field_22484;
            }
            case CREATIVE: 
            case CRAFTING: 
            case MERCHANT: {
                throw new IllegalArgumentException("Can't open a " + String.valueOf((Object)inventory.getType()) + " inventory!");
            }
            case CRAFTER: {
                return class_3917.field_46790;
            }
        }
        return class_3917.field_17326;
    }

    private void setupSlots(class_1263 top, class_1661 bottom, class_1657 entityhuman) {
        int windowId = -1;
        switch (this.cachedType) {
            case CREATIVE: {
                break;
            }
            case PLAYER: 
            case CHEST: 
            case ENDER_CHEST: 
            case BARREL: {
                this.delegate = new class_1707(class_3917.field_17326, windowId, bottom, top, top.method_5439() / 9);
                break;
            }
            case DISPENSER: 
            case DROPPER: {
                this.delegate = new class_1716(windowId, bottom, top);
                break;
            }
            case FURNACE: {
                this.delegate = new class_3858(windowId, bottom, top, (class_3913)new class_3919(4));
                break;
            }
            case WORKBENCH: 
            case CRAFTING: {
                this.setupWorkbench(top, (class_1263)bottom);
                break;
            }
            case ENCHANTING: {
                this.delegate = new class_1718(windowId, bottom);
                break;
            }
            case BREWING: {
                this.delegate = new class_1708(windowId, bottom, top, (class_3913)new class_3919(2));
                break;
            }
            case HOPPER: {
                this.delegate = new class_1722(windowId, bottom, top);
                break;
            }
            case ANVIL: {
                this.setupAnvil(top, (class_1263)bottom);
                break;
            }
            case BEACON: {
                this.delegate = new class_1704(windowId, (class_1263)bottom);
                break;
            }
            case SHULKER_BOX: {
                this.delegate = new class_1733(windowId, bottom, top);
                break;
            }
            case BLAST_FURNACE: {
                this.delegate = new class_3705(windowId, bottom, top, (class_3913)new class_3919(4));
                break;
            }
            case LECTERN: {
                this.delegate = new class_3916(windowId, top, (class_3913)new class_3919(1), bottom);
                break;
            }
            case SMOKER: {
                this.delegate = new class_3706(windowId, bottom, top, (class_3913)new class_3919(4));
                break;
            }
            case LOOM: {
                this.delegate = new class_1726(windowId, bottom);
                break;
            }
            case CARTOGRAPHY: {
                this.delegate = new class_3910(windowId, bottom);
                break;
            }
            case GRINDSTONE: {
                this.delegate = new class_3803(windowId, bottom);
                break;
            }
            case STONECUTTER: {
                this.setupStoneCutter(top, (class_1263)bottom);
                break;
            }
            case MERCHANT: {
                this.delegate = new class_1728(windowId, bottom);
                break;
            }
            case SMITHING: 
            case SMITHING_NEW: {
                this.setupSmithing(top, (class_1263)bottom);
                break;
            }
            case CRAFTER: {
                this.delegate = new class_8881(windowId, bottom);
            }
        }
        if (this.delegate != null) {
            this.field_7764 = this.delegate.field_7764;
            this.field_7761 = this.delegate.field_7761;
            this.field_29206 = this.delegate.field_29206;
        }
        switch (this.cachedType) {
            case WORKBENCH: {
                this.delegate = new class_1714(windowId, bottom);
                break;
            }
            case ANVIL: {
                this.delegate = new class_1706(windowId, bottom);
            }
        }
    }

    private void setupWorkbench(class_1263 top, class_1263 bottom) {
        int col;
        int row;
        this.method_7621(new class_1735(top, 0, 124, 35));
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 3; ++col) {
                this.method_7621(new class_1735(top, 1 + col + row * 3, 30 + col * 18, 17 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.method_7621(new class_1735(bottom, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.method_7621(new class_1735(bottom, col, 8 + col * 18, 142));
        }
    }

    private void setupAnvil(class_1263 top, class_1263 bottom) {
        int row;
        this.method_7621(new class_1735(top, 0, 27, 47));
        this.method_7621(new class_1735(top, 1, 76, 47));
        this.method_7621(new class_1735(top, 2, 134, 47));
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.method_7621(new class_1735(bottom, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (row = 0; row < 9; ++row) {
            this.method_7621(new class_1735(bottom, row, 8 + row * 18, 142));
        }
    }

    private void setupSmithing(class_1263 top, class_1263 bottom) {
        int row;
        this.method_7621(new class_1735(top, 0, 8, 48));
        this.method_7621(new class_1735(top, 1, 26, 48));
        this.method_7621(new class_1735(top, 2, 44, 48));
        this.method_7621(new class_1735(top, 3, 98, 48));
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.method_7621(new class_1735(bottom, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (row = 0; row < 9; ++row) {
            this.method_7621(new class_1735(bottom, row, 8 + row * 18, 142));
        }
    }

    private void setupStoneCutter(class_1263 top, class_1263 bottom) {
        int row;
        this.method_7621(new class_1735(top, 0, 20, 33));
        this.method_7621(new class_1735(top, 1, 143, 33));
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.method_7621(new class_1735(bottom, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (row = 0; row < 9; ++row) {
            this.method_7621(new class_1735(bottom, row, 8 + row * 18, 142));
        }
    }

    public class_1799 method_7601(class_1657 entityhuman, int i) {
        return this.delegate != null ? this.delegate.method_7601(entityhuman, i) : class_1799.field_8037;
    }

    public boolean method_7597(class_1657 entity) {
        return true;
    }

    public class_3917<?> method_17358() {
        return CraftContainer.getNotchInventoryType(this.view.getTopInventory());
    }
}

