/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2291;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9326;
import net.minecraft.class_9636;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R1.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R1.inventory.components.CraftFoodComponent;
import org.bukkit.craftbukkit.v1_21_R1.inventory.components.CraftJukeboxComponent;
import org.bukkit.craftbukkit.v1_21_R1.inventory.components.CraftToolComponent;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLegacy;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class CraftItemFactory
implements ItemFactory {
    static final Color DEFAULT_LEATHER_COLOR = Color.fromRGB(10511680);
    private static final CraftItemFactory instance;
    private static final class_5819 randomSource;

    private CraftItemFactory() {
    }

    @Override
    public boolean isApplicable(ItemMeta meta, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return this.isApplicable(meta, itemstack.getType());
    }

    @Override
    public boolean isApplicable(ItemMeta meta, Material type) {
        if ((type = CraftLegacy.fromLegacy(type)) == null || meta == null) {
            return false;
        }
        Preconditions.checkArgument((boolean)(meta instanceof CraftMetaItem), (String)"Meta of %s not created by %s", (Object)meta.getClass().toString(), (Object)CraftItemFactory.class.getName());
        return ((CraftMetaItem)meta).applicableTo(type);
    }

    @Override
    public ItemMeta getItemMeta(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        return this.getItemMeta(material, null);
    }

    private ItemMeta getItemMeta(Material material, CraftMetaItem meta) {
        if (!(material = CraftLegacy.fromLegacy(material)).isItem()) {
            return new CraftMetaItem(meta);
        }
        return ((CraftItemType)material.asItemType()).getItemMeta(meta);
    }

    @Override
    public boolean equals(ItemMeta meta1, ItemMeta meta2) {
        if (meta1 == meta2) {
            return true;
        }
        if (meta1 == null) {
            return ((CraftMetaItem)meta2).isEmpty();
        }
        Preconditions.checkArgument((boolean)(meta1 instanceof CraftMetaItem), (String)"First meta of %s does not belong to %s", (Object)meta1.getClass().getName(), (Object)CraftItemFactory.class.getName());
        if (meta2 == null) {
            return ((CraftMetaItem)meta1).isEmpty();
        }
        Preconditions.checkArgument((boolean)(meta2 instanceof CraftMetaItem), (String)"Second meta of %s does not belong to %s", (Object)meta2.getClass().getName(), (Object)CraftItemFactory.class.getName());
        return this.equals((CraftMetaItem)meta1, (CraftMetaItem)meta2);
    }

    boolean equals(CraftMetaItem meta1, CraftMetaItem meta2) {
        return meta1.equalsCommon(meta2) && meta1.notUncommon(meta2) && meta2.notUncommon(meta1);
    }

    public static CraftItemFactory instance() {
        return instance;
    }

    @Override
    public ItemMeta asMetaFor(ItemMeta meta, ItemStack stack) {
        Preconditions.checkArgument((stack != null ? 1 : 0) != 0, (Object)"ItemStack stack cannot be null");
        return this.asMetaFor(meta, stack.getType());
    }

    @Override
    public ItemMeta asMetaFor(ItemMeta meta, Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)(meta instanceof CraftMetaItem), (String)"ItemMeta of %s not created by %s", (Object)(meta != null ? meta.getClass().toString() : "null"), (Object)CraftItemFactory.class.getName());
        return this.getItemMeta(material, (CraftMetaItem)meta);
    }

    @Override
    public Color getDefaultLeatherColor() {
        return DEFAULT_LEATHER_COLOR;
    }

    @Override
    public ItemStack createItemStack(String input) throws IllegalArgumentException {
        try {
            class_2291.class_7215 arg = new class_2291((class_7225.class_7874)MinecraftServer.getDefaultRegistryAccess()).method_9789(new StringReader(input));
            class_1792 item = (class_1792)arg.comp_628().comp_349();
            class_1799 nmsItemStack = new class_1799((class_1935)item);
            class_9326 nbt = arg.comp_2439();
            if (nbt != null) {
                nmsItemStack.method_57366(nbt);
            }
            return CraftItemStack.asCraftMirror(nmsItemStack);
        }
        catch (CommandSyntaxException ex) {
            throw new IllegalArgumentException("Could not parse ItemStack: " + input, ex);
        }
    }

    @Override
    public Material getSpawnEgg(EntityType type) {
        if (type == EntityType.UNKNOWN) {
            return null;
        }
        class_1299<?> nmsType = CraftEntityType.bukkitToMinecraft(type);
        class_1826 nmsItem = class_1826.method_8019(nmsType);
        if (nmsItem == null) {
            return null;
        }
        return CraftItemType.minecraftToBukkit((class_1792)nmsItem);
    }

    @Override
    public ItemStack enchantItem(Entity entity, ItemStack itemStack, int level, boolean allowTreasures) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"The entity must not be null");
        return CraftItemFactory.enchantItem(((CraftEntity)entity).getHandle().field_5974, itemStack, level, allowTreasures);
    }

    @Override
    public ItemStack enchantItem(World world, ItemStack itemStack, int level, boolean allowTreasures) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"The world must not be null");
        return CraftItemFactory.enchantItem(((CraftWorld)world).getHandle().field_9229, itemStack, level, allowTreasures);
    }

    @Override
    public ItemStack enchantItem(ItemStack itemStack, int level, boolean allowTreasures) {
        return CraftItemFactory.enchantItem(randomSource, itemStack, level, allowTreasures);
    }

    private static ItemStack enchantItem(class_5819 source, ItemStack itemStack, int level, boolean allowTreasures) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"ItemStack must not be null");
        Preconditions.checkArgument((!itemStack.getType().isAir() ? 1 : 0) != 0, (Object)"ItemStack must not be air");
        itemStack = CraftItemStack.asCraftCopy(itemStack);
        CraftItemStack craft = (CraftItemStack)itemStack;
        class_5455 registry = CraftRegistry.getMinecraftRegistry();
        Optional optional = allowTreasures ? Optional.empty() : registry.method_30530(class_7924.field_41265).method_40266(class_9636.field_51547);
        return CraftItemStack.asCraftMirror(class_1890.method_60133((class_5819)source, (class_1799)craft.handle, (int)level, (class_5455)registry, (Optional)optional));
    }

    static {
        randomSource = class_5819.method_43047();
        instance = new CraftItemFactory();
        ConfigurationSerialization.registerClass(SerializableMeta.class);
        ConfigurationSerialization.registerClass(CraftFoodComponent.class);
        ConfigurationSerialization.registerClass(CraftFoodComponent.CraftFoodEffect.class);
        ConfigurationSerialization.registerClass(CraftToolComponent.class);
        ConfigurationSerialization.registerClass(CraftToolComponent.CraftToolRule.class);
        ConfigurationSerialization.registerClass(CraftJukeboxComponent.class);
    }
}

