/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R1.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLegacy;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftMagicNumbers;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;

@DelegateDeserialization(value=ItemStack.class)
public final class CraftItemStack
extends ItemStack {
    class_1799 handle;

    public static class_1799 asNMSCopy(ItemStack original) {
        if (original instanceof CraftItemStack) {
            CraftItemStack stack = (CraftItemStack)original;
            return stack.handle == null ? class_1799.field_8037 : stack.handle.method_7972();
        }
        if (original == null || original.getType() == Material.AIR) {
            return class_1799.field_8037;
        }
        class_1792 item = CraftItemType.bukkitToMinecraft(original.getType());
        if (item == null) {
            return class_1799.field_8037;
        }
        class_1799 stack = new class_1799((class_1935)item, original.getAmount());
        if (original.hasItemMeta()) {
            CraftItemStack.setItemMeta(stack, original.getItemMeta());
        }
        return stack;
    }

    public static class_1799 copyNMSStack(class_1799 original, int amount) {
        class_1799 stack = original.method_7972();
        stack.method_7939(amount);
        return stack;
    }

    public static ItemStack asBukkitCopy(class_1799 original) {
        if (original.method_7960()) {
            return new ItemStack(Material.AIR);
        }
        ItemStack stack = new ItemStack(CraftItemType.minecraftToBukkit(original.method_7909()), original.method_7947());
        if (CraftItemStack.hasItemMeta(original)) {
            stack.setItemMeta(CraftItemStack.getItemMeta(original));
        }
        return stack;
    }

    public static CraftItemStack asCraftMirror(class_1799 original) {
        return new CraftItemStack(original == null || original.method_7960() ? null : original);
    }

    public static CraftItemStack asCraftCopy(ItemStack original) {
        if (original instanceof CraftItemStack) {
            CraftItemStack stack = (CraftItemStack)original;
            return new CraftItemStack(stack.handle == null ? null : stack.handle.method_7972());
        }
        return new CraftItemStack(original);
    }

    public static CraftItemStack asNewCraftStack(class_1792 item) {
        return CraftItemStack.asNewCraftStack(item, 1);
    }

    public static CraftItemStack asNewCraftStack(class_1792 item, int amount) {
        return new CraftItemStack(CraftItemType.minecraftToBukkit(item), amount, 0, null);
    }

    private CraftItemStack(class_1799 item) {
        this.handle = item;
    }

    private CraftItemStack(ItemStack item) {
        this(item.getType(), item.getAmount(), item.getDurability(), item.hasItemMeta() ? item.getItemMeta() : null);
    }

    private CraftItemStack(Material type, int amount, short durability, ItemMeta itemMeta) {
        this.setType(type);
        this.setAmount(amount);
        this.setDurability(durability);
        this.setItemMeta(itemMeta);
    }

    @Override
    public MaterialData getData() {
        return this.handle != null ? CraftMagicNumbers.getMaterialData(this.handle.method_7909()) : super.getData();
    }

    @Override
    public Material getType() {
        return this.handle != null ? CraftItemType.minecraftToBukkit(this.handle.method_7909()) : Material.AIR;
    }

    @Override
    public void setType(Material type) {
        if (this.getType() == type) {
            return;
        }
        if (type == Material.AIR) {
            this.handle = null;
        } else if (CraftItemType.bukkitToMinecraft(type) == null) {
            this.handle = null;
        } else if (this.handle == null) {
            this.handle = new class_1799((class_1935)CraftItemType.bukkitToMinecraft(type), 1);
        } else {
            this.handle.setItem(CraftItemType.bukkitToMinecraft(type));
            if (this.hasItemMeta()) {
                CraftItemStack.setItemMeta(this.handle, CraftItemStack.getItemMeta(this.handle));
            }
        }
        this.setData(null);
    }

    @Override
    public int getAmount() {
        return this.handle != null ? this.handle.method_7947() : 0;
    }

    @Override
    public void setAmount(int amount) {
        if (this.handle == null) {
            return;
        }
        this.handle.method_7939(amount);
        if (amount == 0) {
            this.handle = null;
        }
    }

    @Override
    public void setDurability(short durability) {
        if (this.handle != null) {
            this.handle.method_7974((int)durability);
        }
    }

    @Override
    public short getDurability() {
        if (this.handle != null) {
            return (short)this.handle.method_7919();
        }
        return -1;
    }

    @Override
    public int getMaxStackSize() {
        return this.handle == null ? Material.AIR.getMaxStackSize() : this.handle.method_7914();
    }

    @Override
    public void addUnsafeEnchantment(Enchantment ench, int level) {
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        if (!CraftItemStack.makeTag(this.handle)) {
            return;
        }
        class_9304 list = CraftItemStack.getEnchantmentList(this.handle);
        if (list == null) {
            list = class_9304.field_49385;
        }
        class_9304.class_9305 listCopy = new class_9304.class_9305(list);
        listCopy.method_57547(CraftEnchantment.bukkitToMinecraftHolder(ench), level);
        this.handle.method_57379(class_9334.field_49633, (Object)listCopy.method_57549());
    }

    static boolean makeTag(class_1799 item) {
        return item != null;
    }

    @Override
    public boolean containsEnchantment(Enchantment ench) {
        return this.getEnchantmentLevel(ench) > 0;
    }

    @Override
    public int getEnchantmentLevel(Enchantment ench) {
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        if (this.handle == null) {
            return 0;
        }
        return class_1890.method_8225(CraftEnchantment.bukkitToMinecraftHolder(ench), (class_1799)this.handle);
    }

    @Override
    public int removeEnchantment(Enchantment ench) {
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        class_9304 list = CraftItemStack.getEnchantmentList(this.handle);
        if (list == null) {
            return 0;
        }
        int level = this.getEnchantmentLevel(ench);
        if (level <= 0) {
            return 0;
        }
        int size = list.method_57541();
        if (size == 1) {
            this.handle.method_57381(class_9334.field_49633);
            return level;
        }
        class_9304.class_9305 listCopy = new class_9304.class_9305(list);
        listCopy.method_57547(CraftEnchantment.bukkitToMinecraftHolder(ench), -1);
        this.handle.method_57379(class_9334.field_49633, (Object)listCopy.method_57549());
        return level;
    }

    @Override
    public void removeEnchantments() {
        this.handle.method_57381(class_9334.field_49633);
    }

    @Override
    public Map<Enchantment, Integer> getEnchantments() {
        return CraftItemStack.getEnchantments(this.handle);
    }

    static Map<Enchantment, Integer> getEnchantments(class_1799 item) {
        class_9304 list;
        class_9304 class_93042 = list = item != null && item.method_7942() ? (class_9304)item.method_57824(class_9334.field_49633) : null;
        if (list == null || list.method_57541() == 0) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder result = ImmutableMap.builder();
        list.method_57539().forEach(entry -> {
            class_6880 id = (class_6880)entry.getKey();
            int level = entry.getIntValue();
            Enchantment enchant = CraftEnchantment.minecraftHolderToBukkit((class_6880<class_1887>)id);
            if (enchant != null) {
                result.put((Object)enchant, (Object)level);
            }
        });
        return result.build();
    }

    static class_9304 getEnchantmentList(class_1799 item) {
        return item != null && item.method_7942() ? (class_9304)item.method_57824(class_9334.field_49633) : null;
    }

    @Override
    public CraftItemStack clone() {
        CraftItemStack itemStack = (CraftItemStack)super.clone();
        if (this.handle != null) {
            itemStack.handle = this.handle.method_7972();
        }
        return itemStack;
    }

    @Override
    public ItemMeta getItemMeta() {
        return CraftItemStack.getItemMeta(this.handle);
    }

    public static ItemMeta getItemMeta(class_1799 item) {
        if (!CraftItemStack.hasItemMeta(item)) {
            return CraftItemFactory.instance().getItemMeta(CraftItemStack.getType(item));
        }
        return ((CraftItemType)CraftItemType.minecraftToBukkitNew(item.method_7909())).getItemMeta(item);
    }

    static Material getType(class_1799 item) {
        return item == null ? Material.AIR : CraftItemType.minecraftToBukkit(item.method_7909());
    }

    @Override
    public boolean setItemMeta(ItemMeta itemMeta) {
        return CraftItemStack.setItemMeta(this.handle, itemMeta);
    }

    public static boolean setItemMeta(class_1799 item, ItemMeta itemMeta) {
        if (item == null) {
            return false;
        }
        if (CraftItemFactory.instance().equals(itemMeta, null)) {
            item.restorePatch(class_9326.field_49588);
            return true;
        }
        if (!CraftItemFactory.instance().isApplicable(itemMeta, CraftItemStack.getType(item))) {
            return false;
        }
        itemMeta = CraftItemFactory.instance().asMetaFor(itemMeta, CraftItemStack.getType(item));
        if (itemMeta == null) {
            return true;
        }
        if (!((CraftMetaItem)itemMeta).isEmpty()) {
            CraftMetaItem.Applicator tag = new CraftMetaItem.Applicator();
            ((CraftMetaItem)itemMeta).applyToItem(tag);
            item.restorePatch(tag.build());
        }
        if (item.method_7909() != null && item.method_7936() > 0) {
            item.method_7974(item.method_7919());
        }
        return true;
    }

    @Override
    public boolean isSimilar(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack == this) {
            return true;
        }
        if (!(stack instanceof CraftItemStack)) {
            return stack.getClass() == ItemStack.class && stack.isSimilar(this);
        }
        CraftItemStack that = (CraftItemStack)stack;
        if (this.handle == that.handle) {
            return true;
        }
        if (this.handle == null || that.handle == null) {
            return false;
        }
        Material comparisonType = CraftLegacy.fromLegacy(that.getType());
        if (comparisonType != this.getType() || this.getDurability() != that.getDurability()) {
            return false;
        }
        return this.hasItemMeta() ? that.hasItemMeta() && this.handle.method_57353().equals((Object)that.handle.method_57353()) : !that.hasItemMeta();
    }

    @Override
    public boolean hasItemMeta() {
        return CraftItemStack.hasItemMeta(this.handle) && !CraftItemFactory.instance().equals(this.getItemMeta(), null);
    }

    static boolean hasItemMeta(class_1799 item) {
        return item != null && !item.method_57380().method_57848();
    }
}

