/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1767;
import net.minecraft.class_2582;
import net.minecraft.class_6880;
import net.minecraft.class_9307;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.bukkit.DyeColor;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R1.block.banner.CraftPatternType;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R1.inventory.SerializableMeta;
import org.bukkit.inventory.meta.BannerMeta;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaBanner
extends CraftMetaItem
implements BannerMeta {
    static final CraftMetaItem.ItemMetaKeyType<class_9307> PATTERNS = new CraftMetaItem.ItemMetaKeyType(class_9334.field_49619, "patterns");
    private List<Pattern> patterns = new ArrayList<Pattern>();

    public CraftMetaBanner(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaBanner)) {
            return;
        }
        CraftMetaBanner banner = (CraftMetaBanner)meta;
        this.patterns = new ArrayList<Pattern>(banner.patterns);
    }

    CraftMetaBanner(class_9326 tag) {
        super(tag);
        CraftMetaBanner.getOrEmpty(tag, PATTERNS).ifPresent(entityTag -> {
            List patterns = entityTag.comp_2428();
            for (int i = 0; i < Math.min(patterns.size(), 20); ++i) {
                class_9307.class_9308 p = (class_9307.class_9308)patterns.get(i);
                DyeColor color = DyeColor.getByWoolData((byte)p.comp_2430().method_7789());
                PatternType pattern = CraftPatternType.minecraftHolderToBukkit((class_6880<class_2582>)p.comp_2429());
                if (color == null || pattern == null) continue;
                this.patterns.add(new Pattern(color, pattern));
            }
        });
    }

    CraftMetaBanner(Map<String, Object> map) {
        super(map);
        Iterable rawPatternList = SerializableMeta.getObject(Iterable.class, map, CraftMetaBanner.PATTERNS.BUKKIT, true);
        if (rawPatternList == null) {
            return;
        }
        for (Object obj : rawPatternList) {
            Preconditions.checkArgument((boolean)(obj instanceof Pattern), (String)"Object (%s) in pattern list is not valid", obj.getClass());
            this.addPattern((Pattern)obj);
        }
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        super.applyToItem(tag);
        ArrayList<class_9307.class_9308> newPatterns = new ArrayList<class_9307.class_9308>();
        for (Pattern p : this.patterns) {
            newPatterns.add(new class_9307.class_9308(CraftPatternType.bukkitToMinecraftHolder(p.getPattern()), class_1767.method_7791((int)p.getColor().getWoolData())));
        }
        tag.put(PATTERNS, new class_9307(newPatterns));
    }

    @Override
    public List<Pattern> getPatterns() {
        return new ArrayList<Pattern>(this.patterns);
    }

    @Override
    public void setPatterns(List<Pattern> patterns) {
        this.patterns = new ArrayList<Pattern>(patterns);
    }

    @Override
    public void addPattern(Pattern pattern) {
        this.patterns.add(pattern);
    }

    @Override
    public Pattern getPattern(int i) {
        return this.patterns.get(i);
    }

    @Override
    public Pattern removePattern(int i) {
        return this.patterns.remove(i);
    }

    @Override
    public void setPattern(int i, Pattern pattern) {
        this.patterns.set(i, pattern);
    }

    @Override
    public int numberOfPatterns() {
        return this.patterns.size();
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (!this.patterns.isEmpty()) {
            builder.put((Object)CraftMetaBanner.PATTERNS.BUKKIT, (Object)ImmutableList.copyOf(this.patterns));
        }
        return builder;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (!this.patterns.isEmpty()) {
            hash = 31 * hash + this.patterns.hashCode();
        }
        return original != hash ? CraftMetaBanner.class.hashCode() ^ hash : hash;
    }

    @Override
    public boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaBanner) {
            CraftMetaBanner that = (CraftMetaBanner)meta;
            return this.patterns.equals(that.patterns);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaBanner || this.patterns.isEmpty());
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.patterns.isEmpty();
    }

    @Override
    public CraftMetaBanner clone() {
        CraftMetaBanner meta = (CraftMetaBanner)super.clone();
        meta.patterns = new ArrayList<Pattern>(this.patterns);
        return meta;
    }
}

