/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.serialization.DynamicOps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1814;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3902;
import net.minecraft.class_4174;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5625;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7924;
import net.minecraft.class_9274;
import net.minecraft.class_9275;
import net.minecraft.class_9279;
import net.minecraft.class_9280;
import net.minecraft.class_9285;
import net.minecraft.class_9290;
import net.minecraft.class_9300;
import net.minecraft.class_9304;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9336;
import net.minecraft.class_9424;
import net.minecraft.class_9791;
import net.minecraft.class_9792;
import net.minecraft.class_9796;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.Overridden;
import org.bukkit.craftbukkit.v1_21_R1.attribute.CraftAttribute;
import org.bukkit.craftbukkit.v1_21_R1.attribute.CraftAttributeInstance;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R1.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemFlag;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaArmor;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaArmorStand;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaAxolotlBucket;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaBanner;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaBlockState;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaBookSigned;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaBundle;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaCharge;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaCompass;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaCrossbow;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaEnchantedBook;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaEntityTag;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaKnowledgeBook;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaLeatherArmor;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaMap;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaMusicInstrument;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaOminousBottle;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaPotion;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaSkull;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaSpawnEgg;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaSuspiciousStew;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaTropicalFishBucket;
import org.bukkit.craftbukkit.v1_21_R1.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R1.inventory.components.CraftFoodComponent;
import org.bukkit.craftbukkit.v1_21_R1.inventory.components.CraftJukeboxComponent;
import org.bukkit.craftbukkit.v1_21_R1.inventory.components.CraftToolComponent;
import org.bukkit.craftbukkit.v1_21_R1.inventory.tags.DeprecatedCustomTagContainer;
import org.bukkit.craftbukkit.v1_21_R1.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R1.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNBTTagConfigSerializer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.meta.BlockDataMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.inventory.meta.components.FoodComponent;
import org.bukkit.inventory.meta.components.JukeboxPlayableComponent;
import org.bukkit.inventory.meta.components.ToolComponent;
import org.bukkit.inventory.meta.tags.CustomItemTagContainer;
import org.bukkit.persistence.PersistentDataContainer;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaItem
implements ItemMeta,
Damageable,
Repairable,
BlockDataMeta {
    static final ItemMetaKeyType<class_2561> NAME = new ItemMetaKeyType(class_9334.field_49631, "display-name");
    static final ItemMetaKeyType<class_2561> ITEM_NAME = new ItemMetaKeyType(class_9334.field_50239, "item-name");
    static final ItemMetaKeyType<class_9290> LORE = new ItemMetaKeyType(class_9334.field_49632, "lore");
    static final ItemMetaKeyType<class_9280> CUSTOM_MODEL_DATA = new ItemMetaKeyType(class_9334.field_49637, "custom-model-data");
    static final ItemMetaKeyType<class_9304> ENCHANTMENTS = new ItemMetaKeyType(class_9334.field_49633, "enchants");
    static final ItemMetaKeyType<Integer> REPAIR = new ItemMetaKeyType(class_9334.field_49639, "repair-cost");
    static final ItemMetaKeyType<class_9285> ATTRIBUTES = new ItemMetaKeyType(class_9334.field_49636, "attribute-modifiers");
    static final ItemMetaKey ATTRIBUTES_IDENTIFIER = new ItemMetaKey("AttributeName");
    static final ItemMetaKey ATTRIBUTES_SLOT = new ItemMetaKey("Slot");
    static final ItemMetaKey HIDEFLAGS = new ItemMetaKey("ItemFlags");
    static final ItemMetaKeyType<class_3902> HIDE_TOOLTIP = new ItemMetaKeyType(class_9334.field_50074, "hide-tool-tip");
    static final ItemMetaKeyType<class_9300> UNBREAKABLE = new ItemMetaKeyType(class_9334.field_49630, "Unbreakable");
    static final ItemMetaKeyType<Boolean> ENCHANTMENT_GLINT_OVERRIDE = new ItemMetaKeyType(class_9334.field_49641, "enchantment-glint-override");
    static final ItemMetaKeyType<class_3902> FIRE_RESISTANT = new ItemMetaKeyType(class_9334.field_50076, "fire-resistant");
    static final ItemMetaKeyType<Integer> MAX_STACK_SIZE = new ItemMetaKeyType(class_9334.field_50071, "max-stack-size");
    static final ItemMetaKeyType<class_1814> RARITY = new ItemMetaKeyType(class_9334.field_50073, "rarity");
    static final ItemMetaKeyType<class_4174> FOOD = new ItemMetaKeyType(class_9334.field_50075, "food");
    static final ItemMetaKeyType<class_9424> TOOL = new ItemMetaKeyType(class_9334.field_50077, "tool");
    static final ItemMetaKeyType<class_9792> JUKEBOX_PLAYABLE = new ItemMetaKeyType(class_9334.field_52175, "jukebox-playable");
    static final ItemMetaKeyType<Integer> DAMAGE = new ItemMetaKeyType(class_9334.field_49629, "Damage");
    static final ItemMetaKeyType<Integer> MAX_DAMAGE = new ItemMetaKeyType(class_9334.field_50072, "max-damage");
    static final ItemMetaKeyType<class_9275> BLOCK_DATA = new ItemMetaKeyType(class_9334.field_49623, "BlockStateTag");
    static final ItemMetaKey BUKKIT_CUSTOM_TAG = new ItemMetaKey("PublicBukkitValues");
    static final ItemMetaKeyType<class_3902> HIDE_ADDITIONAL_TOOLTIP = new ItemMetaKeyType(class_9334.field_49638);
    static final ItemMetaKeyType<class_9279> CUSTOM_DATA = new ItemMetaKeyType(class_9334.field_49628);
    private class_2561 displayName;
    private class_2561 itemName;
    private List<class_2561> lore;
    private Integer customModelData;
    private Map<String, String> blockData;
    private Map<Enchantment, Integer> enchantments;
    private Multimap<Attribute, AttributeModifier> attributeModifiers;
    private int repairCost;
    private int hideFlag;
    private boolean hideTooltip;
    private boolean unbreakable;
    private Boolean enchantmentGlintOverride;
    private boolean fireResistant;
    private Integer maxStackSize;
    private ItemRarity rarity;
    private CraftFoodComponent food;
    private CraftToolComponent tool;
    private CraftJukeboxComponent jukebox;
    private int damage;
    private Integer maxDamage;
    private static final Set<class_9331> HANDLED_TAGS = Sets.newHashSet();
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    private class_2487 customTag;
    protected class_9326.class_9327 unhandledTags = class_9326.method_57841();
    private Set<class_9331<?>> removedTags = Sets.newHashSet();
    private CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private int version = CraftMagicNumbers.INSTANCE.getDataVersion();

    public CraftMetaItem(CraftMetaItem meta) {
        if (meta == null) {
            return;
        }
        this.displayName = meta.displayName;
        this.itemName = meta.itemName;
        if (meta.lore != null) {
            this.lore = new ArrayList<class_2561>(meta.lore);
        }
        this.customModelData = meta.customModelData;
        this.blockData = meta.blockData;
        if (meta.enchantments != null) {
            this.enchantments = new LinkedHashMap<Enchantment, Integer>(meta.enchantments);
        }
        if (meta.hasAttributeModifiers()) {
            this.attributeModifiers = LinkedHashMultimap.create(meta.attributeModifiers);
        }
        this.repairCost = meta.repairCost;
        this.hideFlag = meta.hideFlag;
        this.hideTooltip = meta.hideTooltip;
        this.unbreakable = meta.unbreakable;
        this.enchantmentGlintOverride = meta.enchantmentGlintOverride;
        this.fireResistant = meta.fireResistant;
        this.maxStackSize = meta.maxStackSize;
        this.rarity = meta.rarity;
        if (meta.hasFood()) {
            this.food = new CraftFoodComponent(meta.food);
        }
        if (meta.hasTool()) {
            this.tool = new CraftToolComponent(meta.tool);
        }
        if (meta.hasJukeboxPlayable()) {
            this.jukebox = new CraftJukeboxComponent(meta.jukebox);
        }
        this.damage = meta.damage;
        this.maxDamage = meta.maxDamage;
        this.unhandledTags.copy(meta.unhandledTags.method_57852());
        this.removedTags.addAll(meta.removedTags);
        this.persistentDataContainer.putAll(meta.persistentDataContainer.getRaw());
        this.customTag = meta.customTag;
        this.version = meta.version;
    }

    CraftMetaItem(class_9326 tag) {
        CraftMetaItem.getOrEmpty(tag, NAME).ifPresent(component -> {
            this.displayName = component;
        });
        CraftMetaItem.getOrEmpty(tag, ITEM_NAME).ifPresent(component -> {
            this.itemName = component;
        });
        CraftMetaItem.getOrEmpty(tag, LORE).ifPresent(l -> {
            List list = l.comp_2400();
            this.lore = new ArrayList<class_2561>(list.size());
            for (int index = 0; index < list.size(); ++index) {
                class_2561 line = (class_2561)list.get(index);
                this.lore.add(line);
            }
        });
        CraftMetaItem.getOrEmpty(tag, CUSTOM_MODEL_DATA).ifPresent(i -> {
            this.customModelData = i.comp_2382();
        });
        CraftMetaItem.getOrEmpty(tag, BLOCK_DATA).ifPresent(t -> {
            this.blockData = t.comp_2381();
        });
        CraftMetaItem.getOrEmpty(tag, ENCHANTMENTS).ifPresent(en -> {
            this.enchantments = CraftMetaItem.buildEnchantments(en);
            if (!en.field_49390) {
                this.addItemFlags(ItemFlag.HIDE_ENCHANTS);
            }
        });
        CraftMetaItem.getOrEmpty(tag, ATTRIBUTES).ifPresent(en -> {
            this.attributeModifiers = CraftMetaItem.buildModifiers(en);
            if (!en.comp_2394()) {
                this.addItemFlags(ItemFlag.HIDE_ATTRIBUTES);
            }
        });
        CraftMetaItem.getOrEmpty(tag, REPAIR).ifPresent(i -> {
            this.repairCost = i;
        });
        CraftMetaItem.getOrEmpty(tag, HIDE_ADDITIONAL_TOOLTIP).ifPresent(h -> this.addItemFlags(ItemFlag.HIDE_ADDITIONAL_TOOLTIP));
        CraftMetaItem.getOrEmpty(tag, HIDE_TOOLTIP).ifPresent(u -> {
            this.hideTooltip = true;
        });
        CraftMetaItem.getOrEmpty(tag, UNBREAKABLE).ifPresent(u -> {
            this.unbreakable = true;
            if (!u.comp_2417()) {
                this.addItemFlags(ItemFlag.HIDE_UNBREAKABLE);
            }
        });
        CraftMetaItem.getOrEmpty(tag, ENCHANTMENT_GLINT_OVERRIDE).ifPresent(override -> {
            this.enchantmentGlintOverride = override;
        });
        CraftMetaItem.getOrEmpty(tag, FIRE_RESISTANT).ifPresent(u -> {
            this.fireResistant = true;
        });
        CraftMetaItem.getOrEmpty(tag, MAX_STACK_SIZE).ifPresent(i -> {
            this.maxStackSize = i;
        });
        CraftMetaItem.getOrEmpty(tag, RARITY).ifPresent(enumItemRarity -> {
            this.rarity = ItemRarity.valueOf(enumItemRarity.name());
        });
        CraftMetaItem.getOrEmpty(tag, FOOD).ifPresent(foodInfo -> {
            this.food = new CraftFoodComponent((class_4174)foodInfo);
        });
        CraftMetaItem.getOrEmpty(tag, TOOL).ifPresent(toolInfo -> {
            this.tool = new CraftToolComponent((class_9424)toolInfo);
        });
        CraftMetaItem.getOrEmpty(tag, JUKEBOX_PLAYABLE).ifPresent(jukeboxPlayable -> {
            this.jukebox = new CraftJukeboxComponent((class_9792)jukeboxPlayable);
        });
        CraftMetaItem.getOrEmpty(tag, DAMAGE).ifPresent(i -> {
            this.damage = i;
        });
        CraftMetaItem.getOrEmpty(tag, MAX_DAMAGE).ifPresent(i -> {
            this.maxDamage = i;
        });
        CraftMetaItem.getOrEmpty(tag, CUSTOM_DATA).ifPresent(customData -> {
            this.customTag = customData.method_57461();
            if (this.customTag.method_10545(CraftMetaItem.BUKKIT_CUSTOM_TAG.NBT)) {
                class_2487 compound = this.customTag.method_10562(CraftMetaItem.BUKKIT_CUSTOM_TAG.NBT);
                Set keys = compound.method_10541();
                for (String key : keys) {
                    this.persistentDataContainer.put(key, compound.method_10580(key).method_10707());
                }
                this.customTag.method_10551(CraftMetaItem.BUKKIT_CUSTOM_TAG.NBT);
            }
            if (this.customTag.method_33133()) {
                this.customTag = null;
            }
        });
        Set keys = tag.method_57846();
        for (Map.Entry key : keys) {
            if (!CraftMetaItem.getHandledTags().contains(key.getKey())) {
                ((Optional)key.getValue()).ifPresent(value -> this.unhandledTags.method_57854((class_9331)key.getKey(), value));
            }
            if (!((Optional)key.getValue()).isEmpty()) continue;
            this.removedTags.add((class_9331)key.getKey());
        }
    }

    static Map<Enchantment, Integer> buildEnchantments(class_9304 tag) {
        LinkedHashMap<Enchantment, Integer> enchantments = new LinkedHashMap<Enchantment, Integer>(tag.method_57541());
        tag.method_57539().forEach(entry -> {
            class_6880 id = (class_6880)entry.getKey();
            int level = entry.getIntValue();
            Enchantment enchant = CraftEnchantment.minecraftHolderToBukkit((class_6880<class_1887>)id);
            if (enchant != null) {
                enchantments.put(enchant, level);
            }
        });
        return enchantments;
    }

    static Multimap<Attribute, AttributeModifier> buildModifiers(class_9285 tag) {
        LinkedHashMultimap modifiers = LinkedHashMultimap.create();
        List mods = tag.comp_2393();
        int size = mods.size();
        for (int i = 0; i < size; ++i) {
            class_9285.class_9287 entry = (class_9285.class_9287)mods.get(i);
            class_1322 nmsModifier = entry.comp_2396();
            if (nmsModifier == null) continue;
            AttributeModifier attribMod = CraftAttributeInstance.convert(nmsModifier);
            Attribute attribute = CraftAttribute.minecraftHolderToBukkit((class_6880<class_1320>)entry.comp_2395());
            if (attribute == null) continue;
            if (entry.comp_2397() != null) {
                class_9274 slotName = entry.comp_2397();
                if (slotName == null) {
                    modifiers.put((Object)attribute, (Object)attribMod);
                    continue;
                }
                EquipmentSlotGroup slot = null;
                try {
                    slot = CraftEquipmentSlot.getSlot(slotName);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (slot == null) {
                    modifiers.put((Object)attribute, (Object)attribMod);
                    continue;
                }
                attribMod = new AttributeModifier(attribMod.getKey(), attribMod.getAmount(), attribMod.getOperation(), slot);
            }
            modifiers.put((Object)attribute, (Object)attribMod);
        }
        return modifiers;
    }

    CraftMetaItem(Map<String, Object> map) {
        String custom;
        Object nbtMap;
        Iterable removed;
        String unhandled;
        String internal;
        Integer maxDamage;
        Integer damage;
        CraftJukeboxComponent jukeboxPlayable;
        CraftToolComponent tool;
        CraftFoodComponent food;
        String rarity;
        Integer maxStackSize;
        Boolean fireResistant;
        Boolean enchantmentGlintOverride;
        Boolean unbreakable;
        Boolean hideTooltip;
        Iterable hideFlags;
        Object blockData;
        Integer customModelData;
        this.displayName = CraftChatMessage.fromJSONOrString(SerializableMeta.getString(map, CraftMetaItem.NAME.BUKKIT, true), true, false);
        this.itemName = CraftChatMessage.fromJSONOrNull(SerializableMeta.getString(map, CraftMetaItem.ITEM_NAME.BUKKIT, true));
        Iterable lore = SerializableMeta.getObject(Iterable.class, map, CraftMetaItem.LORE.BUKKIT, true);
        if (lore != null) {
            this.lore = new ArrayList<class_2561>();
            CraftMetaItem.safelyAdd(lore, this.lore, true);
        }
        if ((customModelData = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.CUSTOM_MODEL_DATA.BUKKIT, true)) != null) {
            this.setCustomModelData(customModelData);
        }
        if ((blockData = SerializableMeta.getObject(Object.class, map, CraftMetaItem.BLOCK_DATA.BUKKIT, true)) != null) {
            HashMap<String, String> mapBlockData = new HashMap<String, String>();
            class_2487 nbtBlockData = (class_2487)CraftNBTTagConfigSerializer.deserialize(blockData);
            for (String key : nbtBlockData.method_10541()) {
                mapBlockData.put(key, nbtBlockData.method_10558(key));
            }
            this.blockData = mapBlockData;
        }
        this.enchantments = CraftMetaItem.buildEnchantments(map, ENCHANTMENTS);
        this.attributeModifiers = CraftMetaItem.buildModifiers(map, ATTRIBUTES);
        Integer repairCost = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.REPAIR.BUKKIT, true);
        if (repairCost != null) {
            this.setRepairCost(repairCost);
        }
        if ((hideFlags = SerializableMeta.getObject(Iterable.class, map, CraftMetaItem.HIDEFLAGS.BUKKIT, true)) != null) {
            for (Object hideFlagObject : hideFlags) {
                String hideFlagString = (String)hideFlagObject;
                try {
                    ItemFlag hideFlatEnum = CraftItemFlag.stringToBukkit(hideFlagString);
                    this.addItemFlags(hideFlatEnum);
                }
                catch (IllegalArgumentException hideFlatEnum) {}
            }
        }
        if ((hideTooltip = SerializableMeta.getObject(Boolean.class, map, CraftMetaItem.HIDE_TOOLTIP.BUKKIT, true)) != null) {
            this.setHideTooltip(hideTooltip);
        }
        if ((unbreakable = SerializableMeta.getObject(Boolean.class, map, CraftMetaItem.UNBREAKABLE.BUKKIT, true)) != null) {
            this.setUnbreakable(unbreakable);
        }
        if ((enchantmentGlintOverride = SerializableMeta.getObject(Boolean.class, map, CraftMetaItem.ENCHANTMENT_GLINT_OVERRIDE.BUKKIT, true)) != null) {
            this.setEnchantmentGlintOverride(enchantmentGlintOverride);
        }
        if ((fireResistant = SerializableMeta.getObject(Boolean.class, map, CraftMetaItem.FIRE_RESISTANT.BUKKIT, true)) != null) {
            this.setFireResistant(fireResistant);
        }
        if ((maxStackSize = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.MAX_STACK_SIZE.BUKKIT, true)) != null) {
            this.setMaxStackSize(maxStackSize);
        }
        if ((rarity = SerializableMeta.getString(map, CraftMetaItem.RARITY.BUKKIT, true)) != null) {
            this.setRarity(ItemRarity.valueOf(rarity));
        }
        if ((food = SerializableMeta.getObject(CraftFoodComponent.class, map, CraftMetaItem.FOOD.BUKKIT, true)) != null) {
            this.setFood(food);
        }
        if ((tool = SerializableMeta.getObject(CraftToolComponent.class, map, CraftMetaItem.TOOL.BUKKIT, true)) != null) {
            this.setTool(tool);
        }
        if ((jukeboxPlayable = SerializableMeta.getObject(CraftJukeboxComponent.class, map, CraftMetaItem.JUKEBOX_PLAYABLE.BUKKIT, true)) != null) {
            this.setJukeboxPlayable(jukeboxPlayable);
        }
        if ((damage = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.DAMAGE.BUKKIT, true)) != null) {
            this.setDamage(damage);
        }
        if ((maxDamage = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.MAX_DAMAGE.BUKKIT, true)) != null) {
            this.setMaxDamage(maxDamage);
        }
        if ((internal = SerializableMeta.getString(map, "internal", true)) != null) {
            ByteArrayInputStream buf = new ByteArrayInputStream(Base64.getDecoder().decode(internal));
            try {
                class_2487 internalTag = class_2507.method_10629((InputStream)buf, (class_2505)class_2505.method_53898());
                this.deserializeInternal(internalTag, map);
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if ((unhandled = SerializableMeta.getString(map, "unhandled", true)) != null) {
            ByteArrayInputStream buf = new ByteArrayInputStream(Base64.getDecoder().decode(unhandled));
            try {
                class_2487 unhandledTag = class_2507.method_10629((InputStream)buf, (class_2505)class_2505.method_53898());
                class_9326 unhandledPatch = (class_9326)class_9326.field_49589.parse((DynamicOps)MinecraftServer.getDefaultRegistryAccess().method_57093((DynamicOps)class_2509.field_11560), (Object)unhandledTag).result().get();
                this.unhandledTags.copy(unhandledPatch);
                for (Map.Entry entry : unhandledPatch.method_57846()) {
                    if (((Optional)entry.getValue()).isPresent()) continue;
                    class_9331 key = (class_9331)entry.getKey();
                    this.unhandledTags.clear(key);
                    this.removedTags.add(key);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if ((removed = SerializableMeta.getObject(Iterable.class, map, "removed", true)) != null) {
            class_5455 registryAccess = CraftRegistry.getMinecraftRegistry();
            class_2378 componentTypeRegistry = registryAccess.method_30530(class_7924.field_49659);
            for (Object removedObject : removed) {
                String removedString = (String)removedObject;
                class_9331 component = (class_9331)componentTypeRegistry.method_10223(class_2960.method_60654((String)removedString));
                if (component == null) continue;
                this.removedTags.add(component);
            }
        }
        if ((nbtMap = SerializableMeta.getObject(Object.class, map, CraftMetaItem.BUKKIT_CUSTOM_TAG.BUKKIT, true)) != null) {
            this.persistentDataContainer.putAll((class_2487)CraftNBTTagConfigSerializer.deserialize(nbtMap));
        }
        if ((custom = SerializableMeta.getString(map, "custom", true)) != null) {
            ByteArrayInputStream buf = new ByteArrayInputStream(Base64.getDecoder().decode(custom));
            try {
                this.customTag = class_2507.method_10629((InputStream)buf, (class_2505)class_2505.method_53898());
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    void deserializeInternal(class_2487 tag, Object context) {
        if (tag.method_10573(CraftMetaItem.ATTRIBUTES.NBT, 9)) {
            this.attributeModifiers = CraftMetaItem.buildModifiersLegacy(tag, ATTRIBUTES);
        }
    }

    private static Multimap<Attribute, AttributeModifier> buildModifiersLegacy(class_2487 tag, ItemMetaKey key) {
        LinkedHashMultimap modifiers = LinkedHashMultimap.create();
        if (!tag.method_10573(key.NBT, 9)) {
            return modifiers;
        }
        class_2499 mods = tag.method_10554(key.NBT, 10);
        int size = mods.size();
        for (int i = 0; i < size; ++i) {
            Attribute attribute;
            class_1322 nmsModifier;
            class_2487 entry = mods.method_10602(i);
            if (entry.method_33133() || (nmsModifier = class_1322.method_26859((class_2487)entry)) == null) continue;
            AttributeModifier attribMod = CraftAttributeInstance.convert(nmsModifier);
            String attributeName = entry.method_10558(CraftMetaItem.ATTRIBUTES_IDENTIFIER.NBT);
            if (attributeName == null || attributeName.isEmpty() || (attribute = CraftAttribute.stringToBukkit(attributeName)) == null) continue;
            if (entry.method_10573(CraftMetaItem.ATTRIBUTES_SLOT.NBT, 8)) {
                String slotName = entry.method_10558(CraftMetaItem.ATTRIBUTES_SLOT.NBT);
                if (slotName == null || slotName.isEmpty()) {
                    modifiers.put((Object)attribute, (Object)attribMod);
                    continue;
                }
                EquipmentSlot slot = null;
                try {
                    slot = CraftEquipmentSlot.getSlot(class_1304.method_5924((String)slotName.toLowerCase(Locale.ROOT)));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (slot == null) {
                    modifiers.put((Object)attribute, (Object)attribMod);
                    continue;
                }
                attribMod = new AttributeModifier(attribMod.getKey(), attribMod.getAmount(), attribMod.getOperation(), slot.getGroup());
            }
            modifiers.put((Object)attribute, (Object)attribMod);
        }
        return modifiers;
    }

    static Map<Enchantment, Integer> buildEnchantments(Map<String, Object> map, ItemMetaKey key) {
        Map ench = SerializableMeta.getObject(Map.class, map, key.BUKKIT, true);
        if (ench == null) {
            return null;
        }
        LinkedHashMap<Enchantment, Integer> enchantments = new LinkedHashMap<Enchantment, Integer>(ench.size());
        for (Map.Entry entry : ench.entrySet()) {
            Enchantment enchantment = CraftEnchantment.stringToBukkit(entry.getKey().toString());
            if (enchantment == null || !(entry.getValue() instanceof Integer)) continue;
            enchantments.put(enchantment, (Integer)entry.getValue());
        }
        return enchantments;
    }

    static Multimap<Attribute, AttributeModifier> buildModifiers(Map<String, Object> map, ItemMetaKey key) {
        Map mods = SerializableMeta.getObject(Map.class, map, key.BUKKIT, true);
        LinkedHashMultimap result = LinkedHashMultimap.create();
        if (mods == null) {
            return result;
        }
        for (Object obj : mods.keySet()) {
            String attributeName;
            if (!(obj instanceof String) || Strings.isNullOrEmpty((String)(attributeName = (String)obj))) continue;
            List list = SerializableMeta.getObject(List.class, mods, attributeName, true);
            if (list == null || list.isEmpty()) {
                return result;
            }
            for (Object o : list) {
                if (!(o instanceof AttributeModifier)) continue;
                AttributeModifier modifier = (AttributeModifier)o;
                Attribute attribute = CraftAttribute.stringToBukkit(attributeName);
                if (attribute == null) continue;
                result.put((Object)attribute, (Object)modifier);
            }
        }
        return result;
    }

    @Overridden
    void applyToItem(Applicator itemTag) {
        class_2487 customTag;
        if (this.hasDisplayName()) {
            itemTag.put(NAME, this.displayName);
        }
        if (this.hasItemName()) {
            itemTag.put(ITEM_NAME, this.itemName);
        }
        if (this.lore != null) {
            itemTag.put(LORE, new class_9290(this.lore));
        }
        if (this.hasCustomModelData()) {
            itemTag.put(CUSTOM_MODEL_DATA, new class_9280(this.customModelData.intValue()));
        }
        if (this.hasBlockData()) {
            itemTag.put(BLOCK_DATA, new class_9275(this.blockData));
        }
        if (this.hideFlag != 0 && this.hasItemFlag(ItemFlag.HIDE_ADDITIONAL_TOOLTIP)) {
            itemTag.put(HIDE_ADDITIONAL_TOOLTIP, class_3902.field_17274);
        }
        this.applyEnchantments(this.enchantments, itemTag, ENCHANTMENTS, ItemFlag.HIDE_ENCHANTS);
        this.applyModifiers(this.attributeModifiers, itemTag);
        if (this.hasRepairCost()) {
            itemTag.put(REPAIR, this.repairCost);
        }
        if (this.isHideTooltip()) {
            itemTag.put(HIDE_TOOLTIP, class_3902.field_17274);
        }
        if (this.isUnbreakable()) {
            itemTag.put(UNBREAKABLE, new class_9300(!this.hasItemFlag(ItemFlag.HIDE_UNBREAKABLE)));
        }
        if (this.hasEnchantmentGlintOverride()) {
            itemTag.put(ENCHANTMENT_GLINT_OVERRIDE, this.getEnchantmentGlintOverride());
        }
        if (this.isFireResistant()) {
            itemTag.put(FIRE_RESISTANT, class_3902.field_17274);
        }
        if (this.hasMaxStackSize()) {
            itemTag.put(MAX_STACK_SIZE, this.maxStackSize);
        }
        if (this.hasRarity()) {
            itemTag.put(RARITY, class_1814.valueOf((String)this.rarity.name()));
        }
        if (this.hasFood()) {
            itemTag.put(FOOD, this.food.getHandle());
        }
        if (this.hasTool()) {
            itemTag.put(TOOL, this.tool.getHandle());
        }
        if (this.hasJukeboxPlayable()) {
            itemTag.put(JUKEBOX_PLAYABLE, this.jukebox.getHandle());
        }
        if (this.hasDamage()) {
            itemTag.put(DAMAGE, this.damage);
        }
        if (this.hasMaxDamage()) {
            itemTag.put(MAX_DAMAGE, this.maxDamage);
        }
        for (Map.Entry entry : this.unhandledTags.method_57852().method_57846()) {
            ((Optional)entry.getValue()).ifPresent(value -> itemTag.builder.method_57854((class_9331)e.getKey(), value));
        }
        for (class_9331 class_93312 : this.removedTags) {
            if (itemTag.builder.isSet(class_93312)) continue;
            itemTag.builder.method_57853(class_93312);
        }
        class_2487 class_24872 = customTag = this.customTag != null ? this.customTag.method_10553() : null;
        if (!this.persistentDataContainer.isEmpty()) {
            class_2487 class_24873 = new class_2487();
            Map<String, class_2520> rawPublicMap = this.persistentDataContainer.getRaw();
            for (Map.Entry<String, class_2520> nbtBaseEntry : rawPublicMap.entrySet()) {
                class_24873.method_10566(nbtBaseEntry.getKey(), nbtBaseEntry.getValue());
            }
            if (customTag == null) {
                customTag = new class_2487();
            }
            customTag.method_10566(CraftMetaItem.BUKKIT_CUSTOM_TAG.BUKKIT, (class_2520)class_24873);
        }
        if (customTag != null) {
            itemTag.put(CUSTOM_DATA, class_9279.method_57456((class_2487)customTag));
        }
    }

    void applyEnchantments(Map<Enchantment, Integer> enchantments, Applicator tag, ItemMetaKeyType<class_9304> key, ItemFlag itemFlag) {
        if (enchantments == null) {
            return;
        }
        class_9304.class_9305 list = new class_9304.class_9305(class_9304.field_49385);
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            list.method_57547(CraftEnchantment.bukkitToMinecraftHolder(entry.getKey()), entry.getValue().intValue());
        }
        list.field_49392 = !this.hasItemFlag(itemFlag);
        tag.put(key, list.method_57549());
    }

    void applyModifiers(Multimap<Attribute, AttributeModifier> modifiers, Applicator tag) {
        if (modifiers == null || modifiers.isEmpty()) {
            if (this.hasItemFlag(ItemFlag.HIDE_ATTRIBUTES)) {
                tag.put(ATTRIBUTES, new class_9285(Collections.emptyList(), false));
            }
            return;
        }
        class_9285.class_9286 list = class_9285.method_57480();
        for (Map.Entry entry : modifiers.entries()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            class_1322 nmsModifier = CraftAttributeInstance.convert((AttributeModifier)entry.getValue());
            class_6880<class_1320> name = CraftAttribute.bukkitToMinecraftHolder((Attribute)entry.getKey());
            if (name == null) continue;
            class_9274 group = CraftEquipmentSlot.getNMSGroup(((AttributeModifier)entry.getValue()).getSlotGroup());
            list.method_57487(name, nmsModifier, group);
        }
        tag.put(ATTRIBUTES, list.method_57486().method_58423(!this.hasItemFlag(ItemFlag.HIDE_ATTRIBUTES)));
    }

    boolean applicableTo(Material type) {
        if (type == Material.AIR || !type.isItem()) {
            return false;
        }
        if (this.getClass() == CraftMetaItem.class) {
            return true;
        }
        return type.asItemType().getItemMetaClass() == this.getClass().getInterfaces()[0];
    }

    @Overridden
    boolean isEmpty() {
        return !this.hasDisplayName() && !this.hasItemName() && !this.hasLocalizedName() && !this.hasEnchants() && this.lore == null && !this.hasCustomModelData() && !this.hasBlockData() && !this.hasRepairCost() && this.unhandledTags.method_57852().method_57848() && this.removedTags.isEmpty() && this.persistentDataContainer.isEmpty() && this.hideFlag == 0 && !this.isHideTooltip() && !this.isUnbreakable() && !this.hasEnchantmentGlintOverride() && !this.isFireResistant() && !this.hasMaxStackSize() && !this.hasRarity() && !this.hasFood() && !this.hasTool() && !this.hasDamage() && !this.hasMaxDamage() && !this.hasAttributeModifiers() && this.customTag == null;
    }

    @Override
    public String getDisplayName() {
        return CraftChatMessage.fromComponent(this.displayName);
    }

    @Override
    public final void setDisplayName(String name) {
        this.displayName = CraftChatMessage.fromStringOrNull(name);
    }

    @Override
    public boolean hasDisplayName() {
        return this.displayName != null;
    }

    @Override
    public String getItemName() {
        return CraftChatMessage.fromComponent(this.itemName);
    }

    @Override
    public final void setItemName(String name) {
        this.itemName = CraftChatMessage.fromStringOrNull(name);
    }

    @Override
    public boolean hasItemName() {
        return this.itemName != null;
    }

    @Override
    public String getLocalizedName() {
        return this.getDisplayName();
    }

    @Override
    public void setLocalizedName(String name) {
    }

    @Override
    public boolean hasLocalizedName() {
        return false;
    }

    @Override
    public boolean hasLore() {
        return this.lore != null && !this.lore.isEmpty();
    }

    @Override
    public boolean hasRepairCost() {
        return this.repairCost > 0;
    }

    @Override
    public boolean hasEnchant(Enchantment ench) {
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        return this.hasEnchants() && this.enchantments.containsKey(ench);
    }

    @Override
    public int getEnchantLevel(Enchantment ench) {
        Integer level;
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        Integer n = level = this.hasEnchants() ? this.enchantments.get(ench) : null;
        if (level == null) {
            return 0;
        }
        return level;
    }

    @Override
    public Map<Enchantment, Integer> getEnchants() {
        return this.hasEnchants() ? ImmutableMap.copyOf(this.enchantments) : ImmutableMap.of();
    }

    @Override
    public boolean addEnchant(Enchantment ench, int level, boolean ignoreRestrictions) {
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        if (this.enchantments == null) {
            this.enchantments = new LinkedHashMap<Enchantment, Integer>(4);
        }
        if (ignoreRestrictions || level >= ench.getStartLevel() && level <= ench.getMaxLevel()) {
            Integer old = this.enchantments.put(ench, level);
            return old == null || old != level;
        }
        return false;
    }

    @Override
    public boolean removeEnchant(Enchantment ench) {
        boolean enchantmentRemoved;
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        boolean bl = enchantmentRemoved = this.hasEnchants() && this.enchantments.remove(ench) != null;
        if (enchantmentRemoved && this.enchantments.isEmpty()) {
            this.enchantments = null;
        }
        return enchantmentRemoved;
    }

    @Override
    public void removeEnchantments() {
        if (this.hasEnchants()) {
            this.enchantments.clear();
        }
    }

    @Override
    public boolean hasEnchants() {
        return this.enchantments != null && !this.enchantments.isEmpty();
    }

    @Override
    public boolean hasConflictingEnchant(Enchantment ench) {
        return CraftMetaItem.checkConflictingEnchants(this.enchantments, ench);
    }

    @Override
    public void addItemFlags(ItemFlag ... hideFlags) {
        for (ItemFlag f : hideFlags) {
            this.hideFlag |= this.getBitModifier(f);
        }
    }

    @Override
    public void removeItemFlags(ItemFlag ... hideFlags) {
        for (ItemFlag f : hideFlags) {
            this.hideFlag &= ~this.getBitModifier(f);
        }
    }

    @Override
    public Set<ItemFlag> getItemFlags() {
        EnumSet<ItemFlag> currentFlags = EnumSet.noneOf(ItemFlag.class);
        for (ItemFlag f : ItemFlag.values()) {
            if (!this.hasItemFlag(f)) continue;
            currentFlags.add(f);
        }
        return currentFlags;
    }

    @Override
    public boolean hasItemFlag(ItemFlag flag) {
        int bitModifier = this.getBitModifier(flag);
        return (this.hideFlag & bitModifier) == bitModifier;
    }

    private int getBitModifier(ItemFlag hideFlag) {
        return 1 << hideFlag.ordinal();
    }

    @Override
    public List<String> getLore() {
        return this.lore == null ? null : new ArrayList(Lists.transform(this.lore, CraftChatMessage::fromComponent));
    }

    @Override
    public void setLore(List<String> lore) {
        if (lore == null || lore.isEmpty()) {
            this.lore = null;
        } else {
            if (this.lore == null) {
                this.lore = new ArrayList<class_2561>(lore.size());
            } else {
                this.lore.clear();
            }
            CraftMetaItem.safelyAdd(lore, this.lore, false);
        }
    }

    @Override
    public boolean hasCustomModelData() {
        return this.customModelData != null;
    }

    @Override
    public int getCustomModelData() {
        Preconditions.checkState((boolean)this.hasCustomModelData(), (Object)"We don't have CustomModelData! Check hasCustomModelData first!");
        return this.customModelData;
    }

    @Override
    public void setCustomModelData(Integer data) {
        this.customModelData = data;
    }

    @Override
    public boolean hasBlockData() {
        return this.blockData != null;
    }

    @Override
    public BlockData getBlockData(Material material) {
        class_2680 defaultData = CraftBlockType.bukkitToMinecraft(material).method_9564();
        return CraftBlockData.fromData(this.hasBlockData() ? new class_9275(this.blockData).method_57415(defaultData) : defaultData);
    }

    @Override
    public void setBlockData(BlockData blockData) {
        this.blockData = blockData == null ? null : ((CraftBlockData)blockData).toStates();
    }

    @Override
    public int getRepairCost() {
        return this.repairCost;
    }

    @Override
    public void setRepairCost(int cost) {
        this.repairCost = cost;
    }

    @Override
    public boolean isHideTooltip() {
        return this.hideTooltip;
    }

    @Override
    public void setHideTooltip(boolean hideTooltip) {
        this.hideTooltip = hideTooltip;
    }

    @Override
    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    @Override
    public void setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
    }

    @Override
    public boolean hasEnchantmentGlintOverride() {
        return this.enchantmentGlintOverride != null;
    }

    @Override
    public Boolean getEnchantmentGlintOverride() {
        Preconditions.checkState((boolean)this.hasEnchantmentGlintOverride(), (Object)"We don't have enchantment_glint_override! Check hasEnchantmentGlintOverride first!");
        return this.enchantmentGlintOverride;
    }

    @Override
    public void setEnchantmentGlintOverride(Boolean override) {
        this.enchantmentGlintOverride = override;
    }

    @Override
    public boolean isFireResistant() {
        return this.fireResistant;
    }

    @Override
    public void setFireResistant(boolean fireResistant) {
        this.fireResistant = fireResistant;
    }

    @Override
    public boolean hasMaxStackSize() {
        return this.maxStackSize != null;
    }

    @Override
    public int getMaxStackSize() {
        Preconditions.checkState((boolean)this.hasMaxStackSize(), (Object)"We don't have max_stack_size! Check hasMaxStackSize first!");
        return this.maxStackSize;
    }

    @Override
    public void setMaxStackSize(Integer max) {
        Preconditions.checkArgument((max == null || max > 0 ? 1 : 0) != 0, (Object)"max_stack_size must be > 0");
        Preconditions.checkArgument((max == null || max <= 99 ? 1 : 0) != 0, (Object)"max_stack_size must be <= 99");
        this.maxStackSize = max;
    }

    @Override
    public boolean hasRarity() {
        return this.rarity != null;
    }

    @Override
    public ItemRarity getRarity() {
        Preconditions.checkState((boolean)this.hasRarity(), (Object)"We don't have rarity! Check hasRarity first!");
        return this.rarity;
    }

    @Override
    public void setRarity(ItemRarity rarity) {
        this.rarity = rarity;
    }

    @Override
    public boolean hasFood() {
        return this.food != null;
    }

    @Override
    public FoodComponent getFood() {
        return this.hasFood() ? new CraftFoodComponent(this.food) : new CraftFoodComponent(new class_4174(0, 0.0f, false, 0.0f, Optional.empty(), Collections.emptyList()));
    }

    @Override
    public void setFood(FoodComponent food) {
        this.food = food == null ? null : new CraftFoodComponent((CraftFoodComponent)food);
    }

    @Override
    public boolean hasTool() {
        return this.tool != null;
    }

    @Override
    public ToolComponent getTool() {
        return this.hasTool() ? new CraftToolComponent(this.tool) : new CraftToolComponent(new class_9424(Collections.emptyList(), 1.0f, 0));
    }

    @Override
    public void setTool(ToolComponent tool) {
        this.tool = tool == null ? null : new CraftToolComponent((CraftToolComponent)tool);
    }

    @Override
    public boolean hasJukeboxPlayable() {
        return this.jukebox != null;
    }

    @Override
    public JukeboxPlayableComponent getJukeboxPlayable() {
        return this.hasJukeboxPlayable() ? new CraftJukeboxComponent(this.jukebox) : new CraftJukeboxComponent(new class_9792(new class_9791(class_9796.field_52037), true));
    }

    @Override
    public void setJukeboxPlayable(JukeboxPlayableComponent jukeboxPlayable) {
        this.jukebox = jukeboxPlayable == null ? null : new CraftJukeboxComponent((CraftJukeboxComponent)jukeboxPlayable);
    }

    @Override
    public boolean hasAttributeModifiers() {
        return this.attributeModifiers != null && !this.attributeModifiers.isEmpty();
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers() {
        return this.hasAttributeModifiers() ? ImmutableMultimap.copyOf(this.attributeModifiers) : null;
    }

    private void checkAttributeList() {
        if (this.attributeModifiers == null) {
            this.attributeModifiers = LinkedHashMultimap.create();
        }
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nullable EquipmentSlot slot) {
        this.checkAttributeList();
        LinkedHashMultimap result = LinkedHashMultimap.create();
        for (Map.Entry entry : this.attributeModifiers.entries()) {
            if (((AttributeModifier)entry.getValue()).getSlot() != null && ((AttributeModifier)entry.getValue()).getSlot() != slot) continue;
            result.put((Object)((Attribute)entry.getKey()), (Object)((AttributeModifier)entry.getValue()));
        }
        return result;
    }

    @Override
    public Collection<AttributeModifier> getAttributeModifiers(@Nonnull Attribute attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        return this.attributeModifiers.containsKey((Object)attribute) ? ImmutableList.copyOf((Collection)this.attributeModifiers.get((Object)attribute)) : null;
    }

    @Override
    public boolean addAttributeModifier(@Nonnull Attribute attribute, @Nonnull AttributeModifier modifier) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        Preconditions.checkNotNull((Object)modifier, (Object)"AttributeModifier cannot be null");
        this.checkAttributeList();
        for (Map.Entry entry : this.attributeModifiers.entries()) {
            Preconditions.checkArgument((!((AttributeModifier)entry.getValue()).getKey().equals(modifier.getKey()) ? 1 : 0) != 0, (String)"Cannot register AttributeModifier. Modifier is already applied! %s", (Object)modifier);
        }
        return this.attributeModifiers.put((Object)attribute, (Object)modifier);
    }

    @Override
    public void setAttributeModifiers(@Nullable Multimap<Attribute, AttributeModifier> attributeModifiers) {
        if (attributeModifiers == null || attributeModifiers.isEmpty()) {
            this.attributeModifiers = LinkedHashMultimap.create();
            return;
        }
        this.checkAttributeList();
        this.attributeModifiers.clear();
        Iterator iterator = attributeModifiers.entries().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            if (next.getKey() == null || next.getValue() == null) {
                iterator.remove();
                continue;
            }
            this.attributeModifiers.put((Object)((Attribute)next.getKey()), (Object)((AttributeModifier)next.getValue()));
        }
    }

    @Override
    public boolean removeAttributeModifier(@Nonnull Attribute attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        this.checkAttributeList();
        return !this.attributeModifiers.removeAll((Object)attribute).isEmpty();
    }

    @Override
    public boolean removeAttributeModifier(@Nullable EquipmentSlot slot) {
        this.checkAttributeList();
        int removed = 0;
        Iterator iter = this.attributeModifiers.entries().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (((AttributeModifier)entry.getValue()).getSlot() != null && ((AttributeModifier)entry.getValue()).getSlot() != slot) continue;
            iter.remove();
            ++removed;
        }
        return removed > 0;
    }

    @Override
    public boolean removeAttributeModifier(@Nonnull Attribute attribute, @Nonnull AttributeModifier modifier) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        Preconditions.checkNotNull((Object)modifier, (Object)"AttributeModifier cannot be null");
        this.checkAttributeList();
        int removed = 0;
        Iterator iter = this.attributeModifiers.entries().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (entry.getKey() == null || entry.getValue() == null) {
                iter.remove();
                ++removed;
                continue;
            }
            if (entry.getKey() != attribute || !((AttributeModifier)entry.getValue()).getKey().equals(modifier.getKey())) continue;
            iter.remove();
            ++removed;
        }
        return removed > 0;
    }

    @Override
    public String getAsString() {
        Applicator tag = new Applicator();
        this.applyToItem(tag);
        class_9326 patch = tag.build();
        class_2520 nbt = (class_2520)class_9326.field_49589.encodeStart((DynamicOps)MinecraftServer.getDefaultRegistryAccess().method_57093((DynamicOps)class_2509.field_11560), (Object)patch).getOrThrow();
        return nbt.toString();
    }

    @Override
    public String getAsComponentString() {
        Applicator tag = new Applicator();
        this.applyToItem(tag);
        class_9326 patch = tag.build();
        class_5455 registryAccess = CraftRegistry.getMinecraftRegistry();
        class_6903 ops = registryAccess.method_57093((DynamicOps)class_2509.field_11560);
        class_2378 componentTypeRegistry = registryAccess.method_30530(class_7924.field_49659);
        StringJoiner componentString = new StringJoiner(",", "[", "]");
        for (Map.Entry entry : patch.method_57846()) {
            class_9331 componentType = (class_9331)entry.getKey();
            Optional componentValue = (Optional)entry.getValue();
            String componentKey = ((class_5321)componentTypeRegistry.method_29113((Object)componentType).orElseThrow()).method_29177().toString();
            if (componentValue.isPresent()) {
                class_2520 componentValueAsNBT = (class_2520)componentType.method_57876().encodeStart((DynamicOps)ops, componentValue.get()).getOrThrow();
                String componentValueAsNBTString = new class_5625("", 0, new ArrayList()).method_32283(componentValueAsNBT);
                componentString.add(componentKey + "=" + componentValueAsNBTString);
                continue;
            }
            componentString.add("!" + componentKey);
        }
        return componentString.toString();
    }

    @Override
    public CustomItemTagContainer getCustomTagContainer() {
        return new DeprecatedCustomTagContainer(this.getPersistentDataContainer());
    }

    @Override
    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    private static boolean compareModifiers(Multimap<Attribute, AttributeModifier> first, Multimap<Attribute, AttributeModifier> second) {
        if (first == null || second == null) {
            return false;
        }
        for (Map.Entry entry : first.entries()) {
            if (second.containsEntry(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        for (Map.Entry entry : second.entries()) {
            if (first.containsEntry(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasDamage() {
        return this.damage > 0;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public void setDamage(int damage) {
        this.damage = damage;
    }

    @Override
    public boolean hasMaxDamage() {
        return this.maxDamage != null;
    }

    @Override
    public int getMaxDamage() {
        Preconditions.checkState((boolean)this.hasMaxDamage(), (Object)"We don't have max_damage! Check hasMaxDamage first!");
        return this.maxDamage;
    }

    @Override
    public void setMaxDamage(Integer maxDamage) {
        this.maxDamage = maxDamage;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof CraftMetaItem)) {
            return false;
        }
        return CraftItemFactory.instance().equals((ItemMeta)this, (ItemMeta)object);
    }

    @Overridden
    boolean equalsCommon(CraftMetaItem that) {
        return (this.hasDisplayName() ? that.hasDisplayName() && this.displayName.equals((Object)that.displayName) : !that.hasDisplayName()) && (this.hasItemName() ? that.hasItemName() && this.itemName.equals((Object)that.itemName) : !that.hasItemName()) && (this.hasEnchants() ? that.hasEnchants() && this.enchantments.equals(that.enchantments) : !that.hasEnchants()) && Objects.equals(this.lore, that.lore) && (this.hasCustomModelData() ? that.hasCustomModelData() && this.customModelData.equals(that.customModelData) : !that.hasCustomModelData()) && (this.hasBlockData() ? that.hasBlockData() && this.blockData.equals(that.blockData) : !that.hasBlockData()) && (this.hasRepairCost() ? that.hasRepairCost() && this.repairCost == that.repairCost : !that.hasRepairCost()) && (this.hasAttributeModifiers() ? that.hasAttributeModifiers() && CraftMetaItem.compareModifiers(this.attributeModifiers, that.attributeModifiers) : !that.hasAttributeModifiers()) && this.unhandledTags.equals((Object)that.unhandledTags) && this.removedTags.equals(that.removedTags) && Objects.equals(this.customTag, that.customTag) && this.persistentDataContainer.equals(that.persistentDataContainer) && this.hideFlag == that.hideFlag && this.isHideTooltip() == that.isHideTooltip() && this.isUnbreakable() == that.isUnbreakable() && (this.hasEnchantmentGlintOverride() ? that.hasEnchantmentGlintOverride() && this.enchantmentGlintOverride.equals(that.enchantmentGlintOverride) : !that.hasEnchantmentGlintOverride()) && this.fireResistant == that.fireResistant && (this.hasMaxStackSize() ? that.hasMaxStackSize() && this.maxStackSize.equals(that.maxStackSize) : !that.hasMaxStackSize()) && this.rarity == that.rarity && (this.hasFood() ? that.hasFood() && this.food.equals(that.food) : !that.hasFood()) && (this.hasTool() ? that.hasTool() && this.tool.equals(that.tool) : !that.hasTool()) && (this.hasJukeboxPlayable() ? that.hasJukeboxPlayable() && this.jukebox.equals(that.jukebox) : !that.hasJukeboxPlayable()) && (this.hasDamage() ? that.hasDamage() && this.damage == that.damage : !that.hasDamage()) && (this.hasMaxDamage() ? that.hasMaxDamage() && this.maxDamage.equals(that.maxDamage) : !that.hasMaxDamage()) && this.version == that.version;
    }

    @Overridden
    boolean notUncommon(CraftMetaItem meta) {
        return true;
    }

    public final int hashCode() {
        return this.applyHash();
    }

    @Overridden
    int applyHash() {
        int hash = 3;
        hash = 61 * hash + (this.hasDisplayName() ? this.displayName.hashCode() : 0);
        hash = 61 * hash + (this.hasItemName() ? this.itemName.hashCode() : 0);
        hash = 61 * hash + (this.lore != null ? this.lore.hashCode() : 0);
        hash = 61 * hash + (this.hasCustomModelData() ? this.customModelData.hashCode() : 0);
        hash = 61 * hash + (this.hasBlockData() ? this.blockData.hashCode() : 0);
        hash = 61 * hash + (this.hasEnchants() ? this.enchantments.hashCode() : 0);
        hash = 61 * hash + (this.hasRepairCost() ? this.repairCost : 0);
        hash = 61 * hash + this.unhandledTags.hashCode();
        hash = 61 * hash + this.removedTags.hashCode();
        hash = 61 * hash + (this.customTag != null ? this.customTag.hashCode() : 0);
        hash = 61 * hash + (!this.persistentDataContainer.isEmpty() ? this.persistentDataContainer.hashCode() : 0);
        hash = 61 * hash + this.hideFlag;
        hash = 61 * hash + (this.isHideTooltip() ? 1231 : 1237);
        hash = 61 * hash + (this.isUnbreakable() ? 1231 : 1237);
        hash = 61 * hash + (this.hasEnchantmentGlintOverride() ? this.enchantmentGlintOverride.hashCode() : 0);
        hash = 61 * hash + (this.isFireResistant() ? 1231 : 1237);
        hash = 61 * hash + (this.hasMaxStackSize() ? this.maxStackSize.hashCode() : 0);
        hash = 61 * hash + (this.hasRarity() ? this.rarity.hashCode() : 0);
        hash = 61 * hash + (this.hasFood() ? this.food.hashCode() : 0);
        hash = 61 * hash + (this.hasTool() ? this.tool.hashCode() : 0);
        hash = 61 * hash + (this.hasJukeboxPlayable() ? this.jukebox.hashCode() : 0);
        hash = 61 * hash + (this.hasDamage() ? this.damage : 0);
        hash = 61 * hash + (this.hasMaxDamage() ? 1231 : 1237);
        hash = 61 * hash + (this.hasAttributeModifiers() ? this.attributeModifiers.hashCode() : 0);
        hash = 61 * hash + this.version;
        return hash;
    }

    @Override
    @Overridden
    public CraftMetaItem clone() {
        try {
            CraftMetaItem clone = (CraftMetaItem)super.clone();
            if (this.lore != null) {
                clone.lore = new ArrayList<class_2561>(this.lore);
            }
            clone.customModelData = this.customModelData;
            clone.blockData = this.blockData;
            if (this.enchantments != null) {
                clone.enchantments = new LinkedHashMap<Enchantment, Integer>(this.enchantments);
            }
            if (this.hasAttributeModifiers()) {
                clone.attributeModifiers = LinkedHashMultimap.create(this.attributeModifiers);
            }
            if (this.customTag != null) {
                clone.customTag = this.customTag.method_10553();
            }
            clone.removedTags = Sets.newHashSet(this.removedTags);
            clone.persistentDataContainer = new CraftPersistentDataContainer(this.persistentDataContainer.getRaw(), DATA_TYPE_REGISTRY);
            clone.hideFlag = this.hideFlag;
            clone.hideTooltip = this.hideTooltip;
            clone.unbreakable = this.unbreakable;
            clone.enchantmentGlintOverride = this.enchantmentGlintOverride;
            clone.fireResistant = this.fireResistant;
            clone.maxStackSize = this.maxStackSize;
            clone.rarity = this.rarity;
            if (this.hasFood()) {
                clone.food = new CraftFoodComponent(this.food);
            }
            if (this.hasTool()) {
                clone.tool = new CraftToolComponent(this.tool);
            }
            if (this.hasJukeboxPlayable()) {
                clone.jukebox = new CraftJukeboxComponent(this.jukebox);
            }
            clone.damage = this.damage;
            clone.maxDamage = this.maxDamage;
            clone.version = this.version;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    @Override
    public final Map<String, Object> serialize() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)"meta-type", SerializableMeta.classMap.get(this.getClass()));
        this.serialize((ImmutableMap.Builder<String, Object>)map);
        return map.build();
    }

    @Overridden
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        ByteArrayOutputStream buf;
        if (this.hasDisplayName()) {
            builder.put((Object)CraftMetaItem.NAME.BUKKIT, (Object)CraftChatMessage.toJSON(this.displayName));
        }
        if (this.hasItemName()) {
            builder.put((Object)CraftMetaItem.ITEM_NAME.BUKKIT, (Object)CraftChatMessage.toJSON(this.itemName));
        }
        if (this.hasLore()) {
            ArrayList<String> jsonLore = new ArrayList<String>();
            for (class_2561 component : this.lore) {
                jsonLore.add(CraftChatMessage.toJSON(component));
            }
            builder.put((Object)CraftMetaItem.LORE.BUKKIT, jsonLore);
        }
        if (this.hasCustomModelData()) {
            builder.put((Object)CraftMetaItem.CUSTOM_MODEL_DATA.BUKKIT, (Object)this.customModelData);
        }
        if (this.hasBlockData()) {
            builder.put((Object)CraftMetaItem.BLOCK_DATA.BUKKIT, this.blockData);
        }
        CraftMetaItem.serializeEnchantments(this.enchantments, builder, ENCHANTMENTS);
        CraftMetaItem.serializeModifiers(this.attributeModifiers, builder, ATTRIBUTES);
        if (this.hasRepairCost()) {
            builder.put((Object)CraftMetaItem.REPAIR.BUKKIT, (Object)this.repairCost);
        }
        ArrayList<String> hideFlags = new ArrayList<String>();
        for (ItemFlag hideFlagEnum : this.getItemFlags()) {
            hideFlags.add(CraftItemFlag.bukkitToString(hideFlagEnum));
        }
        if (!hideFlags.isEmpty()) {
            builder.put((Object)CraftMetaItem.HIDEFLAGS.BUKKIT, hideFlags);
        }
        if (this.isHideTooltip()) {
            builder.put((Object)CraftMetaItem.HIDE_TOOLTIP.BUKKIT, (Object)this.hideTooltip);
        }
        if (this.isUnbreakable()) {
            builder.put((Object)CraftMetaItem.UNBREAKABLE.BUKKIT, (Object)this.unbreakable);
        }
        if (this.hasEnchantmentGlintOverride()) {
            builder.put((Object)CraftMetaItem.ENCHANTMENT_GLINT_OVERRIDE.BUKKIT, (Object)this.enchantmentGlintOverride);
        }
        if (this.isFireResistant()) {
            builder.put((Object)CraftMetaItem.FIRE_RESISTANT.BUKKIT, (Object)this.fireResistant);
        }
        if (this.hasMaxStackSize()) {
            builder.put((Object)CraftMetaItem.MAX_STACK_SIZE.BUKKIT, (Object)this.maxStackSize);
        }
        if (this.hasRarity()) {
            builder.put((Object)CraftMetaItem.RARITY.BUKKIT, (Object)this.rarity.name());
        }
        if (this.hasFood()) {
            builder.put((Object)CraftMetaItem.FOOD.BUKKIT, (Object)this.food);
        }
        if (this.hasTool()) {
            builder.put((Object)CraftMetaItem.TOOL.BUKKIT, (Object)this.tool);
        }
        if (this.hasJukeboxPlayable()) {
            builder.put((Object)CraftMetaItem.JUKEBOX_PLAYABLE.BUKKIT, (Object)this.jukebox);
        }
        if (this.hasDamage()) {
            builder.put((Object)CraftMetaItem.DAMAGE.BUKKIT, (Object)this.damage);
        }
        if (this.hasMaxDamage()) {
            builder.put((Object)CraftMetaItem.MAX_DAMAGE.BUKKIT, (Object)this.maxDamage);
        }
        HashMap<String, class_2520> internalTags = new HashMap<String, class_2520>();
        this.serializeInternal(internalTags);
        if (!internalTags.isEmpty()) {
            class_2487 internal = new class_2487();
            for (Map.Entry e : internalTags.entrySet()) {
                internal.method_10566((String)e.getKey(), (class_2520)e.getValue());
            }
            try {
                buf = new ByteArrayOutputStream();
                class_2507.method_10634((class_2487)internal, (OutputStream)buf);
                builder.put((Object)"internal", (Object)Base64.getEncoder().encodeToString(buf.toByteArray()));
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (!this.unhandledTags.isEmpty()) {
            class_2520 unhandled = (class_2520)class_9326.field_49589.encodeStart((DynamicOps)MinecraftServer.getDefaultRegistryAccess().method_57093((DynamicOps)class_2509.field_11560), (Object)this.unhandledTags.method_57852()).getOrThrow(IllegalStateException::new);
            try {
                buf = new ByteArrayOutputStream();
                class_2507.method_10634((class_2487)((class_2487)unhandled), (OutputStream)buf);
                builder.put((Object)"unhandled", (Object)Base64.getEncoder().encodeToString(buf.toByteArray()));
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (!this.removedTags.isEmpty()) {
            class_5455 registryAccess = CraftRegistry.getMinecraftRegistry();
            class_2378 componentTypeRegistry = registryAccess.method_30530(class_7924.field_49659);
            ArrayList<String> removedTags = new ArrayList<String>();
            for (class_9331<?> removed : this.removedTags) {
                String componentKey = ((class_5321)componentTypeRegistry.method_29113(removed).orElseThrow()).method_29177().toString();
                removedTags.add(componentKey);
            }
            builder.put((Object)"removed", removedTags);
        }
        if (!this.persistentDataContainer.isEmpty()) {
            builder.put((Object)CraftMetaItem.BUKKIT_CUSTOM_TAG.BUKKIT, (Object)this.persistentDataContainer.serialize());
        }
        if (this.customTag != null) {
            try {
                ByteArrayOutputStream buf2 = new ByteArrayOutputStream();
                class_2507.method_10634((class_2487)this.customTag, (OutputStream)buf2);
                builder.put((Object)"custom", (Object)Base64.getEncoder().encodeToString(buf2.toByteArray()));
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return builder;
    }

    void serializeInternal(Map<String, class_2520> unhandledTags) {
    }

    static void serializeEnchantments(Map<Enchantment, Integer> enchantments, ImmutableMap.Builder<String, Object> builder, ItemMetaKey key) {
        if (enchantments == null || enchantments.isEmpty()) {
            return;
        }
        ImmutableMap.Builder enchants = ImmutableMap.builder();
        for (Map.Entry<Enchantment, Integer> enchant : enchantments.entrySet()) {
            enchants.put((Object)CraftEnchantment.bukkitToString(enchant.getKey()), (Object)enchant.getValue());
        }
        builder.put((Object)key.BUKKIT, (Object)enchants.build());
    }

    static void serializeModifiers(Multimap<Attribute, AttributeModifier> modifiers, ImmutableMap.Builder<String, Object> builder, ItemMetaKey key) {
        if (modifiers == null || modifiers.isEmpty()) {
            return;
        }
        LinkedHashMap mods = new LinkedHashMap();
        for (Map.Entry entry : modifiers.entries()) {
            Collection modCollection;
            if (entry.getKey() == null || (modCollection = modifiers.get((Object)((Attribute)entry.getKey()))) == null || modCollection.isEmpty()) continue;
            mods.put(CraftAttribute.bukkitToString((Attribute)entry.getKey()), new ArrayList(modCollection));
        }
        builder.put((Object)key.BUKKIT, mods);
    }

    static void safelyAdd(Iterable<?> addFrom, Collection<class_2561> addTo, boolean possiblyJsonInput) {
        if (addFrom == null) {
            return;
        }
        for (Object object : addFrom) {
            class_2561 component;
            if (!(object instanceof String)) {
                if (object != null) {
                    throw new IllegalArgumentException(String.valueOf(addFrom) + " cannot contain non-string " + object.getClass().getName());
                }
                addTo.add((class_2561)class_2561.method_43473());
                continue;
            }
            String entry = object.toString();
            class_2561 class_25612 = component = possiblyJsonInput ? CraftChatMessage.fromJSONOrString(entry) : CraftChatMessage.fromStringOrNull(entry);
            if (component != null) {
                addTo.add(component);
                continue;
            }
            addTo.add((class_2561)class_2561.method_43473());
        }
    }

    static boolean checkConflictingEnchants(Map<Enchantment, Integer> enchantments, Enchantment ench) {
        if (enchantments == null || enchantments.isEmpty()) {
            return false;
        }
        for (Enchantment enchant : enchantments.keySet()) {
            if (!enchant.conflictsWith(ench)) continue;
            return true;
        }
        return false;
    }

    public final String toString() {
        return (String)SerializableMeta.classMap.get(this.getClass()) + "_META:" + String.valueOf(this.serialize());
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<class_9331> getHandledTags() {
        Set<class_9331> set = HANDLED_TAGS;
        synchronized (set) {
            if (HANDLED_TAGS.isEmpty()) {
                HANDLED_TAGS.addAll(Arrays.asList(CraftMetaItem.NAME.TYPE, CraftMetaItem.ITEM_NAME.TYPE, CraftMetaItem.LORE.TYPE, CraftMetaItem.CUSTOM_MODEL_DATA.TYPE, CraftMetaItem.BLOCK_DATA.TYPE, CraftMetaItem.REPAIR.TYPE, CraftMetaItem.ENCHANTMENTS.TYPE, CraftMetaItem.HIDE_ADDITIONAL_TOOLTIP.TYPE, CraftMetaItem.HIDE_TOOLTIP.TYPE, CraftMetaItem.UNBREAKABLE.TYPE, CraftMetaItem.ENCHANTMENT_GLINT_OVERRIDE.TYPE, CraftMetaItem.FIRE_RESISTANT.TYPE, CraftMetaItem.MAX_STACK_SIZE.TYPE, CraftMetaItem.RARITY.TYPE, CraftMetaItem.FOOD.TYPE, CraftMetaItem.TOOL.TYPE, CraftMetaItem.JUKEBOX_PLAYABLE.TYPE, CraftMetaItem.DAMAGE.TYPE, CraftMetaItem.MAX_DAMAGE.TYPE, CraftMetaItem.CUSTOM_DATA.TYPE, CraftMetaItem.ATTRIBUTES.TYPE, CraftMetaArmor.TRIM.TYPE, CraftMetaArmorStand.ENTITY_TAG.TYPE, CraftMetaBanner.PATTERNS.TYPE, CraftMetaEntityTag.ENTITY_TAG.TYPE, CraftMetaLeatherArmor.COLOR.TYPE, CraftMetaMap.MAP_POST_PROCESSING.TYPE, CraftMetaMap.MAP_COLOR.TYPE, CraftMetaMap.MAP_ID.TYPE, CraftMetaPotion.POTION_CONTENTS.TYPE, CraftMetaSkull.SKULL_PROFILE.TYPE, CraftMetaSkull.NOTE_BLOCK_SOUND.TYPE, CraftMetaSpawnEgg.ENTITY_TAG.TYPE, CraftMetaBlockState.BLOCK_ENTITY_TAG.TYPE, CraftMetaBook.BOOK_CONTENT.TYPE, CraftMetaBookSigned.BOOK_CONTENT.TYPE, CraftMetaFirework.FIREWORKS.TYPE, CraftMetaEnchantedBook.STORED_ENCHANTMENTS.TYPE, CraftMetaCharge.EXPLOSION.TYPE, CraftMetaBlockState.BLOCK_ENTITY_TAG.TYPE, CraftMetaKnowledgeBook.BOOK_RECIPES.TYPE, CraftMetaTropicalFishBucket.ENTITY_TAG.TYPE, CraftMetaTropicalFishBucket.BUCKET_ENTITY_TAG.TYPE, CraftMetaAxolotlBucket.ENTITY_TAG.TYPE, CraftMetaAxolotlBucket.BUCKET_ENTITY_TAG.TYPE, CraftMetaCrossbow.CHARGED_PROJECTILES.TYPE, CraftMetaSuspiciousStew.EFFECTS.TYPE, CraftMetaCompass.LODESTONE_TARGET.TYPE, CraftMetaBundle.ITEMS.TYPE, CraftMetaMusicInstrument.GOAT_HORN_INSTRUMENT.TYPE, CraftMetaOminousBottle.OMINOUS_BOTTLE_AMPLIFIER.TYPE));
            }
            return HANDLED_TAGS;
        }
    }

    protected static <T> Optional<? extends T> getOrEmpty(class_9326 tag, ItemMetaKeyType<T> type) {
        Optional result = tag.method_57845(type.TYPE);
        return result != null ? result : Optional.empty();
    }

    static final class ItemMetaKeyType<T>
    extends ItemMetaKey {
        final class_9331<T> TYPE;

        ItemMetaKeyType(class_9331<T> type) {
            this(type, null, null);
        }

        ItemMetaKeyType(class_9331<T> type, String both) {
            this(type, both, both);
        }

        ItemMetaKeyType(class_9331<T> type, String nbt, String bukkit) {
            super(nbt, bukkit);
            this.TYPE = type;
        }
    }

    static class ItemMetaKey {
        final String BUKKIT;
        final String NBT;

        ItemMetaKey(String both) {
            this(both, both);
        }

        ItemMetaKey(String nbt, String bukkit) {
            this.NBT = nbt;
            this.BUKKIT = bukkit;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @Target(value={ElementType.FIELD})
        static @interface Specific {
            public To value();

            public static enum To {
                BUKKIT,
                NBT;

            }
        }
    }

    static final class Applicator {
        private final class_9326.class_9327 builder = class_9326.method_57841();

        Applicator() {
        }

        <T> Applicator put(ItemMetaKeyType<T> key, T value) {
            this.builder.method_57854(key.TYPE, value);
            return this;
        }

        <T> Applicator putIfAbsent(class_9336<?> component) {
            if (!this.builder.isSet(component.comp_2443())) {
                this.builder.method_57855(component);
            }
            return this;
        }

        class_9326 build() {
            return this.builder.method_57852();
        }
    }
}

