/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_9279;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.bukkit.DyeColor;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftTropicalFish;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R1.inventory.SerializableMeta;
import org.bukkit.entity.TropicalFish;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaTropicalFishBucket
extends CraftMetaItem
implements TropicalFishBucketMeta {
    static final CraftMetaItem.ItemMetaKey VARIANT = new CraftMetaItem.ItemMetaKey("BucketVariantTag", "fish-variant");
    static final CraftMetaItem.ItemMetaKeyType<class_9279> ENTITY_TAG = new CraftMetaItem.ItemMetaKeyType(class_9334.field_49609, "entity-tag");
    static final CraftMetaItem.ItemMetaKeyType<class_9279> BUCKET_ENTITY_TAG = new CraftMetaItem.ItemMetaKeyType(class_9334.field_49610, "bucket-entity-tag");
    private Integer variant;
    private class_2487 entityTag;
    private class_2487 bucketEntityTag;

    public CraftMetaTropicalFishBucket(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaTropicalFishBucket)) {
            return;
        }
        CraftMetaTropicalFishBucket bucket = (CraftMetaTropicalFishBucket)meta;
        this.variant = bucket.variant;
        this.entityTag = bucket.entityTag;
        this.bucketEntityTag = bucket.bucketEntityTag;
    }

    CraftMetaTropicalFishBucket(class_9326 tag) {
        super(tag);
        CraftMetaTropicalFishBucket.getOrEmpty(tag, ENTITY_TAG).ifPresent(nbt -> {
            this.entityTag = nbt.method_57461();
            if (this.entityTag.method_10573(CraftMetaTropicalFishBucket.VARIANT.NBT, 3)) {
                this.variant = this.entityTag.method_10550(CraftMetaTropicalFishBucket.VARIANT.NBT);
            }
        });
        CraftMetaTropicalFishBucket.getOrEmpty(tag, BUCKET_ENTITY_TAG).ifPresent(nbt -> {
            this.bucketEntityTag = nbt.method_57461();
            if (this.bucketEntityTag.method_10573(CraftMetaTropicalFishBucket.VARIANT.NBT, 3)) {
                this.variant = this.bucketEntityTag.method_10550(CraftMetaTropicalFishBucket.VARIANT.NBT);
            }
        });
    }

    CraftMetaTropicalFishBucket(Map<String, Object> map) {
        super(map);
        Integer variant = SerializableMeta.getObject(Integer.class, map, CraftMetaTropicalFishBucket.VARIANT.BUKKIT, true);
        if (variant != null) {
            this.variant = variant;
        }
    }

    @Override
    void deserializeInternal(class_2487 tag, Object context) {
        super.deserializeInternal(tag, context);
        if (tag.method_10545(CraftMetaTropicalFishBucket.ENTITY_TAG.NBT)) {
            this.entityTag = tag.method_10562(CraftMetaTropicalFishBucket.ENTITY_TAG.NBT);
        }
        if (tag.method_10545(CraftMetaTropicalFishBucket.BUCKET_ENTITY_TAG.NBT)) {
            this.bucketEntityTag = tag.method_10562(CraftMetaTropicalFishBucket.BUCKET_ENTITY_TAG.NBT);
        }
    }

    @Override
    void serializeInternal(Map<String, class_2520> internalTags) {
        if (this.entityTag != null && !this.entityTag.method_33133()) {
            internalTags.put(CraftMetaTropicalFishBucket.ENTITY_TAG.NBT, (class_2520)this.entityTag);
        }
        if (this.bucketEntityTag != null && !this.bucketEntityTag.method_33133()) {
            internalTags.put(CraftMetaTropicalFishBucket.BUCKET_ENTITY_TAG.NBT, (class_2520)this.bucketEntityTag);
        }
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        class_2487 bucketEntityTag;
        super.applyToItem(tag);
        if (this.entityTag != null) {
            tag.put(ENTITY_TAG, class_9279.method_57456((class_2487)this.entityTag));
        }
        class_2487 class_24872 = bucketEntityTag = this.bucketEntityTag != null ? this.bucketEntityTag.method_10553() : null;
        if (this.hasVariant()) {
            if (bucketEntityTag == null) {
                bucketEntityTag = new class_2487();
            }
            bucketEntityTag.method_10569(CraftMetaTropicalFishBucket.VARIANT.NBT, this.variant.intValue());
        }
        if (bucketEntityTag != null) {
            tag.put(BUCKET_ENTITY_TAG, class_9279.method_57456((class_2487)bucketEntityTag));
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isBucketEmpty();
    }

    boolean isBucketEmpty() {
        return !this.hasVariant() && this.entityTag == null && this.bucketEntityTag == null;
    }

    @Override
    public DyeColor getPatternColor() {
        return CraftTropicalFish.getPatternColor(this.variant);
    }

    @Override
    public void setPatternColor(DyeColor color) {
        if (this.variant == null) {
            this.variant = 0;
        }
        this.variant = CraftTropicalFish.getData(color, this.getPatternColor(), this.getPattern());
    }

    @Override
    public DyeColor getBodyColor() {
        return CraftTropicalFish.getBodyColor(this.variant);
    }

    @Override
    public void setBodyColor(DyeColor color) {
        if (this.variant == null) {
            this.variant = 0;
        }
        this.variant = CraftTropicalFish.getData(this.getPatternColor(), color, this.getPattern());
    }

    @Override
    public TropicalFish.Pattern getPattern() {
        return CraftTropicalFish.getPattern(this.variant);
    }

    @Override
    public void setPattern(TropicalFish.Pattern pattern) {
        if (this.variant == null) {
            this.variant = 0;
        }
        this.variant = CraftTropicalFish.getData(this.getPatternColor(), this.getBodyColor(), pattern);
    }

    @Override
    public boolean hasVariant() {
        return this.variant != null;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaTropicalFishBucket) {
            CraftMetaTropicalFishBucket that = (CraftMetaTropicalFishBucket)meta;
            return (this.hasVariant() ? that.hasVariant() && this.variant.equals(that.variant) : !that.hasVariant()) && (this.entityTag != null ? that.entityTag != null && this.entityTag.equals((Object)that.entityTag) : that.entityTag == null) && (this.bucketEntityTag != null ? that.bucketEntityTag != null && this.bucketEntityTag.equals((Object)that.bucketEntityTag) : that.bucketEntityTag == null);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaTropicalFishBucket || this.isBucketEmpty());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasVariant()) {
            hash = 61 * hash + this.variant;
        }
        if (this.entityTag != null) {
            hash = 61 * hash + this.entityTag.hashCode();
        }
        if (this.bucketEntityTag != null) {
            hash = 61 * hash + this.bucketEntityTag.hashCode();
        }
        return original != hash ? CraftMetaTropicalFishBucket.class.hashCode() ^ hash : hash;
    }

    @Override
    public CraftMetaTropicalFishBucket clone() {
        CraftMetaTropicalFishBucket clone = (CraftMetaTropicalFishBucket)super.clone();
        if (this.entityTag != null) {
            clone.entityTag = this.entityTag.method_10553();
        }
        if (this.bucketEntityTag != null) {
            clone.bucketEntityTag = this.bucketEntityTag.method_10553();
        }
        return clone;
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasVariant()) {
            builder.put((Object)CraftMetaTropicalFishBucket.VARIANT.BUKKIT, (Object)this.variant);
        }
        return builder;
    }
}

