/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_7709;
import net.minecraft.class_7710;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.recipe.CookingBookCategory;
import org.bukkit.inventory.recipe.CraftingBookCategory;

public interface CraftRecipe
extends Recipe {
    public void addToCraftingManager();

    default public class_1856 toNMS(RecipeChoice bukkit, boolean requireNotEmpty) {
        class_1856 stack;
        if (bukkit == null) {
            stack = class_1856.field_9017;
        } else if (bukkit instanceof RecipeChoice.MaterialChoice) {
            stack = new class_1856(((RecipeChoice.MaterialChoice)bukkit).getChoices().stream().map(mat -> new class_1856.class_1857(CraftItemStack.asNMSCopy(new ItemStack((Material)mat)))));
        } else if (bukkit instanceof RecipeChoice.ExactChoice) {
            stack = new class_1856(((RecipeChoice.ExactChoice)bukkit).getChoices().stream().map(mat -> new class_1856.class_1857(CraftItemStack.asNMSCopy(mat))));
            stack.exact = true;
        } else {
            throw new IllegalArgumentException("Unknown recipe stack instance " + String.valueOf(bukkit));
        }
        stack.method_8105();
        if (requireNotEmpty) {
            Preconditions.checkArgument((stack.field_9018.length != 0 ? 1 : 0) != 0, (Object)"Recipe requires at least one non-air choice");
        }
        return stack;
    }

    public static RecipeChoice toBukkit(class_1856 list) {
        list.method_8105();
        if (list.field_9018.length == 0) {
            return null;
        }
        if (list.exact) {
            ArrayList<ItemStack> choices = new ArrayList<ItemStack>(list.field_9018.length);
            for (class_1799 i : list.field_9018) {
                choices.add(CraftItemStack.asBukkitCopy(i));
            }
            return new RecipeChoice.ExactChoice(choices);
        }
        ArrayList<Material> choices = new ArrayList<Material>(list.field_9018.length);
        for (class_1799 i : list.field_9018) {
            choices.add(CraftItemType.minecraftToBukkit(i.method_7909()));
        }
        return new RecipeChoice.MaterialChoice(choices);
    }

    public static class_7710 getCategory(CraftingBookCategory bukkit) {
        return class_7710.valueOf((String)bukkit.name());
    }

    public static CraftingBookCategory getCategory(class_7710 nms) {
        return CraftingBookCategory.valueOf(nms.name());
    }

    public static class_7709 getCategory(CookingBookCategory bukkit) {
        return class_7709.valueOf((String)bukkit.name());
    }

    public static CookingBookCategory getCategory(class_7709 nms) {
        return CookingBookCategory.valueOf(nms.name());
    }
}

