/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_8786;
import net.minecraft.class_8957;
import net.minecraft.server.MinecraftServer;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;

public class CraftShapedRecipe
extends ShapedRecipe
implements CraftRecipe {
    private class_1869 recipe;

    public CraftShapedRecipe(NamespacedKey key, ItemStack result) {
        super(key, result);
    }

    public CraftShapedRecipe(NamespacedKey key, ItemStack result, class_1869 recipe) {
        this(key, result);
        this.recipe = recipe;
    }

    public static CraftShapedRecipe fromBukkitRecipe(ShapedRecipe recipe) {
        if (recipe instanceof CraftShapedRecipe) {
            return (CraftShapedRecipe)recipe;
        }
        CraftShapedRecipe ret = new CraftShapedRecipe(recipe.getKey(), recipe.getResult());
        ret.setGroup(recipe.getGroup());
        ret.setCategory(recipe.getCategory());
        String[] shape = recipe.getShape();
        ret.shape(shape);
        Map<Character, RecipeChoice> ingredientMap = recipe.getChoiceMap();
        for (char c : ingredientMap.keySet()) {
            RecipeChoice stack = ingredientMap.get(Character.valueOf(c));
            if (stack == null) continue;
            ret.setIngredient(c, stack);
        }
        return ret;
    }

    @Override
    public void addToCraftingManager() {
        Map<Character, RecipeChoice> ingred = this.getChoiceMap();
        String[] shape = CraftShapedRecipe.replaceUndefinedIngredientsWithEmpty(this.getShape(), ingred);
        ingred.values().removeIf(Objects::isNull);
        Map data = Maps.transformValues(ingred, bukkit -> this.toNMS((RecipeChoice)bukkit, false));
        class_8957 pattern = class_8957.method_55086((Map)data, (String[])shape);
        MinecraftServer.getServer().method_3772().addRecipe(new class_8786(CraftNamespacedKey.toMinecraft(this.getKey()), (class_1860)new class_1869(this.getGroup(), CraftRecipe.getCategory(this.getCategory()), pattern, CraftItemStack.asNMSCopy(this.getResult()))));
    }

    private static String[] replaceUndefinedIngredientsWithEmpty(String[] shape, Map<Character, RecipeChoice> ingredients) {
        for (int i = 0; i < shape.length; ++i) {
            String row = shape[i];
            StringBuilder filteredRow = new StringBuilder(row.length());
            for (char character : row.toCharArray()) {
                filteredRow.append(ingredients.get(Character.valueOf(character)) == null ? (char)' ' : character);
            }
            shape[i] = filteredRow.toString();
        }
        return shape;
    }
}

