/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory.components;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9791;
import net.minecraft.class_9792;
import net.minecraft.class_9793;
import org.bukkit.JukeboxSong;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R1.CraftJukeboxSong;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.inventory.meta.components.JukeboxPlayableComponent;

@SerializableAs(value="JukeboxPlayable")
public final class CraftJukeboxComponent
implements JukeboxPlayableComponent {
    private class_9792 handle;

    public CraftJukeboxComponent(class_9792 jukebox) {
        this.handle = jukebox;
    }

    public CraftJukeboxComponent(CraftJukeboxComponent jukebox) {
        this.handle = jukebox.handle;
    }

    public CraftJukeboxComponent(Map<String, Object> map) {
        String song = SerializableMeta.getObject(String.class, map, "song", false);
        Boolean showTooltip = SerializableMeta.getObject(Boolean.TYPE, map, "show-in-tooltip", true);
        this.handle = new class_9792(new class_9791(class_5321.method_29179((class_5321)class_7924.field_52176, (class_2960)class_2960.method_60654((String)song))), showTooltip != null ? showTooltip : true);
    }

    @Override
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("song", this.getSongKey().toString());
        result.put("show-in-tooltip", this.isShowInTooltip());
        return result;
    }

    public class_9792 getHandle() {
        return this.handle;
    }

    @Override
    public JukeboxSong getSong() {
        Optional song = this.handle.comp_2833().method_60739((class_7225.class_7874)CraftRegistry.getMinecraftRegistry());
        return song.isPresent() ? CraftJukeboxSong.minecraftHolderToBukkit((class_6880<class_9793>)((class_6880)song.get())) : null;
    }

    @Override
    public NamespacedKey getSongKey() {
        return CraftNamespacedKey.fromMinecraft(this.handle.comp_2833().comp_2832().method_29177());
    }

    @Override
    public void setSong(JukeboxSong song) {
        Preconditions.checkArgument((song != null ? 1 : 0) != 0, (Object)"song cannot be null");
        this.handle = new class_9792(new class_9791(CraftJukeboxSong.bukkitToMinecraftHolder(song)), this.handle.comp_2834());
    }

    @Override
    public void setSongKey(NamespacedKey song) {
        Preconditions.checkArgument((song != null ? 1 : 0) != 0, (Object)"song cannot be null");
        this.handle = new class_9792(new class_9791(class_5321.method_29179((class_5321)class_7924.field_52176, (class_2960)CraftNamespacedKey.toMinecraft(song))), this.handle.comp_2834());
    }

    @Override
    public boolean isShowInTooltip() {
        return this.handle.comp_2834();
    }

    @Override
    public void setShowInTooltip(boolean show) {
        this.handle = new class_9792(this.handle.comp_2833(), show);
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.handle);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftJukeboxComponent other = (CraftJukeboxComponent)obj;
        return Objects.equals(this.handle, other.handle);
    }

    public String toString() {
        return "CraftJukeboxComponent{handle=" + String.valueOf(this.handle) + "}";
    }
}

