/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory.components;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9424;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R1.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R1.tag.CraftBlockTag;
import org.bukkit.inventory.meta.components.ToolComponent;

@SerializableAs(value="Tool")
public final class CraftToolComponent
implements ToolComponent {
    private class_9424 handle;

    public CraftToolComponent(class_9424 tool) {
        this.handle = tool;
    }

    public CraftToolComponent(CraftToolComponent tool) {
        this.handle = tool.handle;
    }

    public CraftToolComponent(Map<String, Object> map) {
        Float speed = SerializableMeta.getObject(Float.class, map, "default-mining-speed", false);
        Integer damage = SerializableMeta.getObject(Integer.class, map, "damage-per-block", false);
        ImmutableList.Builder rules = ImmutableList.builder();
        Iterable rawRuleList = SerializableMeta.getObject(Iterable.class, map, "rules", true);
        if (rawRuleList != null) {
            for (Object obj : rawRuleList) {
                Preconditions.checkArgument((boolean)(obj instanceof ToolComponent.ToolRule), (String)"Object (%s) in rule list is not valid", obj.getClass());
                CraftToolRule rule = new CraftToolRule((ToolComponent.ToolRule)obj);
                if (rule.handle.comp_2501().method_40247() <= 0) continue;
                rules.add((Object)rule);
            }
        }
        this.handle = new class_9424(rules.build().stream().map(CraftToolRule::new).map(CraftToolRule::getHandle).toList(), speed.floatValue(), damage.intValue());
    }

    @Override
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("default-mining-speed", Float.valueOf(this.getDefaultMiningSpeed()));
        result.put("damage-per-block", this.getDamagePerBlock());
        result.put("rules", this.getRules());
        return result;
    }

    public class_9424 getHandle() {
        return this.handle;
    }

    @Override
    public float getDefaultMiningSpeed() {
        return this.handle.comp_2499();
    }

    @Override
    public void setDefaultMiningSpeed(float speed) {
        this.handle = new class_9424(this.handle.comp_2498(), speed, this.handle.comp_2500());
    }

    @Override
    public int getDamagePerBlock() {
        return this.handle.comp_2500();
    }

    @Override
    public void setDamagePerBlock(int damage) {
        Preconditions.checkArgument((damage >= 0 ? 1 : 0) != 0, (String)"damage must be >= 0, was %d", (int)damage);
        this.handle = new class_9424(this.handle.comp_2498(), this.handle.comp_2499(), damage);
    }

    @Override
    public List<ToolComponent.ToolRule> getRules() {
        return this.handle.comp_2498().stream().map(CraftToolRule::new).collect(Collectors.toList());
    }

    @Override
    public void setRules(List<ToolComponent.ToolRule> rules) {
        Preconditions.checkArgument((rules != null ? 1 : 0) != 0, (Object)"rules must not be null");
        this.handle = new class_9424(rules.stream().map(CraftToolRule::new).map(CraftToolRule::getHandle).toList(), this.handle.comp_2499(), this.handle.comp_2500());
    }

    @Override
    public ToolComponent.ToolRule addRule(Material block, Float speed, Boolean correctForDrops) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"block must not be null");
        Preconditions.checkArgument((boolean)block.isBlock(), (String)"block must be a block type, given %s", (Object)block.getKey());
        class_6880.class_6883 nmsBlock = CraftBlockType.bukkitToMinecraft(block).method_40142();
        return this.addRule((class_6885<class_2248>)class_6885.method_40246((class_6880[])new class_6880[]{nmsBlock}), speed, correctForDrops);
    }

    @Override
    public ToolComponent.ToolRule addRule(Collection<Material> blocks, Float speed, Boolean correctForDrops) {
        ArrayList<class_6880.class_6883> nmsBlocks = new ArrayList<class_6880.class_6883>(blocks.size());
        for (Material material : blocks) {
            Preconditions.checkArgument((boolean)material.isBlock(), (String)"blocks contains non-block type: %s", (Object)material.getKey());
            nmsBlocks.add(CraftBlockType.bukkitToMinecraft(material).method_40142());
        }
        return this.addRule((class_6885<class_2248>)class_6885.method_40242(nmsBlocks), speed, correctForDrops);
    }

    @Override
    public ToolComponent.ToolRule addRule(Tag<Material> tag, Float speed, Boolean correctForDrops) {
        Preconditions.checkArgument((boolean)(tag instanceof CraftBlockTag), (Object)"tag must be a block tag");
        return this.addRule((class_6885<class_2248>)((CraftBlockTag)tag).getHandle(), speed, correctForDrops);
    }

    private ToolComponent.ToolRule addRule(class_6885<class_2248> blocks, Float speed, Boolean correctForDrops) {
        class_9424.class_9425 rule = new class_9424.class_9425(blocks, Optional.ofNullable(speed), Optional.ofNullable(correctForDrops));
        ArrayList<class_9424.class_9425> rules = new ArrayList<class_9424.class_9425>(this.handle.comp_2498().size() + 1);
        rules.addAll(this.handle.comp_2498());
        rules.add(rule);
        this.handle = new class_9424(rules, this.handle.comp_2499(), this.handle.comp_2500());
        return new CraftToolRule(rule);
    }

    @Override
    public boolean removeRule(ToolComponent.ToolRule rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"rule must not be null");
        ArrayList rules = new ArrayList(this.handle.comp_2498());
        boolean removed = rules.remove(((CraftToolRule)rule).handle);
        this.handle = new class_9424(rules, this.handle.comp_2499(), this.handle.comp_2500());
        return removed;
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.handle);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftToolComponent other = (CraftToolComponent)obj;
        return Objects.equals(this.handle, other.handle);
    }

    public String toString() {
        return "CraftToolComponent{handle=" + String.valueOf(this.handle) + "}";
    }

    @SerializableAs(value="ToolRule")
    public static class CraftToolRule
    implements ToolComponent.ToolRule {
        private class_9424.class_9425 handle;

        public CraftToolRule(class_9424.class_9425 handle) {
            this.handle = handle;
        }

        public CraftToolRule(ToolComponent.ToolRule bukkit) {
            class_9424.class_9425 toCopy = ((CraftToolRule)bukkit).handle;
            this.handle = new class_9424.class_9425(toCopy.comp_2501(), toCopy.comp_2502(), toCopy.comp_2503());
        }

        public CraftToolRule(Map<String, Object> map) {
            String blocksString;
            Float speed = SerializableMeta.getObject(Float.class, map, "speed", false);
            Boolean correct = SerializableMeta.getObject(Boolean.class, map, "correct-for-drops", false);
            class_6885 blocks = null;
            Object blocksObject = SerializableMeta.getObject(Object.class, map, "blocks", false);
            if (blocksObject instanceof String && (blocksString = (String)blocksObject).startsWith("#")) {
                class_2960 key = class_2960.method_12829((String)(blocksString = blocksString.substring(1)));
                if (key != null) {
                    blocks = class_7923.field_41175.method_40266(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)key)).orElse(null);
                }
            } else if (blocksObject instanceof List) {
                List blocksList = (List)blocksObject;
                ArrayList blockHolders = new ArrayList(blocksList.size());
                for (Object entry : blocksList) {
                    class_2960 key = class_2960.method_12829((String)entry.toString());
                    if (key == null) continue;
                    class_7923.field_41175.method_55841(key).ifPresent(blockHolders::add);
                }
                blocks = class_6885.method_40242(blockHolders);
            } else {
                throw new IllegalArgumentException("blocks(" + String.valueOf(blocksObject) + ") is not a valid String or List");
            }
            if (blocks == null) {
                blocks = class_6885.method_58563();
            }
            this.handle = new class_9424.class_9425(blocks, Optional.ofNullable(speed), Optional.ofNullable(correct));
        }

        @Override
        public Map<String, Object> serialize() {
            Boolean correct;
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            this.handle.comp_2501().method_40248().ifLeft(key -> result.put("blocks", "#" + key.comp_327().toString())).ifRight(blocks -> result.put("blocks", blocks.stream().map(block -> ((class_5321)block.method_40230().orElseThrow()).method_29177().toString()).toList()));
            Float speed = this.getSpeed();
            if (speed != null) {
                result.put("speed", speed);
            }
            if ((correct = this.isCorrectForDrops()) != null) {
                result.put("correct-for-drops", correct);
            }
            return result;
        }

        public class_9424.class_9425 getHandle() {
            return this.handle;
        }

        @Override
        public Collection<Material> getBlocks() {
            return this.handle.comp_2501().method_40239().map(class_6880::comp_349).map(CraftBlockType::minecraftToBukkit).collect(Collectors.toList());
        }

        @Override
        public void setBlocks(Material block) {
            Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"block must not be null");
            Preconditions.checkArgument((boolean)block.isBlock(), (String)"block must be a block type, given %s", (Object)block.getKey());
            this.handle = new class_9424.class_9425((class_6885)class_6885.method_40246((class_6880[])new class_6880[]{CraftBlockType.bukkitToMinecraft(block).method_40142()}), this.handle.comp_2502(), this.handle.comp_2503());
        }

        @Override
        public void setBlocks(Collection<Material> blocks) {
            Preconditions.checkArgument((blocks != null ? 1 : 0) != 0, (Object)"blocks must not be null");
            for (Material material : blocks) {
                Preconditions.checkArgument((boolean)material.isBlock(), (String)"blocks contains non-block type: %s", (Object)material.getKey());
            }
            this.handle = new class_9424.class_9425((class_6885)class_6885.method_40242(blocks.stream().map(CraftBlockType::bukkitToMinecraft).map(class_2248::method_40142).collect(Collectors.toList())), this.handle.comp_2502(), this.handle.comp_2503());
        }

        @Override
        public void setBlocks(Tag<Material> tag) {
            Preconditions.checkArgument((boolean)(tag instanceof CraftBlockTag), (Object)"tag must be a block tag");
            this.handle = new class_9424.class_9425(((CraftBlockTag)tag).getHandle(), this.handle.comp_2502(), this.handle.comp_2503());
        }

        @Override
        public Float getSpeed() {
            return this.handle.comp_2502().orElse(null);
        }

        @Override
        public void setSpeed(Float speed) {
            this.handle = new class_9424.class_9425(this.handle.comp_2501(), Optional.ofNullable(speed), this.handle.comp_2503());
        }

        @Override
        public Boolean isCorrectForDrops() {
            return this.handle.comp_2503().orElse(null);
        }

        @Override
        public void setCorrectForDrops(Boolean correct) {
            this.handle = new class_9424.class_9425(this.handle.comp_2501(), this.handle.comp_2502(), Optional.ofNullable(correct));
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + Objects.hashCode(this.handle);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CraftToolRule other = (CraftToolRule)obj;
            return Objects.equals(this.handle, other.handle);
        }

        public String toString() {
            return "CraftToolRule{handle=" + String.valueOf(this.handle) + "}";
        }
    }
}

