/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.packs;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.BlockType;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R1.packs.CraftDataPack;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemType;
import org.bukkit.packs.DataPack;
import org.bukkit.packs.DataPackManager;

public class CraftDataPackManager
implements DataPackManager {
    private final class_3283 handle;

    public CraftDataPackManager(class_3283 resourcePackRepository) {
        this.handle = resourcePackRepository;
    }

    public class_3283 getHandle() {
        return this.handle;
    }

    @Override
    public Collection<DataPack> getDataPacks() {
        this.getHandle().method_14445();
        Collection availablePacks = this.getHandle().method_14441();
        return availablePacks.stream().map(CraftDataPack::new).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public DataPack getDataPack(NamespacedKey namespacedKey) {
        Preconditions.checkArgument((namespacedKey != null ? 1 : 0) != 0, (Object)"namespacedKey cannot be null");
        return new CraftDataPack(this.getHandle().method_14449(namespacedKey.getKey()));
    }

    @Override
    public Collection<DataPack> getEnabledDataPacks(World world) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world cannot be null");
        CraftWorld craftWorld = (CraftWorld)world;
        return craftWorld.getHandle().K.method_29589().comp_1010().method_29547().stream().map(packName -> {
            class_3288 resourcePackLoader = this.getHandle().method_14449(packName);
            if (resourcePackLoader != null) {
                return new CraftDataPack(resourcePackLoader);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public Collection<DataPack> getDisabledDataPacks(World world) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world cannot be null");
        CraftWorld craftWorld = (CraftWorld)world;
        return craftWorld.getHandle().K.method_29589().comp_1010().method_29550().stream().map(packName -> {
            class_3288 resourcePackLoader = this.getHandle().method_14449(packName);
            if (resourcePackLoader != null) {
                return new CraftDataPack(resourcePackLoader);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public boolean isEnabledByFeature(Material material, World world) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"material cannot be null");
        Preconditions.checkArgument((material.isItem() || material.isBlock() ? 1 : 0) != 0, (Object)"material need to be a item or block");
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world cannot be null");
        CraftWorld craftWorld = (CraftWorld)world;
        if (material.isItem()) {
            return CraftItemType.bukkitToMinecraft(material).method_45382(craftWorld.getHandle().method_45162());
        }
        if (material.isBlock()) {
            return CraftBlockType.bukkitToMinecraft(material).method_45382(craftWorld.getHandle().method_45162());
        }
        return false;
    }

    @Override
    public boolean isEnabledByFeature(ItemType itemType, World world) {
        Preconditions.checkArgument((itemType != null ? 1 : 0) != 0, (Object)"itemType cannot be null");
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world cannot be null");
        CraftWorld craftWorld = (CraftWorld)world;
        return CraftItemType.bukkitToMinecraftNew(itemType.typed()).method_45382(craftWorld.getHandle().method_45162());
    }

    @Override
    public boolean isEnabledByFeature(BlockType blockType, World world) {
        Preconditions.checkArgument((blockType != null ? 1 : 0) != 0, (Object)"blockType cannot be null");
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world cannot be null");
        CraftWorld craftWorld = (CraftWorld)world;
        return CraftBlockType.bukkitToMinecraftNew(blockType.typed()).method_45382(craftWorld.getHandle().method_45162());
    }

    @Override
    public boolean isEnabledByFeature(EntityType entityType, World world) {
        Preconditions.checkArgument((entityType != null ? 1 : 0) != 0, (Object)"entityType cannot be null");
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world cannot be null");
        Preconditions.checkArgument((entityType != EntityType.UNKNOWN ? 1 : 0) != 0, (Object)"EntityType.UNKNOWN its not allowed here");
        CraftWorld craftWorld = (CraftWorld)world;
        class_1299<?> nmsEntity = CraftEntityType.bukkitToMinecraft(entityType);
        return nmsEntity.method_45382(craftWorld.getHandle().method_45162());
    }
}

