/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.potion;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_6880;
import org.bukkit.craftbukkit.v1_21_R1.potion.CraftPotionEffectType;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class CraftPotionUtil {
    private static final BiMap<PotionType, PotionType> upgradeable = ImmutableBiMap.builder().put((Object)PotionType.LEAPING, (Object)PotionType.STRONG_LEAPING).put((Object)PotionType.SWIFTNESS, (Object)PotionType.STRONG_SWIFTNESS).put((Object)PotionType.HEALING, (Object)PotionType.STRONG_HEALING).put((Object)PotionType.HARMING, (Object)PotionType.STRONG_HARMING).put((Object)PotionType.POISON, (Object)PotionType.STRONG_POISON).put((Object)PotionType.REGENERATION, (Object)PotionType.STRONG_REGENERATION).put((Object)PotionType.STRENGTH, (Object)PotionType.STRONG_STRENGTH).put((Object)PotionType.SLOWNESS, (Object)PotionType.STRONG_SLOWNESS).put((Object)PotionType.TURTLE_MASTER, (Object)PotionType.STRONG_TURTLE_MASTER).build();
    private static final BiMap<PotionType, PotionType> extendable = ImmutableBiMap.builder().put((Object)PotionType.NIGHT_VISION, (Object)PotionType.LONG_NIGHT_VISION).put((Object)PotionType.INVISIBILITY, (Object)PotionType.LONG_INVISIBILITY).put((Object)PotionType.LEAPING, (Object)PotionType.LONG_LEAPING).put((Object)PotionType.FIRE_RESISTANCE, (Object)PotionType.LONG_FIRE_RESISTANCE).put((Object)PotionType.SWIFTNESS, (Object)PotionType.LONG_SWIFTNESS).put((Object)PotionType.SLOWNESS, (Object)PotionType.LONG_SLOWNESS).put((Object)PotionType.WATER_BREATHING, (Object)PotionType.LONG_WATER_BREATHING).put((Object)PotionType.POISON, (Object)PotionType.LONG_POISON).put((Object)PotionType.REGENERATION, (Object)PotionType.LONG_REGENERATION).put((Object)PotionType.STRENGTH, (Object)PotionType.LONG_STRENGTH).put((Object)PotionType.WEAKNESS, (Object)PotionType.LONG_WEAKNESS).put((Object)PotionType.TURTLE_MASTER, (Object)PotionType.LONG_TURTLE_MASTER).put((Object)PotionType.SLOW_FALLING, (Object)PotionType.LONG_SLOW_FALLING).build();

    public static PotionType fromBukkit(PotionData data) {
        if (data == null) {
            return null;
        }
        PotionType type = data.isUpgraded() ? (PotionType)upgradeable.get((Object)data.getType()) : (data.isExtended() ? (PotionType)extendable.get((Object)data.getType()) : data.getType());
        Preconditions.checkNotNull((Object)type, (Object)("Unknown potion type from data " + String.valueOf(data)));
        return type;
    }

    public static PotionData toBukkit(PotionType type) {
        if (type == null) {
            return null;
        }
        PotionType potionType = (PotionType)extendable.inverse().get((Object)type);
        if (potionType != null) {
            return new PotionData(potionType, true, false);
        }
        potionType = (PotionType)upgradeable.inverse().get((Object)type);
        if (potionType != null) {
            return new PotionData(potionType, false, true);
        }
        return new PotionData(type, false, false);
    }

    public static class_1293 fromBukkit(PotionEffect effect) {
        class_6880<class_1291> type = CraftPotionEffectType.bukkitToMinecraftHolder(effect.getType());
        return new class_1293(type, effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles());
    }

    public static PotionEffect toBukkit(class_1293 effect) {
        PotionEffectType type = CraftPotionEffectType.minecraftHolderToBukkit((class_6880<class_1291>)effect.method_5579());
        int amp = effect.method_5578();
        int duration = effect.method_5584();
        boolean ambient = effect.method_5591();
        boolean particles = effect.method_5581();
        return new PotionEffect(type, duration, amp, ambient, particles);
    }

    public static boolean equals(class_6880<class_1291> mobEffect, PotionEffectType type) {
        PotionEffectType typeV = CraftPotionEffectType.minecraftHolderToBukkit(mobEffect);
        return typeV.equals(type);
    }
}

