/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering.fluid;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.impl.client.rendering.fluid.FluidRenderingImpl;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1163;
import net.minecraft.class_1723;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2373;
import net.minecraft.class_2397;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_775;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class FluidRenderHandlerRegistryImpl
implements FluidRenderHandlerRegistry {
    private final Map<class_3611, FluidRenderHandler> handlers = new IdentityHashMap<class_3611, FluidRenderHandler>();
    private final Map<class_3611, FluidRenderHandler> modHandlers = new IdentityHashMap<class_3611, FluidRenderHandler>();
    private final ConcurrentMap<class_2248, Boolean> overlayBlocks = new ConcurrentHashMap<class_2248, Boolean>();

    public FluidRenderHandlerRegistryImpl() {
        this.handlers.put((class_3611)class_3612.field_15910, WaterRenderHandler.INSTANCE);
        this.handlers.put((class_3611)class_3612.field_15909, WaterRenderHandler.INSTANCE);
        this.handlers.put((class_3611)class_3612.field_15908, LavaRenderHandler.INSTANCE);
        this.handlers.put((class_3611)class_3612.field_15907, LavaRenderHandler.INSTANCE);
    }

    @Override
    @Nullable
    public FluidRenderHandler get(class_3611 fluid) {
        return this.handlers.get(fluid);
    }

    @Override
    @Nullable
    public FluidRenderHandler getOverride(class_3611 fluid) {
        return this.modHandlers.get(fluid);
    }

    @Override
    public void register(class_3611 fluid, FluidRenderHandler renderer) {
        this.handlers.put(fluid, renderer);
        this.modHandlers.put(fluid, renderer);
    }

    @Override
    public void setBlockTransparency(class_2248 block, boolean transparent) {
        this.overlayBlocks.put(block, transparent);
    }

    @Override
    public boolean isBlockTransparent(class_2248 block) {
        return this.overlayBlocks.computeIfAbsent(block, k -> k instanceof class_2373 || k instanceof class_2397);
    }

    public void onFluidRendererReload(class_775 renderer, class_1058[] waterSprites, class_1058[] lavaSprites, class_1058 waterOverlay) {
        FluidRenderingImpl.setVanillaRenderer(renderer);
        WaterRenderHandler.INSTANCE.updateSprites(waterSprites, waterOverlay);
        LavaRenderHandler.INSTANCE.updateSprites(lavaSprites);
        class_1059 texture = class_310.method_1551().method_1554().method_24153(class_1723.field_21668);
        for (FluidRenderHandler handler : this.handlers.values()) {
            handler.reloadTextures(texture);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class WaterRenderHandler
    implements FluidRenderHandler {
        public static final WaterRenderHandler INSTANCE = new WaterRenderHandler();
        private static final int DEFAULT_WATER_COLOR = 4159204;
        private final class_1058[] sprites = new class_1058[3];

        private WaterRenderHandler() {
        }

        @Override
        public class_1058[] getFluidSprites(@Nullable class_1920 view, @Nullable class_2338 pos, class_3610 state) {
            return this.sprites;
        }

        @Override
        public int getFluidColor(@Nullable class_1920 view, @Nullable class_2338 pos, class_3610 state) {
            if (view != null && pos != null) {
                return class_1163.method_4961((class_1920)view, (class_2338)pos);
            }
            return 4159204;
        }

        public void updateSprites(class_1058[] waterSprites, class_1058 waterOverlay) {
            this.sprites[0] = waterSprites[0];
            this.sprites[1] = waterSprites[1];
            this.sprites[2] = waterOverlay;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class LavaRenderHandler
    implements FluidRenderHandler {
        public static final LavaRenderHandler INSTANCE = new LavaRenderHandler();
        private class_1058[] sprites;

        private LavaRenderHandler() {
        }

        @Override
        public class_1058[] getFluidSprites(@Nullable class_1920 view, @Nullable class_2338 pos, class_3610 state) {
            return this.sprites;
        }

        public void updateSprites(class_1058[] lavaSprites) {
            this.sprites = lavaSprites;
        }
    }
}

