/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.discovery;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.FormattedException;
import net.fabricmc.loader.impl.discovery.ModCandidate;
import net.fabricmc.loader.impl.discovery.ModCandidateFinder;
import net.fabricmc.loader.impl.discovery.ModResolutionException;
import net.fabricmc.loader.impl.game.GameProvider;
import net.fabricmc.loader.impl.metadata.BuiltinModMetadata;
import net.fabricmc.loader.impl.metadata.DependencyOverrides;
import net.fabricmc.loader.impl.metadata.LoaderModMetadata;
import net.fabricmc.loader.impl.metadata.MetadataVerifier;
import net.fabricmc.loader.impl.metadata.ModMetadataParser;
import net.fabricmc.loader.impl.metadata.NestedJarEntry;
import net.fabricmc.loader.impl.metadata.ParseMetadataException;
import net.fabricmc.loader.impl.metadata.VersionOverrides;
import net.fabricmc.loader.impl.util.ExceptionUtil;
import net.fabricmc.loader.impl.util.LoaderUtil;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;

public final class ModDiscoverer {
    private final VersionOverrides versionOverrides;
    private final DependencyOverrides depOverrides;
    private final List<ModCandidateFinder> candidateFinders = new ArrayList<ModCandidateFinder>();
    private final EnvType envType = FabricLoaderImpl.INSTANCE.getEnvironmentType();
    private final Map<Long, ModScanTask> jijDedupMap = new ConcurrentHashMap<Long, ModScanTask>();
    private final List<NestedModInitData> nestedModInitDatas = Collections.synchronizedList(new ArrayList());

    public ModDiscoverer(VersionOverrides versionOverrides, DependencyOverrides depOverrides) {
        this.versionOverrides = versionOverrides;
        this.depOverrides = depOverrides;
    }

    public void addCandidateFinder(ModCandidateFinder f) {
        this.candidateFinders.add(f);
    }

    /*
     * WARNING - void declaration
     */
    public List<ModCandidate> discoverMods(FabricLoaderImpl loader, Map<String, Set<ModCandidate>> envDisabledModsOut) throws ModResolutionException {
        ModCandidate modCandidate;
        void var10_14;
        long startTime = System.nanoTime();
        ForkJoinPool pool = new ForkJoinPool();
        HashSet processedPaths = new HashSet();
        ArrayList futures = new ArrayList();
        ModCandidateFinder.ModCandidateConsumer taskSubmitter = (paths, requiresRemap) -> {
            if (paths.size() == 1) {
                Path path = LoaderUtil.normalizeExistingPath((Path)paths.get(0));
                if (processedPaths.add(path)) {
                    futures.add(pool.submit(new ModScanTask(Collections.singletonList(path), requiresRemap)));
                }
            } else {
                ArrayList<Path> normalizedPaths = new ArrayList<Path>(paths.size());
                for (Path path : paths) {
                    normalizedPaths.add(LoaderUtil.normalizeExistingPath(path));
                }
                if (!processedPaths.containsAll(normalizedPaths)) {
                    processedPaths.addAll(normalizedPaths);
                    futures.add(pool.submit(new ModScanTask(normalizedPaths, requiresRemap)));
                }
            }
        };
        for (ModCandidateFinder modCandidateFinder : this.candidateFinders) {
            modCandidateFinder.findCandidates(taskSubmitter);
        }
        ArrayList<ModCandidate> candidates = new ArrayList<ModCandidate>();
        for (GameProvider.BuiltinMod mod2 : loader.getGameProvider().getBuiltinMods()) {
            if (!(mod2.metadata.getVersion() instanceof SemanticVersion)) {
                String error = String.format("%s uses the non-semantic version %s, which doesn't support range comparisons and may cause mod dependencies against it to fail unexpectedly. Consider updating Fabric Loader or explicitly specifying the game version with the fabric.gameVersion system property.", mod2.metadata.getId(), mod2.metadata.getVersion());
                if (loader.isDevelopmentEnvironment()) {
                    throw new FormattedException("Invalid game version", error);
                }
                Log.warn(LogCategory.GENERAL, error);
            }
            Iterator<NestedModInitData> candidate = ModCandidate.createBuiltin(mod2, this.versionOverrides, this.depOverrides);
            candidates.add(MetadataVerifier.verifyIndev((ModCandidate)((Object)candidate), loader.isDevelopmentEnvironment()));
        }
        candidates.add(MetadataVerifier.verifyIndev(this.createJavaMod(), loader.isDevelopmentEnvironment()));
        Object var10_11 = null;
        int timeout = Integer.getInteger("fabric.debug.discoveryTimeout", 60);
        if (timeout <= 0) {
            timeout = Integer.MAX_VALUE;
        }
        try {
            pool.shutdown();
            pool.awaitTermination(timeout, TimeUnit.SECONDS);
            for (Future future : futures) {
                if (!future.isDone()) {
                    throw new TimeoutException();
                }
                try {
                    ModCandidate candidate = (ModCandidate)future.get();
                    if (candidate == null) continue;
                    candidates.add(candidate);
                }
                catch (ExecutionException e) {
                    void var10_12;
                    ModResolutionException modResolutionException = ExceptionUtil.gatherExceptions(e, var10_12, exc -> new ModResolutionException("Mod discovery failed!", (Throwable)exc));
                }
            }
            for (NestedModInitData data : this.nestedModInitDatas) {
                for (Future<ModCandidate> future : data.futures) {
                    if (!future.isDone()) {
                        throw new TimeoutException();
                    }
                    try {
                        ModCandidate candidate = future.get();
                        if (candidate == null) continue;
                        data.target.add(candidate);
                    }
                    catch (ExecutionException e) {
                        ModResolutionException modResolutionException = ExceptionUtil.gatherExceptions(e, var10_14, exc -> new ModResolutionException("Mod discovery failed!", (Throwable)exc));
                    }
                }
            }
        }
        catch (TimeoutException e) {
            throw new FormattedException("Mod discovery took too long!", "Analyzing the mod folder contents took longer than %d seconds. This may be caused by unusually slow hardware, pathological antivirus interference or other issues. The timeout can be changed with the system property %s (-D%<s=<desired timeout in seconds>).", timeout, "fabric.debug.discoveryTimeout");
        }
        catch (InterruptedException e) {
            throw new FormattedException("Mod discovery interrupted!", e);
        }
        if (var10_14 != null) {
            throw var10_14;
        }
        Set<String> disabledModIds = ModDiscoverer.findDisabledModIds();
        Set ret = Collections.newSetFromMap(new IdentityHashMap(candidates.size() * 2));
        ArrayDeque<ModCandidate> queue = new ArrayDeque<ModCandidate>(candidates);
        while ((modCandidate = (ModCandidate)queue.poll()) != null) {
            if (modCandidate.getMetadata().loadsInEnvironment(this.envType)) {
                if (disabledModIds.contains(modCandidate.getId())) {
                    Log.info(LogCategory.DISCOVERY, "Skipping disabled mod %s", modCandidate.getId());
                    continue;
                }
                if (!ret.add(modCandidate)) continue;
                for (ModCandidate child : modCandidate.getNestedMods()) {
                    if (!child.addParent(modCandidate)) continue;
                    queue.add(child);
                }
                continue;
            }
            envDisabledModsOut.computeIfAbsent(modCandidate.getId(), ignore -> Collections.newSetFromMap(new IdentityHashMap())).add(modCandidate);
        }
        long endTime = System.nanoTime();
        Log.debug(LogCategory.DISCOVERY, "Mod discovery time: %.1f ms", (double)(endTime - startTime) * 1.0E-6);
        return new ArrayList<ModCandidate>(ret);
    }

    private static Set<String> findDisabledModIds() {
        String modIdList = System.getProperty("fabric.debug.disableModIds");
        if (modIdList == null) {
            return Collections.emptySet();
        }
        Set<String> disabledModIds = Arrays.stream(modIdList.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        Log.debug(LogCategory.DISCOVERY, "Disabled mod ids: %s", disabledModIds);
        return disabledModIds;
    }

    private ModCandidate createJavaMod() {
        ModMetadata metadata = new BuiltinModMetadata.Builder("java", System.getProperty("java.specification.version").replaceFirst("^1\\.", "")).setName(System.getProperty("java.vm.name")).build();
        GameProvider.BuiltinMod builtinMod = new GameProvider.BuiltinMod(Collections.singletonList(Paths.get(System.getProperty("java.home"), new String[0])), metadata);
        return ModCandidate.createBuiltin(builtinMod, this.versionOverrides, this.depOverrides);
    }

    private static boolean isValidNestedJarEntry(ZipEntry entry) {
        return entry != null && !entry.isDirectory() && entry.getName().endsWith(".jar");
    }

    static ByteBuffer readMod(InputStream is) throws IOException {
        int len;
        int available = is.available();
        boolean availableGood = available > 1;
        byte[] buffer = new byte[availableGood ? available : 30000];
        int offset = 0;
        while ((len = is.read(buffer, offset, buffer.length - offset)) >= 0) {
            if ((offset += len) != buffer.length) continue;
            if (availableGood) {
                int val = is.read();
                if (val < 0) break;
                availableGood = false;
                buffer = Arrays.copyOf(buffer, Math.max(buffer.length * 2, 30000));
                buffer[offset++] = (byte)val;
                continue;
            }
            buffer = Arrays.copyOf(buffer, buffer.length * 2);
        }
        return ByteBuffer.wrap(buffer, 0, offset);
    }

    private static class NestedModInitData {
        final List<? extends Future<ModCandidate>> futures;
        final List<ModCandidate> target;

        NestedModInitData(List<? extends Future<ModCandidate>> futures, List<ModCandidate> target) {
            this.futures = futures;
            this.target = target;
        }
    }

    final class ModScanTask
    extends RecursiveTask<ModCandidate> {
        private final List<Path> paths;
        private final String localPath;
        private final RewindableInputStream is;
        private final long hash;
        private final boolean requiresRemap;
        private final List<String> parentPaths;

        ModScanTask(List<Path> paths, boolean requiresRemap) {
            this(paths, null, null, -1L, requiresRemap, Collections.emptyList());
        }

        private ModScanTask(List<Path> paths, String localPath, RewindableInputStream is, long hash, boolean requiresRemap, List<String> parentPaths) {
            this.paths = paths;
            this.localPath = localPath != null ? localPath : paths.get(0).toString();
            this.is = is;
            this.hash = hash;
            this.requiresRemap = requiresRemap;
            this.parentPaths = parentPaths;
        }

        @Override
        protected ModCandidate compute() {
            if (this.is != null) {
                try {
                    return this.computeJarStream();
                }
                catch (ParseMetadataException e) {
                    throw ExceptionUtil.wrap(e);
                }
                catch (Throwable t) {
                    throw new RuntimeException(String.format("Error analyzing nested jar %s from %s: %s", this.localPath, this.parentPaths, t), t);
                }
            }
            try {
                for (Path path : this.paths) {
                    ModCandidate candidate = Files.isDirectory(path, new LinkOption[0]) ? this.computeDir(path) : this.computeJarFile(path);
                    if (candidate == null) continue;
                    return candidate;
                }
            }
            catch (ParseMetadataException e) {
                throw ExceptionUtil.wrap(e);
            }
            catch (Throwable t) {
                throw new RuntimeException(String.format("Error analyzing %s: %s", this.paths, t), t);
            }
            return null;
        }

        private ModCandidate computeDir(Path path) throws IOException, ParseMetadataException {
            LoaderModMetadata metadata;
            Path modJson = path.resolve("fabric.mod.json");
            if (!Files.exists(modJson, new LinkOption[0])) {
                return null;
            }
            try (InputStream is = Files.newInputStream(modJson, new OpenOption[0]);){
                metadata = this.parseMetadata(is, path.toString());
            }
            return ModCandidate.createPlain(this.paths, metadata, this.requiresRemap, Collections.emptyList());
        }

        private ModCandidate computeJarFile(Path path) throws IOException, ParseMetadataException {
            try (final ZipFile zf = new ZipFile(path.toFile());){
                List<ModCandidate> nestedMods;
                List<Object> nestedModTasks;
                LoaderModMetadata metadata;
                ZipEntry entry = zf.getEntry("fabric.mod.json");
                if (entry == null) {
                    ModCandidate modCandidate = null;
                    return modCandidate;
                }
                try (Object is = zf.getInputStream(entry);){
                    metadata = this.parseMetadata((InputStream)is, this.localPath);
                }
                if (!metadata.loadsInEnvironment(ModDiscoverer.this.envType)) {
                    is = ModCandidate.createPlain(this.paths, metadata, this.requiresRemap, Collections.emptyList());
                    return is;
                }
                if (metadata.getJars().isEmpty()) {
                    nestedModTasks = Collections.emptyList();
                } else {
                    final HashSet<NestedJarEntry> nestedJarPaths = new HashSet<NestedJarEntry>(metadata.getJars());
                    nestedModTasks = this.computeNestedMods(new ZipEntrySource(){
                        private final Iterator<NestedJarEntry> jarIt;
                        private ZipEntry currentEntry;
                        {
                            this.jarIt = nestedJarPaths.iterator();
                        }

                        @Override
                        public ZipEntry getNextEntry() throws IOException {
                            while (this.jarIt.hasNext()) {
                                NestedJarEntry jar = this.jarIt.next();
                                ZipEntry ret = zf.getEntry(jar.getFile());
                                if (!ModDiscoverer.isValidNestedJarEntry(ret)) continue;
                                this.currentEntry = ret;
                                this.jarIt.remove();
                                return ret;
                            }
                            this.currentEntry = null;
                            return null;
                        }

                        @Override
                        public RewindableInputStream getInputStream() throws IOException {
                            try (InputStream is = zf.getInputStream(this.currentEntry);){
                                RewindableInputStream rewindableInputStream = new RewindableInputStream(is);
                                return rewindableInputStream;
                            }
                        }
                    });
                    if (!nestedJarPaths.isEmpty() && FabricLoaderImpl.INSTANCE.isDevelopmentEnvironment()) {
                        Log.warn(LogCategory.METADATA, "Mod %s %s references missing nested jars: %s", metadata.getId(), metadata.getVersion(), nestedJarPaths);
                    }
                }
                if (nestedModTasks.isEmpty()) {
                    nestedMods = Collections.emptyList();
                } else {
                    nestedMods = new ArrayList();
                    ModDiscoverer.this.nestedModInitDatas.add(new NestedModInitData(nestedModTasks, nestedMods));
                }
                ModCandidate modCandidate = ModCandidate.createPlain(this.paths, metadata, this.requiresRemap, nestedMods);
                return modCandidate;
            }
        }

        private ModCandidate computeJarStream() throws IOException, ParseMetadataException {
            List<ModCandidate> nestedMods;
            List<Object> nestedModTasks;
            LoaderModMetadata metadata = null;
            try (ZipInputStream zis = new ZipInputStream(this.is);){
                ZipEntry entry;
                while ((entry = zis.getNextEntry()) != null) {
                    if (!entry.getName().equals("fabric.mod.json")) continue;
                    metadata = this.parseMetadata(zis, this.localPath);
                    break;
                }
            }
            if (metadata == null) {
                return null;
            }
            if (!metadata.loadsInEnvironment(ModDiscoverer.this.envType)) {
                return ModCandidate.createNested(this.localPath, this.hash, metadata, this.requiresRemap, Collections.emptyList());
            }
            Collection<NestedJarEntry> nestedJars = metadata.getJars();
            if (nestedJars.isEmpty()) {
                nestedModTasks = Collections.emptyList();
            } else {
                final HashSet<String> nestedJarPaths = new HashSet<String>(nestedJars.size());
                for (NestedJarEntry nestedJar : nestedJars) {
                    nestedJarPaths.add(nestedJar.getFile());
                }
                this.is.rewind();
                try (final ZipInputStream zis = new ZipInputStream(this.is);){
                    nestedModTasks = this.computeNestedMods(new ZipEntrySource(){
                        private RewindableInputStream is;

                        @Override
                        public ZipEntry getNextEntry() throws IOException {
                            ZipEntry ret;
                            if (nestedJarPaths.isEmpty()) {
                                return null;
                            }
                            while ((ret = zis.getNextEntry()) != null) {
                                if (!ModDiscoverer.isValidNestedJarEntry(ret) || !nestedJarPaths.remove(ret.getName())) continue;
                                this.is = new RewindableInputStream(zis);
                                return ret;
                            }
                            return null;
                        }

                        @Override
                        public RewindableInputStream getInputStream() throws IOException {
                            return this.is;
                        }
                    });
                }
                if (!nestedJarPaths.isEmpty() && FabricLoaderImpl.INSTANCE.isDevelopmentEnvironment()) {
                    Log.warn(LogCategory.METADATA, "Mod %s %s references missing nested jars: %s", metadata.getId(), metadata.getVersion(), nestedJarPaths);
                }
            }
            if (nestedModTasks.isEmpty()) {
                nestedMods = Collections.emptyList();
            } else {
                nestedMods = new ArrayList();
                ModDiscoverer.this.nestedModInitDatas.add(new NestedModInitData(nestedModTasks, nestedMods));
            }
            ModCandidate ret = ModCandidate.createNested(this.localPath, this.hash, metadata, this.requiresRemap, nestedMods);
            ret.setData(this.is.getBuffer());
            return ret;
        }

        private List<ModScanTask> computeNestedMods(ZipEntrySource entrySource) throws IOException {
            ZipEntry entry;
            ArrayList<String> parentPaths = new ArrayList<String>(this.parentPaths.size() + 1);
            parentPaths.addAll(this.parentPaths);
            parentPaths.add(this.localPath);
            ArrayList<ModScanTask> tasks = new ArrayList<ModScanTask>(5);
            ForkJoinTask localTask = null;
            while ((entry = entrySource.getNextEntry()) != null) {
                long hash = ModCandidate.hash(entry);
                ModScanTask task = (ModScanTask)ModDiscoverer.this.jijDedupMap.get(hash);
                if (task == null) {
                    task = new ModScanTask(null, entry.getName(), entrySource.getInputStream(), hash, this.requiresRemap, parentPaths);
                    ModScanTask prev = ModDiscoverer.this.jijDedupMap.putIfAbsent(hash, task);
                    if (prev != null) {
                        task = prev;
                    } else if (localTask == null) {
                        localTask = task;
                    } else {
                        task.fork();
                    }
                }
                tasks.add(task);
            }
            if (tasks.isEmpty()) {
                return Collections.emptyList();
            }
            if (localTask != null) {
                localTask.invoke();
            }
            return tasks;
        }

        private LoaderModMetadata parseMetadata(InputStream is, String localPath) throws ParseMetadataException {
            return ModMetadataParser.parseMetadata(is, localPath, this.parentPaths, ModDiscoverer.this.versionOverrides, ModDiscoverer.this.depOverrides, FabricLoaderImpl.INSTANCE.isDevelopmentEnvironment());
        }
    }

    private static final class RewindableInputStream
    extends InputStream {
        private final ByteBuffer buffer;
        private int pos;

        RewindableInputStream(InputStream parent) throws IOException {
            this.buffer = ModDiscoverer.readMod(parent);
            assert (this.buffer.hasArray() && this.buffer.arrayOffset() == 0 && this.buffer.position() == 0);
        }

        public ByteBuffer getBuffer() {
            return this.buffer;
        }

        public void rewind() {
            this.pos = 0;
        }

        @Override
        public int read() throws IOException {
            if (this.pos >= this.buffer.limit()) {
                return -1;
            }
            return this.buffer.get(this.pos++) & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int rem = this.buffer.limit() - this.pos;
            if (rem <= 0) {
                return -1;
            }
            len = Math.min(len, rem);
            System.arraycopy(this.buffer.array(), this.pos, b, off, len);
            this.pos += len;
            return len;
        }
    }

    private static interface ZipEntrySource {
        public ZipEntry getNextEntry() throws IOException;

        public RewindableInputStream getInputStream() throws IOException;
    }
}

