/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.boot.fabric.mod;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import net.fabricmc.loader.impl.game.minecraft.MinecraftGameProvider;
import net.fabricmc.loader.impl.launch.FabricLauncher;
import net.fabricmc.loader.impl.util.Arguments;

public class ArclightGameProvider
extends MinecraftGameProvider {
    private Path modFile;

    public void initialize(FabricLauncher launcher) {
        System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
        System.setProperty("log4j.jul.LoggerAdapter", "io.izzel.arclight.boot.log.ArclightLoggerAdapter");
        System.setProperty("log4j.configurationFile", "arclight-log4j2.xml");
        try {
            this.modFile = this.extract();
            launcher.addToClassPath(this.modFile, new String[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (String lib : System.getProperty("arclight.fabric.classpath").split(File.pathSeparator)) {
            launcher.addToClassPath(Paths.get(lib, new String[0]), new String[0]);
        }
        super.initialize(launcher);
    }

    public Arguments getArguments() {
        Arguments arguments = super.getArguments();
        String old = arguments.get("fabric.addMods");
        String builtinMods = System.getProperty("arclight.fabric.builtinMods");
        String path = this.modFile.toString() + File.pathSeparator + builtinMods;
        if (old != null) {
            path = old + File.pathSeparator + path;
        }
        arguments.put("fabric.addMods", path);
        return arguments;
    }

    private String getArclightVersion() throws Exception {
        try (InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/MANIFEST.MF");){
            Manifest manifest = new Manifest(stream);
            Attributes attributes = manifest.getMainAttributes();
            String string = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            return string;
        }
    }

    private Path extract() throws Exception {
        Path mod;
        String version = this.getArclightVersion();
        System.setProperty("arclight.version", version);
        InputStream path = ((Object)((Object)this)).getClass().getModule().getResourceAsStream("/common.jar");
        Path dir = Paths.get(".arclight", "mod_file");
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        if (!Files.exists(mod = dir.resolve(version + ".jar"), new LinkOption[0]) || Boolean.getBoolean("arclight.alwaysExtract")) {
            try (Stream<Path> files = Files.list(dir);){
                for (Path old : files.toList()) {
                    Files.delete(old);
                }
                Files.copy(path, mod, new CopyOption[0]);
            }
        }
        return mod;
    }

    public void unlockClassPath(FabricLauncher launcher) {
        super.unlockClassPath(launcher);
        try {
            Field field = launcher.getClass().getDeclaredField("unlocked");
            field.setAccessible(true);
            field.set(launcher, true);
            Constructor ctor = launcher.loadIntoTarget("io.izzel.arclight.fabric.boot.FabricBootstrap").getConstructor(new Class[0]);
            ((Consumer)ctor.newInstance(new Object[0])).accept(launcher);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public String getRawGameVersion() {
        try {
            return super.getRawGameVersion() + " Arclight " + this.getArclightVersion();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

