/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.installer;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.izzel.arclight.installer.InstallInfo;
import io.izzel.arclight.installer.MavenDownloader;
import io.izzel.arclight.installer.MinecraftProvider;
import io.izzel.arclight.installer.Mirrors;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

public class ForgeLikeProvider {
    static CompletableFuture<Path> downloadInstaller(String coord, String dist, String hash, CompletableFuture<MinecraftProvider.MinecraftData> minecraftData, InstallInfo info, ExecutorService pool, Consumer<String> logger) {
        MavenDownloader forge = new MavenDownloader(Mirrors.getMavenRepo(), coord, dist, hash);
        return MinecraftProvider.reportSupply(pool, logger).apply(forge).thenCombineAsync(minecraftData, (path, data) -> {
            try (JarFile jarFile = new JarFile(path.toFile());){
                HashMap<String, Map.Entry<String, String>> map = new HashMap<String, Map.Entry<String, String>>();
                ZipEntry profile = jarFile.getEntry("install_profile.json");
                map.putAll(ForgeLikeProvider.profileLibraries(new InputStreamReader(jarFile.getInputStream(profile)), info.installer.minecraft, data));
                ZipEntry version = jarFile.getEntry("version.json");
                map.putAll(ForgeLikeProvider.profileLibraries(new InputStreamReader(jarFile.getInputStream(version)), info.installer.minecraft, data));
                List<Supplier<Path>> suppliers = MinecraftProvider.checkMaven(map);
                CompletableFuture[] array = (CompletableFuture[])suppliers.stream().map(MinecraftProvider.reportSupply(pool, logger)).toArray(CompletableFuture[]::new);
                MinecraftProvider.handleFutures(logger, array);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return ForgeLikeProvider.stripDownloadMapping(path, logger);
        });
    }

    static Path stripDownloadMapping(Path installer, Consumer<String> logger) {
        try {
            logger.accept("Processing forge installer...");
            Path path = Paths.get(".arclight", "installer_stripped.jar");
            if (!Files.isDirectory(path.getParent(), new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            Files.deleteIfExists(path);
            try (JarFile from = new JarFile(installer.toFile());
                 JarOutputStream to = new JarOutputStream(Files.newOutputStream(path, StandardOpenOption.CREATE));){
                Enumeration<JarEntry> entries = from.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (name.endsWith(".SF") || name.endsWith(".DSA") || name.endsWith(".RSA")) continue;
                    if (name.equals("install_profile.json")) {
                        JsonElement element = new JsonParser().parse((Reader)new InputStreamReader(from.getInputStream(entry)));
                        JsonArray processors = element.getAsJsonObject().getAsJsonArray("processors");
                        block13: for (int i = 0; i < processors.size(); ++i) {
                            JsonObject processor = processors.get(i).getAsJsonObject();
                            JsonArray args = processor.getAsJsonArray("args");
                            for (JsonElement arg : args) {
                                if (!arg.getAsString().equals("DOWNLOAD_MOJMAPS")) continue;
                                processors.remove(i);
                                break block13;
                            }
                        }
                        to.putNextEntry(entry);
                        to.write(new Gson().toJson(element).getBytes(StandardCharsets.UTF_8));
                        continue;
                    }
                    to.putNextEntry(entry);
                    from.getInputStream(entry).transferTo(to);
                }
            }
            return path;
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    static Map<String, Map.Entry<String, String>> profileLibraries(Reader reader, String minecraft, MinecraftProvider.MinecraftData minecraftData) throws IOException {
        JsonObject data;
        HashMap<String, Map.Entry<String, String>> ret = new HashMap<String, Map.Entry<String, String>>();
        JsonObject object = new JsonParser().parse(reader).getAsJsonObject();
        JsonArray array = object.getAsJsonArray("libraries");
        for (JsonElement element : array) {
            String name = element.getAsJsonObject().get("name").getAsString();
            JsonObject artifact = element.getAsJsonObject().getAsJsonObject("downloads").getAsJsonObject("artifact");
            String hash = artifact.get("sha1").getAsString();
            String url = artifact.get("url").getAsString();
            if (url == null || url.trim().isEmpty()) continue;
            ret.put(name, new AbstractMap.SimpleImmutableEntry<String, String>(hash, url));
        }
        if (object.has("data") && (data = object.getAsJsonObject("data")).has("MOJMAPS")) {
            String serverMapping = data.getAsJsonObject("MOJMAPS").get("server").getAsString();
            ret.put(serverMapping.substring(1, serverMapping.length() - 1), new AbstractMap.SimpleImmutableEntry<String, String>(minecraftData.mappingHash(), minecraftData.mappingUrl()));
        }
        return ret;
    }
}

