/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.mixin.injector;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AnalyzerAdapter;

public class EnhancedAnalyzerAdapter
extends AnalyzerAdapter {
    private List<Object> lastLocal;
    private List<Object> lastStack;

    public EnhancedAnalyzerAdapter(String owner, int access, String name, String descriptor, MethodVisitor methodVisitor) {
        super(589824, owner, access, name, descriptor, methodVisitor);
        this.recordLocalsStack();
    }

    protected EnhancedAnalyzerAdapter(int api, String owner, int access, String name, String descriptor, MethodVisitor methodVisitor) {
        super(api, owner, access, name, descriptor, methodVisitor);
        this.recordLocalsStack();
    }

    public void visitFrame(int type, int numLocal, Object[] local, int numStack, Object[] stack) {
        switch (type) {
            case -1: {
                super.visitFrame(type, numLocal, local, numStack, stack);
                break;
            }
            case 0: {
                super.visitFrame(-1, numLocal, local, numStack, stack);
                break;
            }
            case 1: {
                for (int i = 0; i < numLocal; ++i) {
                    this.lastLocal.add(local[i]);
                }
                super.visitFrame(-1, this.lastLocal.size(), this.lastLocal.toArray(), 0, null);
                break;
            }
            case 2: {
                for (int i = 0; i < numLocal; ++i) {
                    this.lastLocal.remove(this.lastLocal.size() - 1);
                }
                super.visitFrame(-1, this.lastLocal.size(), this.lastLocal.toArray(), 0, null);
                break;
            }
            case 3: {
                super.visitFrame(-1, this.lastLocal.size(), this.lastLocal.toArray(), 0, null);
                break;
            }
            case 4: {
                super.visitFrame(-1, this.lastLocal.size(), this.lastLocal.toArray(), numStack, stack);
            }
        }
        this.recordLocalsStack();
    }

    private void recordLocalsStack() {
        this.lastLocal = new ArrayList<Object>();
        this.lastStack = new ArrayList<Object>();
        boolean doubleOrLong = false;
        for (Object local : this.locals) {
            if (doubleOrLong) {
                doubleOrLong = false;
                continue;
            }
            if (local == Opcodes.LONG || local == Opcodes.DOUBLE) {
                doubleOrLong = true;
            }
            this.lastLocal.add(local);
        }
        doubleOrLong = false;
        for (Object stack : this.stack) {
            if (doubleOrLong) {
                doubleOrLong = false;
                continue;
            }
            if (stack == Opcodes.LONG || stack == Opcodes.DOUBLE) {
                doubleOrLong = true;
            }
            this.lastStack.add(stack);
        }
    }

    public List<Object> getCurrent(List<Object> frame) {
        ArrayList<Object> lastStack = new ArrayList<Object>();
        boolean doubleOrLong = false;
        for (Object stack : frame) {
            if (doubleOrLong) {
                doubleOrLong = false;
                continue;
            }
            if (stack == Opcodes.LONG || stack == Opcodes.DOUBLE) {
                doubleOrLong = true;
            }
            lastStack.add(stack);
        }
        return lastStack;
    }

    public static boolean canFit(Object frameObject, Type type) {
        if (frameObject.equals(Opcodes.TOP)) {
            return false;
        }
        if (frameObject.equals(Opcodes.INTEGER)) {
            return type.equals((Object)Type.INT_TYPE) || type.equals((Object)Type.SHORT_TYPE) || type.equals((Object)Type.CHAR_TYPE) || type.equals((Object)Type.BYTE_TYPE) || type.equals((Object)Type.BOOLEAN_TYPE);
        }
        if (frameObject.equals(Opcodes.FLOAT)) {
            return type.equals((Object)Type.FLOAT_TYPE);
        }
        if (frameObject.equals(Opcodes.DOUBLE)) {
            return type.equals((Object)Type.DOUBLE_TYPE);
        }
        if (frameObject.equals(Opcodes.LONG)) {
            return type.equals((Object)Type.LONG_TYPE);
        }
        if (frameObject.equals(Opcodes.NULL)) {
            return type.getSort() == 9 || type.getSort() == 10;
        }
        if (frameObject.equals(Opcodes.UNINITIALIZED_THIS)) {
            return false;
        }
        if (frameObject instanceof String) {
            String internalName = (String)frameObject;
            return Type.getObjectType((String)internalName).getSort() == type.getSort();
        }
        if (frameObject instanceof Label) {
            return false;
        }
        throw new IllegalArgumentException("Unknown frame item " + frameObject);
    }

    public static Object getFrameItem(Type type) {
        if (type.getSort() >= 1 && type.getSort() <= 5) {
            return Opcodes.INTEGER;
        }
        if (type.equals((Object)Type.FLOAT_TYPE)) {
            return Opcodes.FLOAT;
        }
        if (type.equals((Object)Type.LONG_TYPE)) {
            return Opcodes.LONG;
        }
        if (type.equals((Object)Type.DOUBLE_TYPE)) {
            return Opcodes.DOUBLE;
        }
        if (type.getSort() >= 9 && type.getSort() <= 10) {
            return type.getInternalName();
        }
        throw new IllegalArgumentException("Unknown method argument type " + type);
    }

    public static int getOpcode(int opcode, Object frameObject) {
        if (frameObject.equals(Opcodes.TOP)) {
            throw new IllegalArgumentException("Unexpected TOP on stack");
        }
        if (frameObject.equals(Opcodes.INTEGER)) {
            return Type.INT_TYPE.getOpcode(opcode);
        }
        if (frameObject.equals(Opcodes.FLOAT)) {
            return Type.FLOAT_TYPE.getOpcode(opcode);
        }
        if (frameObject.equals(Opcodes.DOUBLE)) {
            return Type.DOUBLE_TYPE.getOpcode(opcode);
        }
        if (frameObject.equals(Opcodes.LONG)) {
            return Type.LONG_TYPE.getOpcode(opcode);
        }
        if (frameObject.equals(Opcodes.NULL)) {
            return Type.getType(Object.class).getOpcode(opcode);
        }
        if (frameObject.equals(Opcodes.UNINITIALIZED_THIS)) {
            return Type.getType(Object.class).getOpcode(opcode);
        }
        if (frameObject instanceof String) {
            return Type.getType(Object.class).getOpcode(opcode);
        }
        if (frameObject instanceof Label) {
            return Type.getType(Object.class).getOpcode(opcode);
        }
        throw new IllegalArgumentException("Unknown frame item " + frameObject);
    }
}

