/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ILaunchHandlerService;
import cpw.mods.modlauncher.api.ITransformingClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLCommonLaunchHandler;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.LibraryFinder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FMLClientLaunchProvider
extends FMLCommonLaunchHandler
implements ILaunchHandlerService {
    private static final Logger LOGGER = LogManager.getLogger();

    public String name() {
        return "fmlclient";
    }

    public Callable<Void> launchService(String[] arguments, ITransformingClassLoader launchClassLoader) {
        return () -> {
            super.beforeStart(launchClassLoader);
            launchClassLoader.addTargetPackageFilter(this.getPackagePredicate());
            Class.forName("net.minecraft.client.main.Main", true, launchClassLoader.getInstance()).getMethod("main", String[].class).invoke(null, new Object[]{arguments});
            return null;
        };
    }

    @Override
    public void setup(IEnvironment environment, Map<String, ?> arguments) {
        ArrayList<String> mavenRoots = new ArrayList<String>((List)arguments.get("mavenRoots"));
        ArrayList<String> mods = new ArrayList<String>((List)arguments.get("mods"));
        mavenRoots.add(LibraryFinder.findLibsPath().toString());
        String forgeVersion = (String)arguments.get("forgeVersion");
        String mcVersion = (String)arguments.get("mcVersion");
        String forgeGroup = (String)arguments.get("forgeGroup");
        mods.add(forgeGroup + ":forge:universal:" + mcVersion + "-" + forgeVersion);
        arguments.put("mavenRoots", mavenRoots);
        arguments.put("mods", mods);
    }

    @Override
    public Dist getDist() {
        return Dist.CLIENT;
    }

    @Override
    protected String getNaming() {
        return "srg";
    }

    public Path[] getPaths() {
        return FMLLoader.getMCPaths();
    }

    @Override
    public boolean isProduction() {
        return true;
    }
}

