/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SlabBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.StateHolder;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class StairsBlock
extends Block
implements IWaterLoggable {
    public static final DirectionProperty field_176309_a = HorizontalBlock.field_185512_D;
    public static final EnumProperty<Half> field_176308_b = BlockStateProperties.field_208164_Q;
    public static final EnumProperty<StairsShape> field_176310_M = BlockStateProperties.field_208146_au;
    public static final BooleanProperty field_204513_t = BlockStateProperties.field_208198_y;
    protected static final VoxelShape field_185712_d = SlabBlock.field_196507_c;
    protected static final VoxelShape field_185719_G = SlabBlock.field_196506_b;
    protected static final VoxelShape field_196512_A = Block.func_208617_a(0.0, 0.0, 0.0, 8.0, 8.0, 8.0);
    protected static final VoxelShape field_196513_B = Block.func_208617_a(0.0, 0.0, 8.0, 8.0, 8.0, 16.0);
    protected static final VoxelShape field_196514_C = Block.func_208617_a(0.0, 8.0, 0.0, 8.0, 16.0, 8.0);
    protected static final VoxelShape field_196515_D = Block.func_208617_a(0.0, 8.0, 8.0, 8.0, 16.0, 16.0);
    protected static final VoxelShape field_196516_E = Block.func_208617_a(8.0, 0.0, 0.0, 16.0, 8.0, 8.0);
    protected static final VoxelShape field_196517_F = Block.func_208617_a(8.0, 0.0, 8.0, 16.0, 8.0, 16.0);
    protected static final VoxelShape field_196518_G = Block.func_208617_a(8.0, 8.0, 0.0, 16.0, 16.0, 8.0);
    protected static final VoxelShape field_196519_H = Block.func_208617_a(8.0, 8.0, 8.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape[] field_196520_I = StairsBlock.func_199779_a(field_185712_d, field_196512_A, field_196516_E, field_196513_B, field_196517_F);
    protected static final VoxelShape[] field_196521_J = StairsBlock.func_199779_a(field_185719_G, field_196514_C, field_196518_G, field_196515_D, field_196519_H);
    private static final int[] field_196522_K = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};
    private final Block field_150149_b;
    private final BlockState field_150151_M;

    private static VoxelShape[] func_199779_a(VoxelShape voxelShape, VoxelShape voxelShape2, VoxelShape voxelShape3, VoxelShape voxelShape4, VoxelShape voxelShape5) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(n -> StairsBlock.func_199781_a(n, voxelShape, voxelShape2, voxelShape3, voxelShape4, voxelShape5)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape func_199781_a(int n, VoxelShape voxelShape, VoxelShape voxelShape2, VoxelShape voxelShape3, VoxelShape voxelShape4, VoxelShape voxelShape5) {
        \u2603 = voxelShape;
        if ((n & 1) != 0) {
            \u2603 = VoxelShapes.func_197872_a(\u2603, voxelShape2);
        }
        if ((n & 2) != 0) {
            \u2603 = VoxelShapes.func_197872_a(\u2603, voxelShape3);
        }
        if ((n & 4) != 0) {
            \u2603 = VoxelShapes.func_197872_a(\u2603, voxelShape4);
        }
        if ((n & 8) != 0) {
            \u2603 = VoxelShapes.func_197872_a(\u2603, voxelShape5);
        }
        return \u2603;
    }

    protected StairsBlock(BlockState blockState, AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176309_a, Direction.NORTH)).func_206870_a(field_176308_b, Half.BOTTOM)).func_206870_a(field_176310_M, StairsShape.STRAIGHT)).func_206870_a(field_204513_t, false));
        this.field_150149_b = blockState.func_177230_c();
        this.field_150151_M = blockState;
    }

    @Override
    public boolean func_220074_n(BlockState blockState) {
        return true;
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return (blockState.func_177229_b(field_176308_b) == Half.TOP ? field_196520_I : field_196521_J)[field_196522_K[this.func_196511_x(blockState)]];
    }

    private int func_196511_x(BlockState blockState) {
        return blockState.func_177229_b(field_176310_M).ordinal() * 4 + blockState.func_177229_b(field_176309_a).func_176736_b();
    }

    @Override
    public void func_196270_a(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity) {
        this.field_150151_M.func_196942_a(world, blockPos, playerEntity);
    }

    @Override
    public void func_176206_d(IWorld iWorld, BlockPos blockPos, BlockState blockState) {
        this.field_150149_b.func_176206_d(iWorld, blockPos, blockState);
    }

    @Override
    public float func_149638_a() {
        return this.field_150149_b.func_149638_a();
    }

    @Override
    public void func_220082_b(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (blockState.func_203425_a(blockState.func_177230_c())) {
            return;
        }
        this.field_150151_M.func_215697_a(world, blockPos, Blocks.field_150350_a, blockPos, false);
        this.field_150149_b.func_220082_b(this.field_150151_M, world, blockPos, blockState2, false);
    }

    @Override
    public void func_196243_a(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (blockState.func_203425_a(blockState2.func_177230_c())) {
            return;
        }
        this.field_150151_M.func_196947_b(world, blockPos, blockState2, bl);
    }

    @Override
    public void func_176199_a(World world, BlockPos blockPos, Entity entity) {
        this.field_150149_b.func_176199_a(world, blockPos, entity);
    }

    @Override
    public boolean func_149653_t(BlockState blockState) {
        return this.field_150149_b.func_149653_t(blockState);
    }

    @Override
    public void func_225542_b_(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, Random random) {
        this.field_150149_b.func_225542_b_(blockState, serverWorld, blockPos, random);
    }

    @Override
    public void func_225534_a_(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, Random random) {
        this.field_150149_b.func_225534_a_(blockState, serverWorld, blockPos, random);
    }

    @Override
    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        return this.field_150151_M.func_227031_a_(world, playerEntity, hand, blockRayTraceResult);
    }

    @Override
    public void func_180652_a(World world, BlockPos blockPos, Explosion explosion) {
        this.field_150149_b.func_180652_a(world, blockPos, explosion);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        Direction direction = blockItemUseContext.func_196000_l();
        BlockPos \u26032 = blockItemUseContext.func_195995_a();
        FluidState \u26033 = blockItemUseContext.func_195991_k().func_204610_c(\u26032);
        BlockState \u26034 = (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(field_176309_a, blockItemUseContext.func_195992_f())).func_206870_a(field_176308_b, direction == Direction.DOWN || direction != Direction.UP && blockItemUseContext.func_221532_j().field_72448_b - (double)\u26032.func_177956_o() > 0.5 ? Half.TOP : Half.BOTTOM)).func_206870_a(field_204513_t, \u26033.func_206886_c() == Fluids.field_204546_a);
        return (BlockState)\u26034.func_206870_a(field_176310_M, StairsBlock.func_208064_n(\u26034, blockItemUseContext.func_195991_k(), \u26032));
    }

    @Override
    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        if (blockState.func_177229_b(field_204513_t).booleanValue()) {
            iWorld.func_205219_F_().func_205360_a(blockPos, Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a(iWorld));
        }
        if (direction.func_176740_k().func_176722_c()) {
            return (BlockState)blockState.func_206870_a(field_176310_M, StairsBlock.func_208064_n(blockState, iWorld, blockPos));
        }
        return super.func_196271_a(blockState, direction, blockState2, iWorld, blockPos, blockPos2);
    }

    private static StairsShape func_208064_n(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        Direction direction = blockState.func_177229_b(field_176309_a);
        BlockState \u26032 = iBlockReader.func_180495_p(blockPos.func_177972_a(direction));
        if (StairsBlock.func_185709_i(\u26032) && blockState.func_177229_b(field_176308_b) == \u26032.func_177229_b(field_176308_b) && ((Direction)(\u26033 = \u26032.func_177229_b(field_176309_a))).func_176740_k() != blockState.func_177229_b(field_176309_a).func_176740_k() && StairsBlock.func_185704_d(blockState, iBlockReader, blockPos, ((Direction)\u26033).func_176734_d())) {
            if (\u26033 == direction.func_176735_f()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        Object \u26033 = iBlockReader.func_180495_p(blockPos.func_177972_a(direction.func_176734_d()));
        if (StairsBlock.func_185709_i((BlockState)\u26033) && blockState.func_177229_b(field_176308_b) == ((StateHolder)\u26033).func_177229_b(field_176308_b) && (\u2603 = ((StateHolder)\u26033).func_177229_b(field_176309_a)).func_176740_k() != blockState.func_177229_b(field_176309_a).func_176740_k() && StairsBlock.func_185704_d(blockState, iBlockReader, blockPos, \u2603)) {
            if (\u2603 == direction.func_176735_f()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean func_185704_d(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        BlockState blockState2 = iBlockReader.func_180495_p(blockPos.func_177972_a(direction));
        return !StairsBlock.func_185709_i(blockState2) || blockState2.func_177229_b(field_176309_a) != blockState.func_177229_b(field_176309_a) || blockState2.func_177229_b(field_176308_b) != blockState.func_177229_b(field_176308_b);
    }

    public static boolean func_185709_i(BlockState blockState) {
        return blockState.func_177230_c() instanceof StairsBlock;
    }

    @Override
    public BlockState func_185499_a(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.func_206870_a(field_176309_a, rotation.func_185831_a(blockState.func_177229_b(field_176309_a)));
    }

    @Override
    public BlockState func_185471_a(BlockState blockState, Mirror mirror) {
        Direction direction = blockState.func_177229_b(field_176309_a);
        StairsShape \u26032 = blockState.func_177229_b(field_176310_M);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (direction.func_176740_k() != Direction.Axis.Z) break;
                switch (\u26032) {
                    case INNER_LEFT: {
                        return (BlockState)blockState.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(field_176310_M, StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)blockState.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(field_176310_M, StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)blockState.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(field_176310_M, StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)blockState.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(field_176310_M, StairsShape.OUTER_LEFT);
                    }
                }
                return blockState.func_185907_a(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.func_176740_k() != Direction.Axis.X) break;
                switch (\u26032) {
                    case INNER_LEFT: {
                        return (BlockState)blockState.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(field_176310_M, StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)blockState.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(field_176310_M, StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)blockState.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(field_176310_M, StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)blockState.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(field_176310_M, StairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return blockState.func_185907_a(Rotation.CLOCKWISE_180);
                    }
                }
                break;
            }
        }
        return super.func_185471_a(blockState, mirror);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_176309_a, field_176308_b, field_176310_M, field_204513_t);
    }

    @Override
    public FluidState func_204507_t(BlockState blockState) {
        if (blockState.func_177229_b(field_204513_t).booleanValue()) {
            return Fluids.field_204546_a.func_207204_a(false);
        }
        return super.func_204507_t(blockState);
    }

    @Override
    public boolean func_196266_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        return false;
    }
}

