/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.data.loot.ChestLootTables;
import net.minecraft.data.loot.EntityLootTables;
import net.minecraft.data.loot.FishingLootTables;
import net.minecraft.data.loot.GiftLootTables;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.PiglinBarteringAddition;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTableProvider
implements IDataProvider {
    private static final Logger field_218441_b = LogManager.getLogger();
    private static final Gson field_218442_c = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator field_218443_d;
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> field_218444_e = ImmutableList.of((Object)Pair.of(FishingLootTables::new, (Object)LootParameterSets.field_216262_c), (Object)Pair.of(ChestLootTables::new, (Object)LootParameterSets.field_216261_b), (Object)Pair.of(EntityLootTables::new, (Object)LootParameterSets.field_216263_d), (Object)Pair.of(BlockLootTables::new, (Object)LootParameterSets.field_216267_h), (Object)Pair.of(PiglinBarteringAddition::new, (Object)LootParameterSets.field_237453_h_), (Object)Pair.of(GiftLootTables::new, (Object)LootParameterSets.field_216264_e));

    public LootTableProvider(DataGenerator dataGenerator) {
        this.field_218443_d = dataGenerator;
    }

    @Override
    public void func_200398_a(DirectoryCache directoryCache) {
        Path path = this.field_218443_d.func_200391_b();
        HashMap \u26032 = Maps.newHashMap();
        this.field_218444_e.forEach(pair -> ((Consumer)((Supplier)pair.getFirst()).get()).accept((resourceLocation, builder) -> {
            if (\u26032.put(resourceLocation, builder.func_216039_a((LootParameterSet)pair.getSecond()).func_216038_b()) != null) {
                throw new IllegalStateException("Duplicate loot table " + resourceLocation);
            }
        }));
        ValidationTracker \u26033 = new ValidationTracker(LootParameterSets.field_216266_g, resourceLocation -> null, \u26032::get);
        Sets.SetView \u26034 = Sets.difference(LootTables.func_215796_a(), \u26032.keySet());
        for (ResourceLocation resourceLocation2 : \u26034) {
            \u26033.func_227530_a_("Missing built-in table: " + resourceLocation2);
        }
        \u26032.forEach((resourceLocation, lootTable) -> LootTableManager.func_227508_a_(\u26033, resourceLocation, lootTable));
        Multimap<String, String> multimap = \u26033.func_227527_a_();
        if (!multimap.isEmpty()) {
            multimap.forEach((string, string2) -> field_218441_b.warn("Found validation problem in " + string + ": " + string2));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        \u26032.forEach((resourceLocation, lootTable) -> {
            Path path2 = LootTableProvider.func_218439_a(path, resourceLocation);
            try {
                IDataProvider.func_218426_a(field_218442_c, directoryCache, LootTableManager.func_215301_a(lootTable), path2);
            }
            catch (IOException \u26032) {
                field_218441_b.error("Couldn't save loot table {}", (Object)path2, (Object)\u26032);
            }
        });
    }

    private static Path func_218439_a(Path path, ResourceLocation resourceLocation) {
        return path.resolve("data/" + resourceLocation.func_110624_b() + "/loot_tables/" + resourceLocation.func_110623_a() + ".json");
    }

    @Override
    public String func_200397_b() {
        return "LootTables";
    }
}

