/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.brain.task;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.math.EntityPosWrapper;
import net.minecraft.world.server.ServerWorld;

public class ShootTargetTask<E extends MobEntity, T extends LivingEntity>
extends Task<E> {
    private int field_233885_b_;
    private Status field_233886_c_ = Status.UNCHARGED;

    public ShootTargetTask() {
        super((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of(MemoryModuleType.field_220951_l, (Object)((Object)MemoryModuleStatus.REGISTERED), MemoryModuleType.field_234103_o_, (Object)((Object)MemoryModuleStatus.VALUE_PRESENT)), 1200);
    }

    @Override
    protected boolean func_212832_a_(ServerWorld serverWorld, E e) {
        LivingEntity livingEntity = ShootTargetTask.func_233887_a_(e);
        return ((LivingEntity)e).func_233631_a_(Items.field_222114_py) && BrainUtil.func_233876_c_(e, livingEntity) && BrainUtil.func_233869_a_(e, livingEntity, 0);
    }

    @Override
    protected boolean func_212834_g_(ServerWorld serverWorld, E e, long l) {
        return ((LivingEntity)e).func_213375_cj().func_218191_a(MemoryModuleType.field_234103_o_) && this.func_212832_a_(serverWorld, e);
    }

    @Override
    protected void func_212833_d_(ServerWorld serverWorld, E e, long l) {
        LivingEntity livingEntity = ShootTargetTask.func_233887_a_(e);
        this.func_233889_b_((MobEntity)e, livingEntity);
        this.func_233888_a_(e, livingEntity);
    }

    @Override
    protected void func_212835_f_(ServerWorld serverWorld, E e, long l) {
        if (((LivingEntity)e).func_184587_cr()) {
            ((LivingEntity)e).func_184602_cy();
        }
        if (((LivingEntity)e).func_233631_a_(Items.field_222114_py)) {
            ((ICrossbowUser)e).func_213671_a(false);
            CrossbowItem.func_220011_a(((LivingEntity)e).func_184607_cu(), false);
        }
    }

    private void func_233888_a_(E e, LivingEntity livingEntity) {
        if (this.field_233886_c_ == Status.UNCHARGED) {
            ((LivingEntity)e).func_184598_c(ProjectileHelper.func_221274_a(e, Items.field_222114_py));
            this.field_233886_c_ = Status.CHARGING;
            ((ICrossbowUser)e).func_213671_a(true);
        } else if (this.field_233886_c_ == Status.CHARGING) {
            if (!((LivingEntity)e).func_184587_cr()) {
                this.field_233886_c_ = Status.UNCHARGED;
            }
            if ((\u2603 = ((LivingEntity)e).func_184612_cw()) >= CrossbowItem.func_220026_e(\u2603 = ((LivingEntity)e).func_184607_cu())) {
                ((LivingEntity)e).func_184597_cx();
                this.field_233886_c_ = Status.CHARGED;
                this.field_233885_b_ = 20 + ((LivingEntity)e).func_70681_au().nextInt(20);
                ((ICrossbowUser)e).func_213671_a(false);
            }
        } else if (this.field_233886_c_ == Status.CHARGED) {
            --this.field_233885_b_;
            if (this.field_233885_b_ == 0) {
                this.field_233886_c_ = Status.READY_TO_ATTACK;
            }
        } else if (this.field_233886_c_ == Status.READY_TO_ATTACK) {
            ((IRangedAttackMob)e).func_82196_d(livingEntity, 1.0f);
            ItemStack itemStack = ((LivingEntity)e).func_184586_b(ProjectileHelper.func_221274_a(e, Items.field_222114_py));
            CrossbowItem.func_220011_a(itemStack, false);
            this.field_233886_c_ = Status.UNCHARGED;
        }
    }

    private void func_233889_b_(MobEntity mobEntity, LivingEntity livingEntity) {
        mobEntity.func_213375_cj().func_218205_a(MemoryModuleType.field_220951_l, new EntityPosWrapper(livingEntity, true));
    }

    private static LivingEntity func_233887_a_(LivingEntity livingEntity) {
        return livingEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_).get();
    }

    @Override
    protected /* synthetic */ boolean func_212834_g_(ServerWorld serverWorld, LivingEntity livingEntity, long l) {
        return this.func_212834_g_(serverWorld, (E)((MobEntity)livingEntity), l);
    }

    @Override
    protected /* synthetic */ void func_212833_d_(ServerWorld serverWorld, LivingEntity livingEntity, long l) {
        this.func_212833_d_(serverWorld, (E)((MobEntity)livingEntity), l);
    }

    static enum Status {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

