/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.loot;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootSerializers;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.LootConditionManager;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootPredicateManager
extends JsonReloadListener {
    private static final Logger field_227510_a_ = LogManager.getLogger();
    private static final Gson field_227511_b_ = LootSerializers.func_237386_a_().create();
    private Map<ResourceLocation, ILootCondition> field_227512_c_ = ImmutableMap.of();

    public LootPredicateManager() {
        super(field_227511_b_, "predicates");
    }

    @Nullable
    public ILootCondition func_227517_a_(ResourceLocation resourceLocation) {
        return this.field_227512_c_.get(resourceLocation);
    }

    @Override
    protected void func_212853_a_(Map<ResourceLocation, JsonElement> map, IResourceManager iResourceManager, IProfiler iProfiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        map.forEach((resourceLocation, jsonElement2) -> {
            try {
                if (jsonElement2.isJsonArray()) {
                    ILootCondition[] iLootConditionArray = (ILootCondition[])field_227511_b_.fromJson(jsonElement2, ILootCondition[].class);
                    builder.put(resourceLocation, (Object)new AndCombiner(iLootConditionArray));
                } else {
                    JsonElement jsonElement2;
                    ILootCondition \u26032 = (ILootCondition)field_227511_b_.fromJson(jsonElement2, ILootCondition.class);
                    builder.put(resourceLocation, (Object)\u26032);
                }
            }
            catch (Exception exception) {
                field_227510_a_.error("Couldn't parse loot table {}", resourceLocation, (Object)exception);
            }
        });
        ImmutableMap \u26032 = builder.build();
        ValidationTracker \u26033 = new ValidationTracker(LootParameterSets.field_216266_g, ((Map)\u26032)::get, resourceLocation -> null);
        \u26032.forEach((resourceLocation, iLootCondition) -> iLootCondition.func_225580_a_(\u26033.func_227535_b_("{" + resourceLocation + "}", (ResourceLocation)resourceLocation)));
        \u26033.func_227527_a_().forEach((string, string2) -> field_227510_a_.warn("Found validation problem in " + string + ": " + string2));
        this.field_227512_c_ = \u26032;
    }

    public Set<ResourceLocation> func_227513_a_() {
        return Collections.unmodifiableSet(this.field_227512_c_.keySet());
    }

    static class AndCombiner
    implements ILootCondition {
        private final ILootCondition[] field_237405_a_;
        private final Predicate<LootContext> field_237406_b_;

        private AndCombiner(ILootCondition[] iLootConditionArray) {
            this.field_237405_a_ = iLootConditionArray;
            this.field_237406_b_ = LootConditionManager.func_216305_a(iLootConditionArray);
        }

        @Override
        public final boolean test(LootContext lootContext) {
            return this.field_237406_b_.test(lootContext);
        }

        @Override
        public void func_225580_a_(ValidationTracker validationTracker) {
            ILootCondition.super.func_225580_a_(validationTracker);
            for (int i = 0; i < this.field_237405_a_.length; ++i) {
                this.field_237405_a_[i].func_225580_a_(validationTracker.func_227534_b_(".term[" + i + "]"));
            }
        }

        @Override
        public LootConditionType func_230419_b_() {
            throw new UnsupportedOperationException();
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((LootContext)object);
        }
    }
}

