/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.loot.conditions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Set;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.LootConditionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class BlockStateProperty
implements ILootCondition {
    private final Block field_215990_a;
    private final StatePropertiesPredicate field_215991_b;

    private BlockStateProperty(Block block, StatePropertiesPredicate statePropertiesPredicate) {
        this.field_215990_a = block;
        this.field_215991_b = statePropertiesPredicate;
    }

    @Override
    public LootConditionType func_230419_b_() {
        return LootConditionManager.field_237465_h_;
    }

    @Override
    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of(LootParameters.field_216287_g);
    }

    @Override
    public boolean test(LootContext lootContext) {
        BlockState blockState = lootContext.func_216031_c(LootParameters.field_216287_g);
        return blockState != null && this.field_215990_a == blockState.func_177230_c() && this.field_215991_b.func_227181_a_(blockState);
    }

    public static Builder func_215985_a(Block block) {
        return new Builder(block);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootContext)object);
    }

    public static class Serializer
    implements ILootSerializer<BlockStateProperty> {
        @Override
        public void func_230424_a_(JsonObject jsonObject, BlockStateProperty blockStateProperty, JsonSerializationContext jsonSerializationContext) {
            jsonObject.addProperty("block", Registry.field_212618_g.func_177774_c(blockStateProperty.field_215990_a).toString());
            jsonObject.add("properties", blockStateProperty.field_215991_b.func_227180_a_());
        }

        @Override
        public BlockStateProperty func_230423_a_(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            ResourceLocation resourceLocation = new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "block"));
            Block \u26032 = Registry.field_212618_g.func_241873_b(resourceLocation).orElseThrow(() -> new IllegalArgumentException("Can't find block " + resourceLocation));
            StatePropertiesPredicate \u26033 = StatePropertiesPredicate.func_227186_a_(jsonObject.get("properties"));
            \u26033.func_227183_a_(\u26032.func_176194_O(), string -> {
                throw new JsonSyntaxException("Block " + \u26032 + " has no property " + string);
            });
            return new BlockStateProperty(\u26032, \u26033);
        }

        @Override
        public /* synthetic */ Object func_230423_a_(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.func_230423_a_(jsonObject, jsonDeserializationContext);
        }
    }

    public static class Builder
    implements ILootCondition.IBuilder {
        private final Block field_216300_a;
        private StatePropertiesPredicate field_216302_c = StatePropertiesPredicate.field_227178_a_;

        public Builder(Block block) {
            this.field_216300_a = block;
        }

        public Builder func_227567_a_(StatePropertiesPredicate.Builder builder) {
            this.field_216302_c = builder.func_227196_b_();
            return this;
        }

        @Override
        public ILootCondition build() {
            return new BlockStateProperty(this.field_216300_a, this.field_216302_c);
        }
    }
}

