/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import net.minecraft.command.CommandSource;
import net.minecraft.command.FunctionObject;
import net.minecraft.command.ICommandSource;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.TagCollectionReader;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FunctionReloader
implements IFutureReloadListener {
    private static final Logger field_240924_a_ = LogManager.getLogger();
    private static final int field_240925_b_ = "functions/".length();
    private static final int field_240926_c_ = ".mcfunction".length();
    private volatile Map<ResourceLocation, FunctionObject> field_240927_d_ = ImmutableMap.of();
    private final TagCollectionReader<FunctionObject> field_244357_e = new TagCollectionReader(this::func_240940_a_, "tags/functions", "function");
    private volatile ITagCollection<FunctionObject> field_240928_e_ = ITagCollection.func_242205_c();
    private final int field_240929_f_;
    private final CommandDispatcher<CommandSource> field_240930_g_;

    public Optional<FunctionObject> func_240940_a_(ResourceLocation resourceLocation) {
        return Optional.ofNullable(this.field_240927_d_.get(resourceLocation));
    }

    public Map<ResourceLocation, FunctionObject> func_240931_a_() {
        return this.field_240927_d_;
    }

    public ITagCollection<FunctionObject> func_240942_b_() {
        return this.field_240928_e_;
    }

    public ITag<FunctionObject> func_240943_b_(ResourceLocation resourceLocation) {
        return this.field_240928_e_.func_241834_b(resourceLocation);
    }

    public FunctionReloader(int n, CommandDispatcher<CommandSource> commandDispatcher) {
        this.field_240929_f_ = n;
        this.field_240930_g_ = commandDispatcher;
    }

    @Override
    public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage iStage, IResourceManager iResourceManager, IProfiler iProfiler, IProfiler iProfiler2, Executor executor, Executor executor2) {
        CompletableFuture<Map<ResourceLocation, ITag.Builder>> completableFuture = this.field_244357_e.func_242224_a(iResourceManager, executor);
        CompletionStage \u26032 = CompletableFuture.supplyAsync(() -> iResourceManager.func_199003_a("functions", string -> string.endsWith(".mcfunction")), executor).thenCompose(collection -> {
            HashMap hashMap = Maps.newHashMap();
            CommandSource \u26032 = new CommandSource(ICommandSource.field_213139_a_, Vector3d.field_186680_a, Vector2f.field_189974_a, null, this.field_240929_f_, "", StringTextComponent.field_240750_d_, null, null);
            for (ResourceLocation resourceLocation : collection) {
                String string = resourceLocation.func_110623_a();
                ResourceLocation \u26033 = new ResourceLocation(resourceLocation.func_110624_b(), string.substring(field_240925_b_, string.length() - field_240926_c_));
                hashMap.put(\u26033, CompletableFuture.supplyAsync(() -> {
                    List<String> list = FunctionReloader.func_240934_a_(iResourceManager, resourceLocation);
                    return FunctionObject.func_237140_a_(\u26033, this.field_240930_g_, \u26032, list);
                }, executor));
            }
            CompletableFuture[] completableFutureArray = hashMap.values().toArray(new CompletableFuture[0]);
            return CompletableFuture.allOf(completableFutureArray).handle((void_, throwable) -> hashMap);
        });
        return ((CompletableFuture)((CompletableFuture)completableFuture.thenCombine(\u26032, Pair::of)).thenCompose(iStage::func_216872_a)).thenAcceptAsync(pair -> {
            Map map = (Map)pair.getSecond();
            ImmutableMap.Builder \u26032 = ImmutableMap.builder();
            map.forEach((resourceLocation, completableFuture) -> ((CompletableFuture)completableFuture.handle((functionObject, throwable) -> {
                if (throwable != null) {
                    field_240924_a_.error("Failed to load function {}", resourceLocation, throwable);
                } else {
                    \u26032.put(resourceLocation, functionObject);
                }
                return null;
            })).join());
            this.field_240927_d_ = \u26032.build();
            this.field_240928_e_ = this.field_244357_e.func_242226_a((Map)pair.getFirst());
        }, executor2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> func_240934_a_(IResourceManager iResourceManager, ResourceLocation resourceLocation) {
        try (IResource iResource = iResourceManager.func_199002_a(resourceLocation);){
            List list = IOUtils.readLines((InputStream)iResource.func_199027_b(), (Charset)StandardCharsets.UTF_8);
            return list;
        }
        catch (IOException iOException) {
            throw new CompletionException(iOException);
        }
    }
}

