/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.network.play.server.SCustomPayloadPlayPacket;
import net.minecraft.network.play.server.SEntityStatusPacket;
import net.minecraft.network.play.server.SHeldItemChangePacket;
import net.minecraft.network.play.server.SJoinGamePacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SPlayerListItemPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.network.play.server.SSetExperiencePacket;
import net.minecraft.network.play.server.STagsListPacket;
import net.minecraft.network.play.server.STeamsPacket;
import net.minecraft.network.play.server.SUpdateRecipesPacket;
import net.minecraft.network.play.server.SUpdateTimePacket;
import net.minecraft.network.play.server.SUpdateViewDistancePacket;
import net.minecraft.network.play.server.SWorldBorderPacket;
import net.minecraft.network.play.server.SWorldSpawnChangedPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.BanList;
import net.minecraft.server.management.DemoPlayerInteractionManager;
import net.minecraft.server.management.IPBanEntry;
import net.minecraft.server.management.IPBanList;
import net.minecraft.server.management.OpEntry;
import net.minecraft.server.management.OpList;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.server.management.ProfileBanEntry;
import net.minecraft.server.management.WhiteList;
import net.minecraft.stats.ServerStatisticsManager;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.IWorldInfo;
import net.minecraft.world.storage.PlayerData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PlayerList {
    public static final File field_152613_a = new File("banned-players.json");
    public static final File field_152614_b = new File("banned-ips.json");
    public static final File field_152615_c = new File("ops.json");
    public static final File field_152616_d = new File("whitelist.json");
    private static final Logger field_148546_d = LogManager.getLogger();
    private static final SimpleDateFormat field_72403_e = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    private final MinecraftServer field_72400_f;
    private final List<ServerPlayerEntity> field_72404_b = Lists.newArrayList();
    private final Map<UUID, ServerPlayerEntity> field_177454_f = Maps.newHashMap();
    private final BanList field_72401_g = new BanList(field_152613_a);
    private final IPBanList field_72413_h = new IPBanList(field_152614_b);
    private final OpList field_72414_i = new OpList(field_152615_c);
    private final WhiteList field_72411_j = new WhiteList(field_152616_d);
    private final Map<UUID, ServerStatisticsManager> field_148547_k = Maps.newHashMap();
    private final Map<UUID, PlayerAdvancements> field_192055_p = Maps.newHashMap();
    private final PlayerData field_72412_k;
    private boolean field_72409_l;
    private final DynamicRegistries.Impl field_232639_s_;
    protected final int field_72405_c;
    private int field_72402_d;
    private GameType field_72410_m;
    private boolean field_72407_n;
    private int field_72408_o;

    public PlayerList(MinecraftServer minecraftServer, DynamicRegistries.Impl impl, PlayerData playerData, int n) {
        this.field_72400_f = minecraftServer;
        this.field_232639_s_ = impl;
        this.field_72405_c = n;
        this.field_72412_k = playerData;
    }

    public void func_72355_a(NetworkManager networkManager, ServerPlayerEntity serverPlayerEntity2) {
        Object object;
        ServerPlayerEntity serverPlayerEntity2;
        ServerWorld serverWorld;
        GameProfile gameProfile = serverPlayerEntity2.func_146103_bH();
        PlayerProfileCache \u26032 = this.field_72400_f.func_152358_ax();
        \u2603 = \u26032.func_152652_a(gameProfile.getId());
        String \u26033 = \u2603 == null ? gameProfile.getName() : \u2603.getName();
        \u26032.func_152649_a(gameProfile);
        CompoundNBT \u26034 = this.func_72380_a(serverPlayerEntity2);
        RegistryKey<World> \u26035 = \u26034 != null ? DimensionType.func_236025_a_(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)\u26034.func_74781_a("Dimension"))).resultOrPartial(arg_0 -> ((Logger)field_148546_d).error(arg_0)).orElse(World.field_234918_g_) : World.field_234918_g_;
        ServerWorld \u26036 = this.field_72400_f.func_71218_a(\u26035);
        if (\u26036 == null) {
            field_148546_d.warn("Unknown respawn dimension {}, defaulting to overworld", \u26035);
            serverWorld = this.field_72400_f.func_241755_D_();
        } else {
            serverWorld = \u26036;
        }
        serverPlayerEntity2.func_70029_a(serverWorld);
        serverPlayerEntity2.field_71134_c.func_73080_a((ServerWorld)serverPlayerEntity2.field_70170_p);
        String \u26037 = "local";
        if (networkManager.func_74430_c() != null) {
            \u26037 = networkManager.func_74430_c().toString();
        }
        field_148546_d.info("{}[{}] logged in with entity id {} at ({}, {}, {})", (Object)serverPlayerEntity2.func_200200_C_().getString(), (Object)\u26037, (Object)serverPlayerEntity2.func_145782_y(), (Object)serverPlayerEntity2.func_226277_ct_(), (Object)serverPlayerEntity2.func_226278_cu_(), (Object)serverPlayerEntity2.func_226281_cx_());
        IWorldInfo \u26038 = serverWorld.func_72912_H();
        this.func_72381_a(serverPlayerEntity2, null, serverWorld);
        ServerPlayNetHandler \u26039 = new ServerPlayNetHandler(this.field_72400_f, networkManager, serverPlayerEntity2);
        GameRules \u260310 = serverWorld.func_82736_K();
        boolean \u260311 = \u260310.func_223586_b(GameRules.field_226683_z_);
        boolean \u260312 = \u260310.func_223586_b(GameRules.field_223612_o);
        \u26039.func_147359_a(new SJoinGamePacket(serverPlayerEntity2.func_145782_y(), serverPlayerEntity2.field_71134_c.func_73081_b(), serverPlayerEntity2.field_71134_c.func_241815_c_(), BiomeManager.func_235200_a_(serverWorld.func_72905_C()), \u26038.func_76093_s(), this.field_72400_f.func_240770_D_(), this.field_232639_s_, serverWorld.func_230315_m_(), serverWorld.func_234923_W_(), this.func_72352_l(), this.field_72402_d, \u260312, !\u260311, serverWorld.func_234925_Z_(), serverWorld.func_241109_A_()));
        \u26039.func_147359_a(new SCustomPayloadPlayPacket(SCustomPayloadPlayPacket.field_209911_b, new PacketBuffer(Unpooled.buffer()).func_180714_a(this.func_72365_p().getServerModName())));
        \u26039.func_147359_a(new SServerDifficultyPacket(\u26038.func_176130_y(), \u26038.func_176123_z()));
        \u26039.func_147359_a(new SPlayerAbilitiesPacket(serverPlayerEntity2.field_71075_bZ));
        \u26039.func_147359_a(new SHeldItemChangePacket(serverPlayerEntity2.field_71071_by.field_70461_c));
        \u26039.func_147359_a(new SUpdateRecipesPacket(this.field_72400_f.func_199529_aN().func_199510_b()));
        \u26039.func_147359_a(new STagsListPacket(this.field_72400_f.func_244266_aF()));
        this.func_187243_f(serverPlayerEntity2);
        serverPlayerEntity2.func_147099_x().func_150877_d();
        serverPlayerEntity2.func_192037_E().func_192826_c(serverPlayerEntity2);
        this.func_96456_a(serverWorld.func_96441_U(), serverPlayerEntity2);
        this.field_72400_f.func_147132_au();
        TranslationTextComponent \u260313 = serverPlayerEntity2.func_146103_bH().getName().equalsIgnoreCase(\u26033) ? new TranslationTextComponent("multiplayer.player.joined", serverPlayerEntity2.func_145748_c_()) : new TranslationTextComponent("multiplayer.player.joined.renamed", serverPlayerEntity2.func_145748_c_(), \u26033);
        this.func_232641_a_(\u260313.func_240699_a_(TextFormatting.YELLOW), ChatType.SYSTEM, Util.field_240973_b_);
        \u26039.func_147364_a(serverPlayerEntity2.func_226277_ct_(), serverPlayerEntity2.func_226278_cu_(), serverPlayerEntity2.func_226281_cx_(), serverPlayerEntity2.field_70177_z, serverPlayerEntity2.field_70125_A);
        this.field_72404_b.add(serverPlayerEntity2);
        this.field_177454_f.put(serverPlayerEntity2.func_110124_au(), serverPlayerEntity2);
        this.func_148540_a(new SPlayerListItemPacket(SPlayerListItemPacket.Action.ADD_PLAYER, serverPlayerEntity2));
        for (int \u260314 = 0; \u260314 < this.field_72404_b.size(); ++\u260314) {
            serverPlayerEntity2.field_71135_a.func_147359_a(new SPlayerListItemPacket(SPlayerListItemPacket.Action.ADD_PLAYER, this.field_72404_b.get(\u260314)));
        }
        serverWorld.func_217435_c(serverPlayerEntity2);
        this.field_72400_f.func_201300_aS().func_201383_a(serverPlayerEntity2);
        this.func_72354_b(serverPlayerEntity2, serverWorld);
        if (!this.field_72400_f.func_147133_T().isEmpty()) {
            serverPlayerEntity2.func_175397_a(this.field_72400_f.func_147133_T(), this.field_72400_f.func_175581_ab());
        }
        Object \u260314 = serverPlayerEntity2.func_70651_bq().iterator();
        while (\u260314.hasNext()) {
            object = \u260314.next();
            \u26039.func_147359_a(new SPlayEntityEffectPacket(serverPlayerEntity2.func_145782_y(), (EffectInstance)object));
        }
        if (\u26034 != null && \u26034.func_150297_b("RootVehicle", 10) && (object = EntityType.func_220335_a(((CompoundNBT)(\u260314 = \u26034.func_74775_l("RootVehicle"))).func_74775_l("Entity"), serverWorld, entity -> {
            if (!serverWorld.func_217470_d((Entity)entity)) {
                return null;
            }
            return entity;
        })) != null) {
            UUID uUID = ((CompoundNBT)\u260314).func_186855_b("Attach") ? ((CompoundNBT)\u260314).func_186857_a("Attach") : null;
            if (((Entity)object).func_110124_au().equals(uUID)) {
                serverPlayerEntity2.func_184205_a((Entity)object, true);
            } else {
                for (Entity entity2 : ((Entity)object).func_184182_bu()) {
                    if (!entity2.func_110124_au().equals(uUID)) continue;
                    serverPlayerEntity2.func_184205_a(entity2, true);
                    break;
                }
            }
            if (!serverPlayerEntity2.func_184218_aH()) {
                field_148546_d.warn("Couldn't reattach entity to player");
                serverWorld.func_217467_h((Entity)object);
                for (Entity entity2 : ((Entity)object).func_184182_bu()) {
                    serverWorld.func_217467_h(entity2);
                }
            }
        }
        serverPlayerEntity2.func_71116_b();
    }

    protected void func_96456_a(ServerScoreboard serverScoreboard, ServerPlayerEntity serverPlayerEntity) {
        HashSet hashSet = Sets.newHashSet();
        for (ScorePlayerTeam scorePlayerTeam : serverScoreboard.func_96525_g()) {
            serverPlayerEntity.field_71135_a.func_147359_a(new STeamsPacket(scorePlayerTeam, 0));
        }
        for (int i = 0; i < 19; ++i) {
            ScoreObjective scoreObjective = serverScoreboard.func_96539_a(i);
            if (scoreObjective == null || hashSet.contains(scoreObjective)) continue;
            List<IPacket<?>> \u26032 = serverScoreboard.func_96550_d(scoreObjective);
            for (IPacket<?> iPacket : \u26032) {
                serverPlayerEntity.field_71135_a.func_147359_a(iPacket);
            }
            hashSet.add(scoreObjective);
        }
    }

    public void func_212504_a(ServerWorld serverWorld) {
        serverWorld.func_175723_af().func_177737_a(new IBorderListener(){

            @Override
            public void func_177694_a(WorldBorder worldBorder, double d) {
                PlayerList.this.func_148540_a(new SWorldBorderPacket(worldBorder, SWorldBorderPacket.Action.SET_SIZE));
            }

            @Override
            public void func_177692_a(WorldBorder worldBorder, double d, double d2, long l) {
                PlayerList.this.func_148540_a(new SWorldBorderPacket(worldBorder, SWorldBorderPacket.Action.LERP_SIZE));
            }

            @Override
            public void func_177693_a(WorldBorder worldBorder, double d, double d2) {
                PlayerList.this.func_148540_a(new SWorldBorderPacket(worldBorder, SWorldBorderPacket.Action.SET_CENTER));
            }

            @Override
            public void func_177691_a(WorldBorder worldBorder, int n) {
                PlayerList.this.func_148540_a(new SWorldBorderPacket(worldBorder, SWorldBorderPacket.Action.SET_WARNING_TIME));
            }

            @Override
            public void func_177690_b(WorldBorder worldBorder, int n) {
                PlayerList.this.func_148540_a(new SWorldBorderPacket(worldBorder, SWorldBorderPacket.Action.SET_WARNING_BLOCKS));
            }

            @Override
            public void func_177696_b(WorldBorder worldBorder, double d) {
            }

            @Override
            public void func_177695_c(WorldBorder worldBorder, double d) {
            }
        });
    }

    @Nullable
    public CompoundNBT func_72380_a(ServerPlayerEntity serverPlayerEntity) {
        CompoundNBT compoundNBT = this.field_72400_f.func_240793_aU_().func_230416_x_();
        if (serverPlayerEntity.func_200200_C_().getString().equals(this.field_72400_f.func_71214_G()) && compoundNBT != null) {
            \u2603 = compoundNBT;
            serverPlayerEntity.func_70020_e(\u2603);
            field_148546_d.debug("loading single player");
        } else {
            \u2603 = this.field_72412_k.func_237336_b_(serverPlayerEntity);
        }
        return \u2603;
    }

    protected void func_72391_b(ServerPlayerEntity serverPlayerEntity) {
        this.field_72412_k.func_237335_a_(serverPlayerEntity);
        ServerStatisticsManager serverStatisticsManager = this.field_148547_k.get(serverPlayerEntity.func_110124_au());
        if (serverStatisticsManager != null) {
            serverStatisticsManager.func_150883_b();
        }
        if ((\u2603 = this.field_192055_p.get(serverPlayerEntity.func_110124_au())) != null) {
            \u2603.func_192749_b();
        }
    }

    public void func_72367_e(ServerPlayerEntity serverPlayerEntity2) {
        ServerPlayerEntity serverPlayerEntity2;
        ServerWorld serverWorld = serverPlayerEntity2.func_71121_q();
        serverPlayerEntity2.func_195066_a(Stats.field_75947_j);
        this.func_72391_b(serverPlayerEntity2);
        if (serverPlayerEntity2.func_184218_aH() && ((Entity)(\u26032 = serverPlayerEntity2.func_184208_bv())).func_200601_bK()) {
            field_148546_d.debug("Removing player mount");
            serverPlayerEntity2.func_184210_p();
            serverWorld.func_217467_h((Entity)\u26032);
            ((Entity)\u26032).field_70128_L = true;
            for (Entity entity : ((Entity)\u26032).func_184182_bu()) {
                serverWorld.func_217467_h(entity);
                entity.field_70128_L = true;
            }
            serverWorld.func_212866_a_(serverPlayerEntity2.field_70176_ah, serverPlayerEntity2.field_70164_aj).func_76630_e();
        }
        serverPlayerEntity2.func_213319_R();
        serverWorld.func_217434_e(serverPlayerEntity2);
        serverPlayerEntity2.func_192039_O().func_192745_a();
        this.field_72404_b.remove(serverPlayerEntity2);
        this.field_72400_f.func_201300_aS().func_201382_b(serverPlayerEntity2);
        Object \u26032 = serverPlayerEntity2.func_110124_au();
        \u2603 = this.field_177454_f.get(\u26032);
        if (\u2603 == serverPlayerEntity2) {
            this.field_177454_f.remove(\u26032);
            this.field_148547_k.remove(\u26032);
            this.field_192055_p.remove(\u26032);
        }
        this.func_148540_a(new SPlayerListItemPacket(SPlayerListItemPacket.Action.REMOVE_PLAYER, serverPlayerEntity2));
    }

    @Nullable
    public ITextComponent func_206258_a(SocketAddress socketAddress, GameProfile gameProfile) {
        if (this.field_72401_g.func_152702_a(gameProfile)) {
            ProfileBanEntry profileBanEntry = (ProfileBanEntry)this.field_72401_g.func_152683_b(gameProfile);
            TranslationTextComponent \u26032 = new TranslationTextComponent("multiplayer.disconnect.banned.reason", profileBanEntry.func_73686_f());
            if (profileBanEntry.func_73680_d() != null) {
                \u26032.func_230529_a_(new TranslationTextComponent("multiplayer.disconnect.banned.expiration", field_72403_e.format(profileBanEntry.func_73680_d())));
            }
            return \u26032;
        }
        if (!this.func_152607_e(gameProfile)) {
            return new TranslationTextComponent("multiplayer.disconnect.not_whitelisted");
        }
        if (this.field_72413_h.func_152708_a(socketAddress)) {
            IPBanEntry \u26033 = this.field_72413_h.func_152709_b(socketAddress);
            TranslationTextComponent \u26034 = new TranslationTextComponent("multiplayer.disconnect.banned_ip.reason", \u26033.func_73686_f());
            if (\u26033.func_73680_d() != null) {
                \u26034.func_230529_a_(new TranslationTextComponent("multiplayer.disconnect.banned_ip.expiration", field_72403_e.format(\u26033.func_73680_d())));
            }
            return \u26034;
        }
        if (this.field_72404_b.size() >= this.field_72405_c && !this.func_183023_f(gameProfile)) {
            return new TranslationTextComponent("multiplayer.disconnect.server_full");
        }
        return null;
    }

    public ServerPlayerEntity func_148545_a(GameProfile gameProfile2) {
        Object object3;
        GameProfile gameProfile2;
        UUID uUID = PlayerEntity.func_146094_a(gameProfile2);
        ArrayList \u26032 = Lists.newArrayList();
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            Object object2 = this.field_72404_b.get(i);
            if (!((Entity)object2).func_110124_au().equals(uUID)) continue;
            \u26032.add(object2);
        }
        ServerPlayerEntity \u26033 = this.field_177454_f.get(gameProfile2.getId());
        if (\u26033 != null && !\u26032.contains(\u26033)) {
            \u26032.add(\u26033);
        }
        for (Object object3 : \u26032) {
            ((ServerPlayerEntity)object3).field_71135_a.func_194028_b(new TranslationTextComponent("multiplayer.disconnect.duplicate_login"));
        }
        object3 = this.field_72400_f.func_241755_D_();
        object2 = this.field_72400_f.func_71242_L() ? new DemoPlayerInteractionManager((ServerWorld)object3) : new PlayerInteractionManager((ServerWorld)object3);
        return new ServerPlayerEntity(this.field_72400_f, (ServerWorld)object3, gameProfile2, (PlayerInteractionManager)object2);
    }

    public ServerPlayerEntity func_232644_a_(ServerPlayerEntity serverPlayerEntity2, boolean bl) {
        PlayerInteractionManager playerInteractionManager;
        ServerWorld \u26036;
        Optional \u26035;
        this.field_72404_b.remove(serverPlayerEntity2);
        serverPlayerEntity2.func_71121_q().func_217434_e(serverPlayerEntity2);
        BlockPos blockPos = serverPlayerEntity2.func_241140_K_();
        float \u26032 = serverPlayerEntity2.func_242109_L();
        boolean \u26033 = serverPlayerEntity2.func_241142_M_();
        ServerWorld \u26034 = this.field_72400_f.func_71218_a(serverPlayerEntity2.func_241141_L_());
        if (\u26034 != null && blockPos != null) {
            Optional<Vector3d> optional = PlayerEntity.func_242374_a(\u26034, blockPos, \u26032, \u26033, bl);
        } else {
            \u26035 = Optional.empty();
        }
        ServerWorld serverWorld = \u26036 = \u26034 != null && \u26035.isPresent() ? \u26034 : this.field_72400_f.func_241755_D_();
        if (this.field_72400_f.func_71242_L()) {
            DemoPlayerInteractionManager \u26037 = new DemoPlayerInteractionManager(\u26036);
        } else {
            playerInteractionManager = new PlayerInteractionManager(\u26036);
        }
        ServerPlayerEntity \u26038 = new ServerPlayerEntity(this.field_72400_f, \u26036, serverPlayerEntity2.func_146103_bH(), playerInteractionManager);
        \u26038.field_71135_a = serverPlayerEntity2.field_71135_a;
        \u26038.func_193104_a(serverPlayerEntity2, bl);
        \u26038.func_145769_d(serverPlayerEntity2.func_145782_y());
        \u26038.func_184819_a(serverPlayerEntity2.func_184591_cq());
        for (String string : serverPlayerEntity2.func_184216_O()) {
            \u26038.func_184211_a(string);
        }
        this.func_72381_a(\u26038, serverPlayerEntity2, \u26036);
        boolean \u26039 = false;
        if (\u26035.isPresent()) {
            float \u260312;
            BlockState blockState = \u26036.func_180495_p(blockPos);
            boolean \u260310 = blockState.func_203425_a(Blocks.field_235400_nj_);
            Vector3d \u260311 = (Vector3d)\u26035.get();
            if (blockState.func_235714_a_(BlockTags.field_219747_F) || \u260310) {
                Vector3d vector3d = Vector3d.func_237492_c_(blockPos).func_178788_d(\u260311).func_72432_b();
                float f = (float)MathHelper.func_76138_g(MathHelper.func_181159_b(vector3d.field_72449_c, vector3d.field_72450_a) * 57.2957763671875 - 90.0);
            } else {
                \u260312 = \u26032;
            }
            \u26038.func_70012_b(\u260311.field_72450_a, \u260311.field_72448_b, \u260311.field_72449_c, \u260312, 0.0f);
            \u26038.func_242111_a(\u26036.func_234923_W_(), blockPos, \u26032, \u26033, false);
            \u26039 = !bl && \u260310;
        } else if (blockPos != null) {
            \u26038.field_71135_a.func_147359_a(new SChangeGameStatePacket(SChangeGameStatePacket.field_241764_a_, 0.0f));
        }
        while (!\u26036.func_226669_j_(\u26038) && \u26038.func_226278_cu_() < 256.0) {
            \u26038.func_70107_b(\u26038.func_226277_ct_(), \u26038.func_226278_cu_() + 1.0, \u26038.func_226281_cx_());
        }
        IWorldInfo iWorldInfo = \u26038.field_70170_p.func_72912_H();
        \u26038.field_71135_a.func_147359_a(new SRespawnPacket(\u26038.field_70170_p.func_230315_m_(), \u26038.field_70170_p.func_234923_W_(), BiomeManager.func_235200_a_(\u26038.func_71121_q().func_72905_C()), \u26038.field_71134_c.func_73081_b(), \u26038.field_71134_c.func_241815_c_(), \u26038.func_71121_q().func_234925_Z_(), \u26038.func_71121_q().func_241109_A_(), bl));
        \u26038.field_71135_a.func_147364_a(\u26038.func_226277_ct_(), \u26038.func_226278_cu_(), \u26038.func_226281_cx_(), \u26038.field_70177_z, \u26038.field_70125_A);
        \u26038.field_71135_a.func_147359_a(new SWorldSpawnChangedPacket(\u26036.func_241135_u_(), \u26036.func_242107_v()));
        \u26038.field_71135_a.func_147359_a(new SServerDifficultyPacket(iWorldInfo.func_176130_y(), iWorldInfo.func_176123_z()));
        \u26038.field_71135_a.func_147359_a(new SSetExperiencePacket(\u26038.field_71106_cc, \u26038.field_71067_cb, \u26038.field_71068_ca));
        this.func_72354_b(\u26038, \u26036);
        this.func_187243_f(\u26038);
        \u26036.func_217433_d(\u26038);
        this.field_72404_b.add(\u26038);
        this.field_177454_f.put(\u26038.func_110124_au(), \u26038);
        \u26038.func_71116_b();
        \u26038.func_70606_j(\u26038.func_110143_aJ());
        if (\u26039) {
            \u26038.field_71135_a.func_147359_a(new SPlaySoundEffectPacket(SoundEvents.field_232818_ms_, SoundCategory.BLOCKS, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), 1.0f, 1.0f));
        }
        return \u26038;
    }

    public void func_187243_f(ServerPlayerEntity serverPlayerEntity) {
        GameProfile gameProfile = serverPlayerEntity.func_146103_bH();
        int \u26032 = this.field_72400_f.func_211833_a(gameProfile);
        this.func_187245_a(serverPlayerEntity, \u26032);
    }

    public void func_72374_b() {
        if (++this.field_72408_o > 600) {
            this.func_148540_a(new SPlayerListItemPacket(SPlayerListItemPacket.Action.UPDATE_LATENCY, this.field_72404_b));
            this.field_72408_o = 0;
        }
    }

    public void func_148540_a(IPacket<?> iPacket) {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            this.field_72404_b.get((int)i).field_71135_a.func_147359_a(iPacket);
        }
    }

    public void func_232642_a_(IPacket<?> iPacket, RegistryKey<World> registryKey) {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            ServerPlayerEntity serverPlayerEntity = this.field_72404_b.get(i);
            if (serverPlayerEntity.field_70170_p.func_234923_W_() != registryKey) continue;
            serverPlayerEntity.field_71135_a.func_147359_a(iPacket);
        }
    }

    public void func_177453_a(PlayerEntity playerEntity, ITextComponent iTextComponent) {
        Team team = playerEntity.func_96124_cp();
        if (team == null) {
            return;
        }
        Collection<String> \u26032 = team.func_96670_d();
        for (String string : \u26032) {
            ServerPlayerEntity serverPlayerEntity = this.func_152612_a(string);
            if (serverPlayerEntity == null || serverPlayerEntity == playerEntity) continue;
            serverPlayerEntity.func_145747_a(iTextComponent, playerEntity.func_110124_au());
        }
    }

    public void func_177452_b(PlayerEntity playerEntity, ITextComponent iTextComponent) {
        Team team = playerEntity.func_96124_cp();
        if (team == null) {
            this.func_232641_a_(iTextComponent, ChatType.SYSTEM, playerEntity.func_110124_au());
            return;
        }
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            ServerPlayerEntity serverPlayerEntity = this.field_72404_b.get(i);
            if (serverPlayerEntity.func_96124_cp() == team) continue;
            serverPlayerEntity.func_145747_a(iTextComponent, playerEntity.func_110124_au());
        }
    }

    public String[] func_72369_d() {
        String[] stringArray = new String[this.field_72404_b.size()];
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            stringArray[i] = this.field_72404_b.get(i).func_146103_bH().getName();
        }
        return stringArray;
    }

    public BanList func_152608_h() {
        return this.field_72401_g;
    }

    public IPBanList func_72363_f() {
        return this.field_72413_h;
    }

    public void func_152605_a(GameProfile gameProfile) {
        this.field_72414_i.func_152687_a(new OpEntry(gameProfile, this.field_72400_f.func_110455_j(), this.field_72414_i.func_183026_b(gameProfile)));
        ServerPlayerEntity serverPlayerEntity = this.func_177451_a(gameProfile.getId());
        if (serverPlayerEntity != null) {
            this.func_187243_f(serverPlayerEntity);
        }
    }

    public void func_152610_b(GameProfile gameProfile) {
        this.field_72414_i.func_152684_c(gameProfile);
        ServerPlayerEntity serverPlayerEntity = this.func_177451_a(gameProfile.getId());
        if (serverPlayerEntity != null) {
            this.func_187243_f(serverPlayerEntity);
        }
    }

    private void func_187245_a(ServerPlayerEntity serverPlayerEntity2, int n) {
        ServerPlayerEntity serverPlayerEntity2;
        if (serverPlayerEntity2.field_71135_a != null) {
            byte by = n <= 0 ? (byte)24 : (n >= 4 ? (byte)28 : (byte)((byte)(24 + n)));
            serverPlayerEntity2.field_71135_a.func_147359_a(new SEntityStatusPacket(serverPlayerEntity2, by));
        }
        this.field_72400_f.func_195571_aL().func_197051_a(serverPlayerEntity2);
    }

    public boolean func_152607_e(GameProfile gameProfile) {
        return !this.field_72409_l || this.field_72414_i.func_152692_d(gameProfile) || this.field_72411_j.func_152692_d(gameProfile);
    }

    public boolean func_152596_g(GameProfile gameProfile) {
        return this.field_72414_i.func_152692_d(gameProfile) || this.field_72400_f.func_213199_b(gameProfile) && this.field_72400_f.func_240793_aU_().func_76086_u() || this.field_72407_n;
    }

    @Nullable
    public ServerPlayerEntity func_152612_a(String string) {
        for (ServerPlayerEntity serverPlayerEntity : this.field_72404_b) {
            if (!serverPlayerEntity.func_146103_bH().getName().equalsIgnoreCase(string)) continue;
            return serverPlayerEntity;
        }
        return null;
    }

    public void func_148543_a(@Nullable PlayerEntity playerEntity, double d, double d2, double d3, double d4, RegistryKey<World> registryKey, IPacket<?> iPacket) {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            ServerPlayerEntity serverPlayerEntity = this.field_72404_b.get(i);
            if (serverPlayerEntity == playerEntity || serverPlayerEntity.field_70170_p.func_234923_W_() != registryKey || !((\u2603 = d - serverPlayerEntity.func_226277_ct_()) * \u2603 + (\u2603 = d2 - serverPlayerEntity.func_226278_cu_()) * \u2603 + (\u2603 = d3 - serverPlayerEntity.func_226281_cx_()) * \u2603 < d4 * d4)) continue;
            serverPlayerEntity.field_71135_a.func_147359_a(iPacket);
        }
    }

    public void func_72389_g() {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            this.func_72391_b(this.field_72404_b.get(i));
        }
    }

    public WhiteList func_152599_k() {
        return this.field_72411_j;
    }

    public String[] func_152598_l() {
        return this.field_72411_j.func_152685_a();
    }

    public OpList func_152603_m() {
        return this.field_72414_i;
    }

    public String[] func_152606_n() {
        return this.field_72414_i.func_152685_a();
    }

    public void func_187244_a() {
    }

    public void func_72354_b(ServerPlayerEntity serverPlayerEntity, ServerWorld serverWorld) {
        WorldBorder worldBorder = this.field_72400_f.func_241755_D_().func_175723_af();
        serverPlayerEntity.field_71135_a.func_147359_a(new SWorldBorderPacket(worldBorder, SWorldBorderPacket.Action.INITIALIZE));
        serverPlayerEntity.field_71135_a.func_147359_a(new SUpdateTimePacket(serverWorld.func_82737_E(), serverWorld.func_72820_D(), serverWorld.func_82736_K().func_223586_b(GameRules.field_223607_j)));
        serverPlayerEntity.field_71135_a.func_147359_a(new SWorldSpawnChangedPacket(serverWorld.func_241135_u_(), serverWorld.func_242107_v()));
        if (serverWorld.func_72896_J()) {
            serverPlayerEntity.field_71135_a.func_147359_a(new SChangeGameStatePacket(SChangeGameStatePacket.field_241765_b_, 0.0f));
            serverPlayerEntity.field_71135_a.func_147359_a(new SChangeGameStatePacket(SChangeGameStatePacket.field_241771_h_, serverWorld.func_72867_j(1.0f)));
            serverPlayerEntity.field_71135_a.func_147359_a(new SChangeGameStatePacket(SChangeGameStatePacket.field_241772_i_, serverWorld.func_72819_i(1.0f)));
        }
    }

    public void func_72385_f(ServerPlayerEntity serverPlayerEntity) {
        serverPlayerEntity.func_71120_a(serverPlayerEntity.field_71069_bz);
        serverPlayerEntity.func_71118_n();
        serverPlayerEntity.field_71135_a.func_147359_a(new SHeldItemChangePacket(serverPlayerEntity.field_71071_by.field_70461_c));
    }

    public int func_72394_k() {
        return this.field_72404_b.size();
    }

    public int func_72352_l() {
        return this.field_72405_c;
    }

    public boolean func_72383_n() {
        return this.field_72409_l;
    }

    public void func_72371_a(boolean bl) {
        this.field_72409_l = bl;
    }

    public List<ServerPlayerEntity> func_72382_j(String string) {
        ArrayList arrayList = Lists.newArrayList();
        for (ServerPlayerEntity serverPlayerEntity : this.field_72404_b) {
            if (!serverPlayerEntity.func_71114_r().equals(string)) continue;
            arrayList.add(serverPlayerEntity);
        }
        return arrayList;
    }

    public int func_72395_o() {
        return this.field_72402_d;
    }

    public MinecraftServer func_72365_p() {
        return this.field_72400_f;
    }

    public CompoundNBT func_72378_q() {
        return null;
    }

    private void func_72381_a(ServerPlayerEntity serverPlayerEntity, @Nullable ServerPlayerEntity serverPlayerEntity2, ServerWorld serverWorld) {
        if (serverPlayerEntity2 != null) {
            serverPlayerEntity.field_71134_c.func_241820_a(serverPlayerEntity2.field_71134_c.func_73081_b(), serverPlayerEntity2.field_71134_c.func_241815_c_());
        } else if (this.field_72410_m != null) {
            serverPlayerEntity.field_71134_c.func_241820_a(this.field_72410_m, GameType.NOT_SET);
        }
        serverPlayerEntity.field_71134_c.func_73077_b(serverWorld.func_73046_m().func_240793_aU_().func_76077_q());
    }

    public void func_72392_r() {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            this.field_72404_b.get((int)i).field_71135_a.func_194028_b(new TranslationTextComponent("multiplayer.disconnect.server_shutdown"));
        }
    }

    public void func_232641_a_(ITextComponent iTextComponent, ChatType chatType, UUID uUID) {
        this.field_72400_f.func_145747_a(iTextComponent, uUID);
        this.func_148540_a(new SChatPacket(iTextComponent, chatType, uUID));
    }

    public ServerStatisticsManager func_152602_a(PlayerEntity playerEntity) {
        ServerStatisticsManager \u26032;
        UUID uUID = playerEntity.func_110124_au();
        ServerStatisticsManager serverStatisticsManager = \u26032 = uUID == null ? null : this.field_148547_k.get(uUID);
        if (\u26032 == null) {
            File file = this.field_72400_f.func_240776_a_(FolderName.field_237246_b_).toFile();
            \u2603 = new File(file, uUID + ".json");
            if (!\u2603.exists() && (\u2603 = new File(file, playerEntity.func_200200_C_().getString() + ".json")).exists() && \u2603.isFile()) {
                \u2603.renameTo(\u2603);
            }
            \u26032 = new ServerStatisticsManager(this.field_72400_f, \u2603);
            this.field_148547_k.put(uUID, \u26032);
        }
        return \u26032;
    }

    public PlayerAdvancements func_192054_h(ServerPlayerEntity serverPlayerEntity2) {
        ServerPlayerEntity serverPlayerEntity2;
        UUID uUID = serverPlayerEntity2.func_110124_au();
        PlayerAdvancements \u26032 = this.field_192055_p.get(uUID);
        if (\u26032 == null) {
            File file = this.field_72400_f.func_240776_a_(FolderName.field_237245_a_).toFile();
            \u2603 = new File(file, uUID + ".json");
            \u26032 = new PlayerAdvancements(this.field_72400_f.func_195563_aC(), this, this.field_72400_f.func_191949_aK(), \u2603, serverPlayerEntity2);
            this.field_192055_p.put(uUID, \u26032);
        }
        \u26032.func_192739_a(serverPlayerEntity2);
        return \u26032;
    }

    public void func_217884_a(int n) {
        this.field_72402_d = n;
        this.func_148540_a(new SUpdateViewDistancePacket(n));
        for (ServerWorld serverWorld : this.field_72400_f.func_212370_w()) {
            if (serverWorld == null) continue;
            serverWorld.func_72863_F().func_217219_a(n);
        }
    }

    public List<ServerPlayerEntity> func_181057_v() {
        return this.field_72404_b;
    }

    @Nullable
    public ServerPlayerEntity func_177451_a(UUID uUID) {
        return this.field_177454_f.get(uUID);
    }

    public boolean func_183023_f(GameProfile gameProfile) {
        return false;
    }

    public void func_193244_w() {
        for (PlayerAdvancements playerAdvancements : this.field_192055_p.values()) {
            playerAdvancements.func_240918_a_(this.field_72400_f.func_191949_aK());
        }
        this.func_148540_a(new STagsListPacket(this.field_72400_f.func_244266_aF()));
        SUpdateRecipesPacket sUpdateRecipesPacket = new SUpdateRecipesPacket(this.field_72400_f.func_199529_aN().func_199510_b());
        for (ServerPlayerEntity serverPlayerEntity : this.field_72404_b) {
            serverPlayerEntity.field_71135_a.func_147359_a(sUpdateRecipesPacket);
            serverPlayerEntity.func_192037_E().func_192826_c(serverPlayerEntity);
        }
    }

    public boolean func_206257_x() {
        return this.field_72407_n;
    }
}

