/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.test;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockStateInput;
import net.minecraft.data.NBTToSNBTConverter;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.test.ITestCallback;
import net.minecraft.test.StructureHelper;
import net.minecraft.test.TestArgArgument;
import net.minecraft.test.TestCollection;
import net.minecraft.test.TestFunctionInfo;
import net.minecraft.test.TestRegistry;
import net.minecraft.test.TestResultList;
import net.minecraft.test.TestTracker;
import net.minecraft.test.TestTypeArgument;
import net.minecraft.test.TestUtils;
import net.minecraft.tileentity.StructureBlockTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.io.IOUtils;

public class TestCommand {
    public static void func_229613_a_(CommandDispatcher<CommandSource> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("test").then(Commands.func_197057_a("runthis").executes(commandContext -> TestCommand.func_229615_a_((CommandSource)commandContext.getSource())))).then(Commands.func_197057_a("runthese").executes(commandContext -> TestCommand.func_229629_b_((CommandSource)commandContext.getSource())))).then(((LiteralArgumentBuilder)Commands.func_197057_a("runfailed").executes(commandContext -> TestCommand.func_240574_a_((CommandSource)commandContext.getSource(), false, 0, 8))).then(((RequiredArgumentBuilder)Commands.func_197056_a("onlyRequiredTests", BoolArgumentType.bool()).executes(commandContext -> TestCommand.func_240574_a_((CommandSource)commandContext.getSource(), BoolArgumentType.getBool((CommandContext)commandContext, (String)"onlyRequiredTests"), 0, 8))).then(((RequiredArgumentBuilder)Commands.func_197056_a("rotationSteps", IntegerArgumentType.integer()).executes(commandContext -> TestCommand.func_240574_a_((CommandSource)commandContext.getSource(), BoolArgumentType.getBool((CommandContext)commandContext, (String)"onlyRequiredTests"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"rotationSteps"), 8))).then(Commands.func_197056_a("testsPerRow", IntegerArgumentType.integer()).executes(commandContext -> TestCommand.func_240574_a_((CommandSource)commandContext.getSource(), BoolArgumentType.getBool((CommandContext)commandContext, (String)"onlyRequiredTests"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"rotationSteps"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"testsPerRow")))))))).then(Commands.func_197057_a("run").then(((RequiredArgumentBuilder)Commands.func_197056_a("testName", TestArgArgument.func_229665_a_()).executes(commandContext -> TestCommand.func_229620_a_((CommandSource)commandContext.getSource(), TestArgArgument.func_229666_a_((CommandContext<CommandSource>)commandContext, "testName"), 0))).then(Commands.func_197056_a("rotationSteps", IntegerArgumentType.integer()).executes(commandContext -> TestCommand.func_229620_a_((CommandSource)commandContext.getSource(), TestArgArgument.func_229666_a_((CommandContext<CommandSource>)commandContext, "testName"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"rotationSteps"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("runall").executes(commandContext -> TestCommand.func_229633_c_((CommandSource)commandContext.getSource(), 0, 8))).then(((RequiredArgumentBuilder)Commands.func_197056_a("testClassName", TestTypeArgument.func_229611_a_()).executes(commandContext -> TestCommand.func_229630_b_((CommandSource)commandContext.getSource(), TestTypeArgument.func_229612_a_((CommandContext<CommandSource>)commandContext, "testClassName"), 0, 8))).then(((RequiredArgumentBuilder)Commands.func_197056_a("rotationSteps", IntegerArgumentType.integer()).executes(commandContext -> TestCommand.func_229630_b_((CommandSource)commandContext.getSource(), TestTypeArgument.func_229612_a_((CommandContext<CommandSource>)commandContext, "testClassName"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"rotationSteps"), 8))).then(Commands.func_197056_a("testsPerRow", IntegerArgumentType.integer()).executes(commandContext -> TestCommand.func_229630_b_((CommandSource)commandContext.getSource(), TestTypeArgument.func_229612_a_((CommandContext<CommandSource>)commandContext, "testClassName"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"rotationSteps"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"testsPerRow"))))))).then(((RequiredArgumentBuilder)Commands.func_197056_a("rotationSteps", IntegerArgumentType.integer()).executes(commandContext -> TestCommand.func_229633_c_((CommandSource)commandContext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"rotationSteps"), 8))).then(Commands.func_197056_a("testsPerRow", IntegerArgumentType.integer()).executes(commandContext -> TestCommand.func_229633_c_((CommandSource)commandContext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"rotationSteps"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"testsPerRow"))))))).then(Commands.func_197057_a("export").then(Commands.func_197056_a("testName", StringArgumentType.word()).executes(commandContext -> TestCommand.func_229636_d_((CommandSource)commandContext.getSource(), StringArgumentType.getString((CommandContext)commandContext, (String)"testName")))))).then(Commands.func_197057_a("exportthis").executes(commandContext -> TestCommand.func_240581_c_((CommandSource)commandContext.getSource())))).then(Commands.func_197057_a("import").then(Commands.func_197056_a("testName", StringArgumentType.word()).executes(commandContext -> TestCommand.func_229638_e_((CommandSource)commandContext.getSource(), StringArgumentType.getString((CommandContext)commandContext, (String)"testName")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a("pos").executes(commandContext -> TestCommand.func_229617_a_((CommandSource)commandContext.getSource(), "pos"))).then(Commands.func_197056_a("var", StringArgumentType.word()).executes(commandContext -> TestCommand.func_229617_a_((CommandSource)commandContext.getSource(), StringArgumentType.getString((CommandContext)commandContext, (String)"var")))))).then(Commands.func_197057_a("create").then(((RequiredArgumentBuilder)Commands.func_197056_a("testName", StringArgumentType.word()).executes(commandContext -> TestCommand.func_229618_a_((CommandSource)commandContext.getSource(), StringArgumentType.getString((CommandContext)commandContext, (String)"testName"), 5, 5, 5))).then(((RequiredArgumentBuilder)Commands.func_197056_a("width", IntegerArgumentType.integer()).executes(commandContext -> TestCommand.func_229618_a_((CommandSource)commandContext.getSource(), StringArgumentType.getString((CommandContext)commandContext, (String)"testName"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"width"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"width"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"width")))).then(Commands.func_197056_a("height", IntegerArgumentType.integer()).then(Commands.func_197056_a("depth", IntegerArgumentType.integer()).executes(commandContext -> TestCommand.func_229618_a_((CommandSource)commandContext.getSource(), StringArgumentType.getString((CommandContext)commandContext, (String)"testName"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"width"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"height"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"depth"))))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a("clearall").executes(commandContext -> TestCommand.func_229616_a_((CommandSource)commandContext.getSource(), 200))).then(Commands.func_197056_a("radius", IntegerArgumentType.integer()).executes(commandContext -> TestCommand.func_229616_a_((CommandSource)commandContext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"radius"))))));
    }

    private static int func_229618_a_(CommandSource commandSource, String string, int n, int n2, int n3) {
        if (n > 48 || n2 > 48 || n3 > 48) {
            throw new IllegalArgumentException("The structure must be less than 48 blocks big in each axis");
        }
        ServerWorld serverWorld = commandSource.func_197023_e();
        BlockPos \u26032 = new BlockPos(commandSource.func_197036_d());
        BlockPos \u26033 = new BlockPos(\u26032.func_177958_n(), commandSource.func_197023_e().func_205770_a(Heightmap.Type.WORLD_SURFACE, \u26032).func_177956_o(), \u26032.func_177952_p() + 3);
        StructureHelper.func_229603_a_(string.toLowerCase(), \u26033, new BlockPos(n, n2, n3), Rotation.NONE, serverWorld);
        for (int i = 0; i < n; ++i) {
            for (\u2603 = 0; \u2603 < n3; ++\u2603) {
                BlockPos blockPos = new BlockPos(\u26033.func_177958_n() + i, \u26033.func_177956_o() + 1, \u26033.func_177952_p() + \u2603);
                Block \u26034 = Blocks.field_196657_h;
                BlockStateInput \u26035 = new BlockStateInput(\u26034.func_176223_P(), Collections.EMPTY_SET, null);
                \u26035.func_197230_a(serverWorld, blockPos, 2);
            }
        }
        StructureHelper.func_240564_a_(\u26033, new BlockPos(1, 0, -1), Rotation.NONE, serverWorld);
        return 0;
    }

    private static int func_229617_a_(CommandSource commandSource, String string) throws CommandSyntaxException {
        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)commandSource.func_197035_h().func_213324_a(10.0, 1.0f, false);
        BlockPos \u26032 = blockRayTraceResult.func_216350_a();
        Optional<BlockPos> \u26033 = StructureHelper.func_229596_a_(\u26032, 15, \u2603 = commandSource.func_197023_e());
        if (!\u26033.isPresent()) {
            \u26033 = StructureHelper.func_229596_a_(\u26032, 200, \u2603);
        }
        if (!\u26033.isPresent()) {
            commandSource.func_197021_a(new StringTextComponent("Can't find a structure block that contains the targeted pos " + \u26032));
            return 0;
        }
        StructureBlockTileEntity \u26034 = (StructureBlockTileEntity)\u2603.func_175625_s(\u26033.get());
        BlockPos \u26035 = \u26032.func_177973_b(\u26033.get());
        String \u26036 = \u26035.func_177958_n() + ", " + \u26035.func_177956_o() + ", " + \u26035.func_177952_p();
        String \u26037 = \u26034.func_227014_f_();
        IFormattableTextComponent \u26038 = new StringTextComponent(\u26036).func_230530_a_(Style.field_240709_b_.func_240713_a_(true).func_240712_a_(TextFormatting.GREEN).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, new StringTextComponent("Click to copy to clipboard"))).func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, "final BlockPos " + string + " = new BlockPos(" + \u26036 + ");")));
        commandSource.func_197030_a(new StringTextComponent("Position relative to " + \u26037 + ": ").func_230529_a_(\u26038), false);
        DebugPacketSender.func_229752_a_(\u2603, new BlockPos(\u26032), \u26036, -2147418368, 10000);
        return 1;
    }

    private static int func_229615_a_(CommandSource commandSource) {
        BlockPos blockPos = new BlockPos(commandSource.func_197036_d());
        \u2603 = StructureHelper.func_229607_b_(blockPos, 15, \u2603 = commandSource.func_197023_e());
        if (\u2603 == null) {
            TestCommand.func_229624_a_(\u2603, "Couldn't find any structure block within 15 radius", TextFormatting.RED);
            return 0;
        }
        TestUtils.func_229552_a_(\u2603);
        TestCommand.func_229623_a_(\u2603, \u2603, null);
        return 1;
    }

    private static int func_229629_b_(CommandSource commandSource) {
        BlockPos blockPos2 = new BlockPos(commandSource.func_197036_d());
        Collection<BlockPos> \u26032 = StructureHelper.func_229609_c_(blockPos2, 200, \u2603 = commandSource.func_197023_e());
        if (\u26032.isEmpty()) {
            TestCommand.func_229624_a_(\u2603, "Couldn't find any structure blocks within 200 block radius", TextFormatting.RED);
            return 1;
        }
        TestUtils.func_229552_a_(\u2603);
        TestCommand.func_229634_c_(commandSource, "Running " + \u26032.size() + " tests...");
        TestResultList \u26033 = new TestResultList();
        \u26032.forEach(blockPos -> TestCommand.func_229623_a_(\u2603, blockPos, \u26033));
        return 1;
    }

    private static void func_229623_a_(ServerWorld serverWorld, BlockPos blockPos, @Nullable TestResultList testResultList) {
        StructureBlockTileEntity structureBlockTileEntity = (StructureBlockTileEntity)serverWorld.func_175625_s(blockPos);
        String \u26032 = structureBlockTileEntity.func_227014_f_();
        TestFunctionInfo \u26033 = TestRegistry.func_229538_e_(\u26032);
        TestTracker \u26034 = new TestTracker(\u26033, structureBlockTileEntity.func_189726_i(), serverWorld);
        if (testResultList != null) {
            testResultList.func_229579_a_(\u26034);
            \u26034.func_229504_a_(new Callback(serverWorld, testResultList));
        }
        TestCommand.func_229622_a_(\u26033, serverWorld);
        AxisAlignedBB \u26035 = StructureHelper.func_229594_a_(structureBlockTileEntity);
        BlockPos \u26036 = new BlockPos(\u26035.field_72340_a, \u26035.field_72338_b, \u26035.field_72339_c);
        TestUtils.func_240553_a_(\u26034, \u26036, TestCollection.field_229570_a_);
    }

    private static void func_229631_b_(ServerWorld serverWorld, TestResultList testResultList) {
        if (testResultList.func_229588_i_()) {
            TestCommand.func_229624_a_(serverWorld, "GameTest done! " + testResultList.func_229587_h_() + " tests were run", TextFormatting.WHITE);
            if (testResultList.func_229585_d_()) {
                TestCommand.func_229624_a_(serverWorld, "" + testResultList.func_229578_a_() + " required tests failed :(", TextFormatting.RED);
            } else {
                TestCommand.func_229624_a_(serverWorld, "All required tests passed :)", TextFormatting.GREEN);
            }
            if (testResultList.func_229586_e_()) {
                TestCommand.func_229624_a_(serverWorld, "" + testResultList.func_229583_b_() + " optional tests failed", TextFormatting.GRAY);
            }
        }
    }

    private static int func_229616_a_(CommandSource commandSource, int n) {
        ServerWorld serverWorld = commandSource.func_197023_e();
        TestUtils.func_229552_a_(serverWorld);
        BlockPos \u26032 = new BlockPos(commandSource.func_197036_d().field_72450_a, (double)commandSource.func_197023_e().func_205770_a(Heightmap.Type.WORLD_SURFACE, new BlockPos(commandSource.func_197036_d())).func_177956_o(), commandSource.func_197036_d().field_72449_c);
        TestUtils.func_229555_a_(serverWorld, \u26032, TestCollection.field_229570_a_, MathHelper.func_76125_a(n, 0, 1024));
        return 1;
    }

    private static int func_229620_a_(CommandSource commandSource, TestFunctionInfo testFunctionInfo, int n) {
        ServerWorld serverWorld = commandSource.func_197023_e();
        BlockPos \u26032 = new BlockPos(commandSource.func_197036_d());
        int \u26033 = commandSource.func_197023_e().func_205770_a(Heightmap.Type.WORLD_SURFACE, \u26032).func_177956_o();
        BlockPos \u26034 = new BlockPos(\u26032.func_177958_n(), \u26033, \u26032.func_177952_p() + 3);
        TestUtils.func_229552_a_(serverWorld);
        TestCommand.func_229622_a_(testFunctionInfo, serverWorld);
        Rotation \u26035 = StructureHelper.func_240562_a_(n);
        TestTracker \u26036 = new TestTracker(testFunctionInfo, \u26035, serverWorld);
        TestUtils.func_240553_a_(\u26036, \u26034, TestCollection.field_229570_a_);
        return 1;
    }

    private static void func_229622_a_(TestFunctionInfo testFunctionInfo, ServerWorld serverWorld) {
        Consumer<ServerWorld> consumer = TestRegistry.func_229536_c_(testFunctionInfo.func_229662_e_());
        if (consumer != null) {
            consumer.accept(serverWorld);
        }
    }

    private static int func_229633_c_(CommandSource commandSource, int n, int n2) {
        TestUtils.func_229552_a_(commandSource.func_197023_e());
        Collection<TestFunctionInfo> collection = TestRegistry.func_229529_a_();
        TestCommand.func_229634_c_(commandSource, "Running all " + collection.size() + " tests...");
        TestRegistry.func_240550_d_();
        TestCommand.func_229619_a_(commandSource, collection, n, n2);
        return 1;
    }

    private static int func_229630_b_(CommandSource commandSource, String string, int n, int n2) {
        Collection<TestFunctionInfo> collection = TestRegistry.func_229530_a_(string);
        TestUtils.func_229552_a_(commandSource.func_197023_e());
        TestCommand.func_229634_c_(commandSource, "Running " + collection.size() + " tests from " + string + "...");
        TestRegistry.func_240550_d_();
        TestCommand.func_229619_a_(commandSource, collection, n, n2);
        return 1;
    }

    private static int func_240574_a_(CommandSource commandSource, boolean bl, int n, int n2) {
        Collection collection = bl ? (Collection)TestRegistry.func_240549_c_().stream().filter(TestFunctionInfo::func_229661_d_).collect(Collectors.toList()) : TestRegistry.func_240549_c_();
        if (collection.isEmpty()) {
            TestCommand.func_229634_c_(commandSource, "No failed tests to rerun");
            return 0;
        }
        TestUtils.func_229552_a_(commandSource.func_197023_e());
        TestCommand.func_229634_c_(commandSource, "Rerunning " + collection.size() + " failed tests (" + (bl ? "only required tests" : "including optional tests") + ")");
        TestCommand.func_229619_a_(commandSource, collection, n, n2);
        return 1;
    }

    private static void func_229619_a_(CommandSource commandSource, Collection<TestFunctionInfo> collection, int n, int n2) {
        BlockPos blockPos = new BlockPos(commandSource.func_197036_d());
        \u2603 = new BlockPos(blockPos.func_177958_n(), commandSource.func_197023_e().func_205770_a(Heightmap.Type.WORLD_SURFACE, blockPos).func_177956_o(), blockPos.func_177952_p() + 3);
        ServerWorld \u26032 = commandSource.func_197023_e();
        Rotation \u26033 = StructureHelper.func_240562_a_(n);
        Collection<TestTracker> \u26034 = TestUtils.func_240554_b_(collection, \u2603, \u26033, \u26032, TestCollection.field_229570_a_, n2);
        TestResultList \u26035 = new TestResultList(\u26034);
        \u26035.func_240558_a_(new Callback(\u26032, \u26035));
        \u26035.func_240556_a_(testTracker -> TestRegistry.func_240548_a_(testTracker.func_240546_u_()));
    }

    private static void func_229634_c_(CommandSource commandSource, String string) {
        commandSource.func_197030_a(new StringTextComponent(string), false);
    }

    private static int func_240581_c_(CommandSource commandSource) {
        BlockPos blockPos = new BlockPos(commandSource.func_197036_d());
        \u2603 = StructureHelper.func_229607_b_(blockPos, 15, \u2603 = commandSource.func_197023_e());
        if (\u2603 == null) {
            TestCommand.func_229624_a_(\u2603, "Couldn't find any structure block within 15 radius", TextFormatting.RED);
            return 0;
        }
        StructureBlockTileEntity \u26032 = (StructureBlockTileEntity)\u2603.func_175625_s(\u2603);
        String \u26033 = \u26032.func_227014_f_();
        return TestCommand.func_229636_d_(commandSource, \u26033);
    }

    private static int func_229636_d_(CommandSource commandSource, String string) {
        Path path = Paths.get(StructureHelper.field_229590_a_, new String[0]);
        ResourceLocation \u26032 = new ResourceLocation("minecraft", string);
        \u2603 = commandSource.func_197023_e().func_184163_y().func_209509_a(\u26032, ".nbt");
        \u2603 = NBTToSNBTConverter.func_229443_a_(\u2603, string, path);
        if (\u2603 == null) {
            TestCommand.func_229634_c_(commandSource, "Failed to export " + \u2603);
            return 1;
        }
        try {
            Files.createDirectories(\u2603.getParent(), new FileAttribute[0]);
        }
        catch (IOException \u26033) {
            TestCommand.func_229634_c_(commandSource, "Could not create folder " + \u2603.getParent());
            \u26033.printStackTrace();
            return 1;
        }
        TestCommand.func_229634_c_(commandSource, "Exported " + string + " to " + \u2603.toAbsolutePath());
        return 0;
    }

    private static int func_229638_e_(CommandSource commandSource, String string) {
        Path path = Paths.get(StructureHelper.field_229590_a_, string + ".snbt");
        ResourceLocation \u26032 = new ResourceLocation("minecraft", string);
        \u2603 = commandSource.func_197023_e().func_184163_y().func_209509_a(\u26032, ".nbt");
        try {
            BufferedReader bufferedReader = Files.newBufferedReader(path);
            String \u26033 = IOUtils.toString((Reader)bufferedReader);
            Files.createDirectories(\u2603.getParent(), new FileAttribute[0]);
            try (OutputStream \u26034 = Files.newOutputStream(\u2603, new OpenOption[0]);){
                CompressedStreamTools.func_74799_a(JsonToNBT.func_180713_a(\u26033), \u26034);
            }
            TestCommand.func_229634_c_(commandSource, "Imported to " + \u2603.toAbsolutePath());
            return 0;
        }
        catch (CommandSyntaxException | IOException throwable) {
            System.err.println("Failed to load structure " + string);
            throwable.printStackTrace();
            return 1;
        }
    }

    private static void func_229624_a_(ServerWorld serverWorld, String string, TextFormatting textFormatting) {
        serverWorld.func_217490_a(serverPlayerEntity -> true).forEach(serverPlayerEntity -> serverPlayerEntity.func_145747_a(new StringTextComponent((Object)((Object)textFormatting) + string), Util.field_240973_b_));
    }

    static class Callback
    implements ITestCallback {
        private final ServerWorld field_229648_a_;
        private final TestResultList field_229649_b_;

        public Callback(ServerWorld serverWorld, TestResultList testResultList) {
            this.field_229648_a_ = serverWorld;
            this.field_229649_b_ = testResultList;
        }

        @Override
        public void func_225644_a_(TestTracker testTracker) {
        }

        @Override
        public void func_225645_c_(TestTracker testTracker) {
            TestCommand.func_229631_b_(this.field_229648_a_, this.field_229649_b_);
        }
    }
}

