/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.datafix.TypeReferences;

public class FurnaceRecipes
extends DataFix {
    public FurnaceRecipes(Schema schema, boolean bl) {
        super(schema, bl);
    }

    protected TypeRewriteRule makeRule() {
        return this.func_233248_a_(this.getOutputSchema().getTypeRaw(TypeReferences.field_211304_t));
    }

    private <R> TypeRewriteRule func_233248_a_(Type<R> type) {
        Type type2 = DSL.and((Type)DSL.optional((Type)DSL.field((String)"RecipesUsed", (Type)DSL.and((Type)DSL.compoundList(type, (Type)DSL.intType()), (Type)DSL.remainderType()))), (Type)DSL.remainderType());
        OpticFinder \u26032 = DSL.namedChoice((String)"minecraft:furnace", (Type)this.getInputSchema().getChoiceType(TypeReferences.field_211294_j, "minecraft:furnace"));
        OpticFinder \u26033 = DSL.namedChoice((String)"minecraft:blast_furnace", (Type)this.getInputSchema().getChoiceType(TypeReferences.field_211294_j, "minecraft:blast_furnace"));
        OpticFinder \u26034 = DSL.namedChoice((String)"minecraft:smoker", (Type)this.getInputSchema().getChoiceType(TypeReferences.field_211294_j, "minecraft:smoker"));
        \u2603 = this.getOutputSchema().getChoiceType(TypeReferences.field_211294_j, "minecraft:furnace");
        \u2603 = this.getOutputSchema().getChoiceType(TypeReferences.field_211294_j, "minecraft:blast_furnace");
        \u2603 = this.getOutputSchema().getChoiceType(TypeReferences.field_211294_j, "minecraft:smoker");
        \u2603 = this.getInputSchema().getType(TypeReferences.field_211294_j);
        \u2603 = this.getOutputSchema().getType(TypeReferences.field_211294_j);
        return this.fixTypeEverywhereTyped("FurnaceRecipesFix", \u2603, \u2603, typed2 -> typed2.updateTyped(\u26032, \u2603, typed -> this.func_233249_a_(type, (Type)type2, (Typed<?>)typed)).updateTyped(\u26033, \u2603, typed -> this.func_233249_a_(type, (Type)type2, (Typed<?>)typed)).updateTyped(\u26034, \u2603, typed -> this.func_233249_a_(type, (Type)type2, (Typed<?>)typed)));
    }

    private <R> Typed<?> func_233249_a_(Type<R> type, Type<Pair<Either<Pair<List<Pair<R, Integer>>, Dynamic<?>>, Unit>, Dynamic<?>>> type2, Typed<?> typed) {
        Dynamic \u26036 = (Dynamic)typed.getOrCreate(DSL.remainderFinder());
        int \u26032 = \u26036.get("RecipesUsedSize").asInt(0);
        \u26036 = \u26036.remove("RecipesUsedSize");
        ArrayList \u26033 = Lists.newArrayList();
        for (int i = 0; i < \u26032; ++i) {
            String string = "RecipeLocation" + i;
            \u2603 = "RecipeAmount" + i;
            Optional \u26034 = \u26036.get(string).result();
            int \u26035 = \u26036.get(\u2603).asInt(0);
            if (\u26035 > 0) {
                \u26034.ifPresent(dynamic -> {
                    Optional optional = type.read(dynamic).result();
                    optional.ifPresent(pair -> \u26033.add(Pair.of((Object)pair.getFirst(), (Object)\u26035)));
                });
            }
            \u26036 = \u26036.remove(string).remove(\u2603);
        }
        return typed.set(DSL.remainderFinder(), type2, (Object)Pair.of((Object)Either.left((Object)Pair.of((Object)\u26033, (Object)\u26036.emptyMap())), (Object)\u26036));
    }
}

