/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.world.gen.INoiseGenerator;
import net.minecraft.world.gen.SimplexNoiseGenerator;

public class PerlinNoiseGenerator
implements INoiseGenerator {
    private final SimplexNoiseGenerator[] field_151603_a;
    private final double field_227462_b_;
    private final double field_227463_c_;

    public PerlinNoiseGenerator(SharedSeedRandom sharedSeedRandom, IntStream intStream) {
        this(sharedSeedRandom, (List)intStream.boxed().collect(ImmutableList.toImmutableList()));
    }

    public PerlinNoiseGenerator(SharedSeedRandom sharedSeedRandom, List<Integer> list) {
        this(sharedSeedRandom, (IntSortedSet)new IntRBTreeSet(list));
    }

    private PerlinNoiseGenerator(SharedSeedRandom sharedSeedRandom, IntSortedSet intSortedSet) {
        int n;
        if (intSortedSet.isEmpty()) {
            throw new IllegalArgumentException("Need some octaves!");
        }
        int n2 = -intSortedSet.firstInt();
        \u2603 = n2 + (n = intSortedSet.lastInt()) + 1;
        if (\u2603 < 1) {
            throw new IllegalArgumentException("Total number of octaves needs to be >= 1");
        }
        SimplexNoiseGenerator \u26032 = new SimplexNoiseGenerator(sharedSeedRandom);
        \u2603 = n;
        this.field_151603_a = new SimplexNoiseGenerator[\u2603];
        if (\u2603 >= 0 && \u2603 < \u2603 && intSortedSet.contains(0)) {
            this.field_151603_a[\u2603] = \u26032;
        }
        for (\u2603 = \u2603 + 1; \u2603 < \u2603; ++\u2603) {
            if (\u2603 >= 0 && intSortedSet.contains(\u2603 - \u2603)) {
                this.field_151603_a[\u2603] = new SimplexNoiseGenerator(sharedSeedRandom);
                continue;
            }
            sharedSeedRandom.func_202423_a(262);
        }
        if (n > 0) {
            long l = (long)(\u26032.func_227464_a_(\u26032.field_151612_b, \u26032.field_151613_c, \u26032.field_151610_d) * 9.223372036854776E18);
            SharedSeedRandom \u26033 = new SharedSeedRandom(l);
            for (int i = \u2603 - 1; i >= 0; --i) {
                if (i < \u2603 && intSortedSet.contains(\u2603 - i)) {
                    this.field_151603_a[i] = new SimplexNoiseGenerator(\u26033);
                    continue;
                }
                \u26033.func_202423_a(262);
            }
        }
        this.field_227463_c_ = Math.pow(2.0, n);
        this.field_227462_b_ = 1.0 / (Math.pow(2.0, \u2603) - 1.0);
    }

    public double func_215464_a(double d, double d2, boolean bl) {
        double d3 = 0.0;
        \u2603 = this.field_227463_c_;
        \u2603 = this.field_227462_b_;
        for (SimplexNoiseGenerator simplexNoiseGenerator : this.field_151603_a) {
            if (simplexNoiseGenerator != null) {
                d3 += simplexNoiseGenerator.func_151605_a(d * \u2603 + (bl ? simplexNoiseGenerator.field_151612_b : 0.0), d2 * \u2603 + (bl ? simplexNoiseGenerator.field_151613_c : 0.0)) * \u2603;
            }
            \u2603 /= 2.0;
            \u2603 *= 2.0;
        }
        return d3;
    }

    @Override
    public double func_215460_a(double d, double d2, double d3, double d4) {
        return this.func_215464_a(d, d2, true) * 0.55;
    }
}

