/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.GlazedTerracottaBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockVoxelShape;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.extensions.IForgeBlock;
import net.minecraftforge.common.util.ReverseTagWrapper;
import net.minecraftforge.registries.GameData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Block
extends AbstractBlock
implements IItemProvider,
IForgeBlock {
    protected static final Logger field_196273_d = LogManager.getLogger();
    @Deprecated
    public static final ObjectIntIdentityMap<BlockState> field_176229_d = GameData.getBlockStateIDMap();
    private static final LoadingCache<VoxelShape, Boolean> field_223006_b = CacheBuilder.newBuilder().maximumSize(512L).weakKeys().build((CacheLoader)new CacheLoader<VoxelShape, Boolean>(){

        public Boolean load(VoxelShape p_load_1_) {
            return !VoxelShapes.func_197879_c((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)p_load_1_, (IBooleanFunction)IBooleanFunction.field_223236_g_);
        }
    });
    protected final StateContainer<Block, BlockState> field_176227_L;
    private BlockState field_196275_y;
    @Nullable
    private String field_149770_b;
    @Nullable
    private Item field_220086_i;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<RenderSideCacheKey>> field_210300_r = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<RenderSideCacheKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<RenderSideCacheKey>(2048, 0.25f){

            protected void rehash(int p_rehash_1_) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });
    protected Random RANDOM = new Random();
    private ToolType harvestTool;
    private int harvestLevel;
    private final ReverseTagWrapper<Block> reverseTags = new ReverseTagWrapper((Object)this, BlockTags::func_199896_a);

    public static int func_196246_j(@Nullable BlockState p_196246_0_) {
        if (p_196246_0_ == null) {
            return 0;
        }
        int i = field_176229_d.func_148757_b((Object)p_196246_0_);
        return i == -1 ? 0 : i;
    }

    public static BlockState func_196257_b(int p_196257_0_) {
        BlockState blockstate = (BlockState)((Object)field_176229_d.func_148745_a(p_196257_0_));
        return blockstate == null ? Blocks.field_150350_a.func_176223_P() : blockstate;
    }

    public static Block func_149634_a(@Nullable Item p_149634_0_) {
        return p_149634_0_ instanceof BlockItem ? ((BlockItem)p_149634_0_).func_179223_d() : Blocks.field_150350_a;
    }

    public static BlockState func_199601_a(BlockState p_199601_0_, BlockState p_199601_1_, World p_199601_2_, BlockPos p_199601_3_) {
        VoxelShape voxelshape = VoxelShapes.func_197882_b((VoxelShape)p_199601_0_.func_196952_d((IBlockReader)((Object)p_199601_2_), p_199601_3_), (VoxelShape)p_199601_1_.func_196952_d((IBlockReader)((Object)p_199601_2_), p_199601_3_), (IBooleanFunction)IBooleanFunction.field_223232_c_).func_197751_a((double)p_199601_3_.func_177958_n(), (double)p_199601_3_.func_177956_o(), (double)p_199601_3_.func_177952_p());
        for (Entity entity : p_199601_2_.func_72839_b(null, voxelshape.func_197752_a())) {
            double d0 = VoxelShapes.func_212437_a((Direction.Axis)Direction.Axis.Y, (AxisAlignedBB)entity.func_174813_aQ().func_72317_d(0.0, 1.0, 0.0), Stream.of(voxelshape), (double)-1.0);
            entity.func_70634_a(entity.func_226277_ct_(), entity.func_226278_cu_() + 1.0 + d0, entity.func_226281_cx_());
        }
        return p_199601_1_;
    }

    public static VoxelShape func_208617_a(double p_208617_0_, double p_208617_2_, double p_208617_4_, double p_208617_6_, double p_208617_8_, double p_208617_10_) {
        return VoxelShapes.func_197873_a((double)(p_208617_0_ / 16.0), (double)(p_208617_2_ / 16.0), (double)(p_208617_4_ / 16.0), (double)(p_208617_6_ / 16.0), (double)(p_208617_8_ / 16.0), (double)(p_208617_10_ / 16.0));
    }

    public boolean func_203417_a(ITag<Block> p_203417_1_) {
        return p_203417_1_.func_230235_a_(this);
    }

    public boolean func_235332_a_(Block p_235332_1_) {
        return this == p_235332_1_;
    }

    public static BlockState func_199770_b(BlockState p_199770_0_, IWorld p_199770_1_, BlockPos p_199770_2_) {
        BlockState blockstate = p_199770_0_;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (Direction direction : field_212556_a) {
            blockpos$mutable.func_239622_a_((Vector3i)p_199770_2_, direction);
            blockstate = blockstate.func_196956_a(direction, p_199770_1_.func_180495_p((BlockPos)blockpos$mutable), p_199770_1_, p_199770_2_, (BlockPos)blockpos$mutable);
        }
        return blockstate;
    }

    public static void func_196263_a(BlockState p_196263_0_, BlockState p_196263_1_, IWorld p_196263_2_, BlockPos p_196263_3_, int p_196263_4_) {
        Block.func_241468_a_(p_196263_0_, p_196263_1_, p_196263_2_, p_196263_3_, p_196263_4_, 512);
    }

    public static void func_241468_a_(BlockState p_241468_0_, BlockState p_241468_1_, IWorld p_241468_2_, BlockPos p_241468_3_, int p_241468_4_, int p_241468_5_) {
        if (p_241468_1_ != p_241468_0_) {
            if (p_241468_1_.func_196958_f()) {
                if (!p_241468_2_.func_201670_d()) {
                    p_241468_2_.func_241212_a_(p_241468_3_, (p_241468_4_ & 0x20) == 0, (Entity)null, p_241468_5_);
                }
            } else {
                p_241468_2_.func_241211_a_(p_241468_3_, p_241468_1_, p_241468_4_ & 0xFFFFFFDF, p_241468_5_);
            }
        }
    }

    public Block(AbstractBlock.Properties p_i48440_1_) {
        super(p_i48440_1_);
        StateContainer.Builder builder = new StateContainer.Builder((Object)this);
        this.func_206840_a((StateContainer.Builder<Block, BlockState>)builder);
        this.harvestLevel = p_i48440_1_.getHarvestLevel();
        this.harvestTool = p_i48440_1_.getHarvestTool();
        this.field_176227_L = builder.func_235882_a_(Block::func_176223_P, BlockState::new);
        this.func_180632_j((BlockState)this.field_176227_L.func_177621_b());
    }

    public static boolean func_220073_a(Block p_220073_0_) {
        return p_220073_0_ instanceof LeavesBlock || p_220073_0_ == Blocks.field_180401_cv || p_220073_0_ == Blocks.field_196625_cS || p_220073_0_ == Blocks.field_196628_cT || p_220073_0_ == Blocks.field_150440_ba || p_220073_0_ == Blocks.field_150423_aK || p_220073_0_.func_203417_a(BlockTags.field_226150_J_);
    }

    public boolean func_149653_t(BlockState p_149653_1_) {
        return this.field_149789_z;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean func_176225_a(BlockState p_176225_0_, IBlockReader p_176225_1_, BlockPos p_176225_2_, Direction p_176225_3_) {
        BlockPos blockpos = p_176225_2_.func_177972_a(p_176225_3_);
        BlockState blockstate = p_176225_1_.func_180495_p(blockpos);
        if (p_176225_0_.func_200017_a(blockstate, p_176225_3_)) {
            return false;
        }
        if (blockstate.func_200132_m()) {
            RenderSideCacheKey block$rendersidecachekey = new RenderSideCacheKey(p_176225_0_, blockstate, p_176225_3_);
            Object2ByteLinkedOpenHashMap<RenderSideCacheKey> object2bytelinkedopenhashmap = field_210300_r.get();
            byte b0 = object2bytelinkedopenhashmap.getAndMoveToFirst((Object)block$rendersidecachekey);
            if (b0 != 127) {
                return b0 != 0;
            }
            VoxelShape voxelshape = p_176225_0_.func_215702_a(p_176225_1_, p_176225_2_, p_176225_3_);
            VoxelShape voxelshape1 = blockstate.func_215702_a(p_176225_1_, blockpos, p_176225_3_.func_176734_d());
            boolean flag = VoxelShapes.func_197879_c((VoxelShape)voxelshape, (VoxelShape)voxelshape1, (IBooleanFunction)IBooleanFunction.field_223234_e_);
            if (object2bytelinkedopenhashmap.size() == 2048) {
                object2bytelinkedopenhashmap.removeLastByte();
            }
            object2bytelinkedopenhashmap.putAndMoveToFirst((Object)block$rendersidecachekey, (byte)(flag ? 1 : 0));
            return flag;
        }
        return true;
    }

    public static boolean func_220064_c(IBlockReader p_220064_0_, BlockPos p_220064_1_) {
        return p_220064_0_.func_180495_p(p_220064_1_).func_242698_a(p_220064_0_, p_220064_1_, Direction.UP, BlockVoxelShape.RIGID);
    }

    public static boolean func_220055_a(IWorldReader p_220055_0_, BlockPos p_220055_1_, Direction p_220055_2_) {
        BlockState blockstate = p_220055_0_.func_180495_p(p_220055_1_);
        return p_220055_2_ == Direction.DOWN && blockstate.func_235714_a_(BlockTags.field_232869_aB_) ? false : blockstate.func_242698_a((IBlockReader)((Object)p_220055_0_), p_220055_1_, p_220055_2_, BlockVoxelShape.CENTER);
    }

    public static boolean func_208061_a(VoxelShape p_208061_0_, Direction p_208061_1_) {
        VoxelShape voxelshape = p_208061_0_.func_212434_a(p_208061_1_);
        return Block.func_208062_a(voxelshape);
    }

    public static boolean func_208062_a(VoxelShape p_208062_0_) {
        return (Boolean)field_223006_b.getUnchecked((Object)p_208062_0_);
    }

    public boolean func_200123_i(BlockState p_200123_1_, IBlockReader p_200123_2_, BlockPos p_200123_3_) {
        return !Block.func_208062_a(p_200123_1_.func_196954_c(p_200123_2_, p_200123_3_)) && p_200123_1_.func_204520_s().func_206888_e();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState p_180655_1_, World p_180655_2_, BlockPos p_180655_3_, Random p_180655_4_) {
    }

    public void func_176206_d(IWorld p_176206_1_, BlockPos p_176206_2_, BlockState p_176206_3_) {
    }

    public static List<ItemStack> func_220070_a(BlockState p_220070_0_, ServerWorld p_220070_1_, BlockPos p_220070_2_, @Nullable TileEntity p_220070_3_) {
        LootContext.Builder lootcontext$builder = new LootContext.Builder(p_220070_1_).func_216023_a(p_220070_1_.field_73012_v).func_216015_a(LootParameters.field_237457_g_, Vector3d.func_237489_a_((Vector3i)p_220070_2_)).func_216015_a(LootParameters.field_216289_i, ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, p_220070_3_);
        return p_220070_0_.func_215693_a(lootcontext$builder);
    }

    public static List<ItemStack> func_220077_a(BlockState p_220077_0_, ServerWorld p_220077_1_, BlockPos p_220077_2_, @Nullable TileEntity p_220077_3_, @Nullable Entity p_220077_4_, ItemStack p_220077_5_) {
        LootContext.Builder lootcontext$builder = new LootContext.Builder(p_220077_1_).func_216023_a(p_220077_1_.field_73012_v).func_216015_a(LootParameters.field_237457_g_, Vector3d.func_237489_a_((Vector3i)p_220077_2_)).func_216015_a(LootParameters.field_216289_i, p_220077_5_).func_216021_b(LootParameters.field_216281_a, p_220077_4_).func_216021_b(LootParameters.field_216288_h, p_220077_3_);
        return p_220077_0_.func_215693_a(lootcontext$builder);
    }

    public static void func_220075_c(BlockState p_220075_0_, World p_220075_1_, BlockPos p_220075_2_) {
        if (p_220075_1_ instanceof ServerWorld) {
            Block.func_220070_a(p_220075_0_, (ServerWorld)p_220075_1_, p_220075_2_, null).forEach(p_220079_2_ -> Block.func_180635_a(p_220075_1_, p_220075_2_, p_220079_2_));
            p_220075_0_.func_215706_a((ServerWorld)p_220075_1_, p_220075_2_, ItemStack.field_190927_a);
        }
    }

    public static void func_220059_a(BlockState p_220059_0_, IWorld p_220059_1_, BlockPos p_220059_2_, @Nullable TileEntity p_220059_3_) {
        if (p_220059_1_ instanceof ServerWorld) {
            Block.func_220070_a(p_220059_0_, (ServerWorld)p_220059_1_, p_220059_2_, p_220059_3_).forEach(p_220061_2_ -> Block.func_180635_a((ServerWorld)p_220059_1_, p_220059_2_, p_220061_2_));
            p_220059_0_.func_215706_a((ServerWorld)p_220059_1_, p_220059_2_, ItemStack.field_190927_a);
        }
    }

    public static void func_220054_a(BlockState p_220054_0_, World p_220054_1_, BlockPos p_220054_2_, @Nullable TileEntity p_220054_3_, Entity p_220054_4_, ItemStack p_220054_5_) {
        if (p_220054_1_ instanceof ServerWorld) {
            Block.func_220077_a(p_220054_0_, (ServerWorld)p_220054_1_, p_220054_2_, p_220054_3_, p_220054_4_, p_220054_5_).forEach(p_220057_2_ -> Block.func_180635_a(p_220054_1_, p_220054_2_, p_220057_2_));
            p_220054_0_.func_215706_a((ServerWorld)p_220054_1_, p_220054_2_, p_220054_5_);
        }
    }

    public static void func_180635_a(World p_180635_0_, BlockPos p_180635_1_, ItemStack p_180635_2_) {
        if (!p_180635_0_.field_72995_K && !p_180635_2_.func_190926_b() && p_180635_0_.func_82736_K().func_223586_b(GameRules.field_223603_f) && !p_180635_0_.restoringBlockSnapshots) {
            float f = 0.5f;
            double d0 = (double)(p_180635_0_.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d1 = (double)(p_180635_0_.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d2 = (double)(p_180635_0_.field_73012_v.nextFloat() * 0.5f) + 0.25;
            ItemEntity itementity = new ItemEntity(p_180635_0_, (double)p_180635_1_.func_177958_n() + d0, (double)p_180635_1_.func_177956_o() + d1, (double)p_180635_1_.func_177952_p() + d2, p_180635_2_);
            itementity.func_174869_p();
            p_180635_0_.func_217376_c(itementity);
        }
    }

    public void func_180637_b(ServerWorld p_180637_1_, BlockPos p_180637_2_, int p_180637_3_) {
        if (p_180637_1_.func_82736_K().func_223586_b(GameRules.field_223603_f) && !p_180637_1_.restoringBlockSnapshots) {
            while (p_180637_3_ > 0) {
                int i = ExperienceOrbEntity.func_70527_a(p_180637_3_);
                p_180637_3_ -= i;
                p_180637_1_.func_217376_c(new ExperienceOrbEntity(p_180637_1_, (double)p_180637_2_.func_177958_n() + 0.5, (double)p_180637_2_.func_177956_o() + 0.5, (double)p_180637_2_.func_177952_p() + 0.5, i));
            }
        }
    }

    @Deprecated
    public float func_149638_a() {
        return this.field_235689_au_;
    }

    public void func_180652_a(World p_180652_1_, BlockPos p_180652_2_, Explosion p_180652_3_) {
    }

    public void func_176199_a(World p_176199_1_, BlockPos p_176199_2_, Entity p_176199_3_) {
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext p_196258_1_) {
        return this.func_176223_P();
    }

    public void func_180657_a(World p_180657_1_, PlayerEntity p_180657_2_, BlockPos p_180657_3_, BlockState p_180657_4_, @Nullable TileEntity p_180657_5_, ItemStack p_180657_6_) {
        p_180657_2_.func_71029_a(Stats.field_188065_ae.func_199076_b(this));
        p_180657_2_.func_71020_j(0.005f);
        Block.func_220054_a(p_180657_4_, p_180657_1_, p_180657_3_, p_180657_5_, p_180657_2_, p_180657_6_);
    }

    public void func_180633_a(World p_180633_1_, BlockPos p_180633_2_, BlockState p_180633_3_, @Nullable LivingEntity p_180633_4_, ItemStack p_180633_5_) {
    }

    public boolean func_181623_g() {
        return !this.field_149764_J.func_76220_a() && !this.field_149764_J.func_76224_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public IFormattableTextComponent func_235333_g_() {
        return new TranslationTextComponent(this.func_149739_a());
    }

    public String func_149739_a() {
        if (this.field_149770_b == null) {
            this.field_149770_b = Util.func_200697_a("block", Registry.field_212618_g.func_177774_c((Object)this));
        }
        return this.field_149770_b;
    }

    public void func_180658_a(World p_180658_1_, BlockPos p_180658_2_, Entity p_180658_3_, float p_180658_4_) {
        p_180658_3_.func_225503_b_(p_180658_4_, 1.0f);
    }

    public void func_176216_a(IBlockReader p_176216_1_, Entity p_176216_2_) {
        p_176216_2_.func_213317_d(p_176216_2_.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
    }

    @Deprecated
    public ItemStack func_185473_a(IBlockReader p_185473_1_, BlockPos p_185473_2_, BlockState p_185473_3_) {
        return new ItemStack(this);
    }

    public void func_149666_a(ItemGroup p_149666_1_, NonNullList<ItemStack> p_149666_2_) {
        p_149666_2_.add((Object)new ItemStack(this));
    }

    public float func_208618_m() {
        return this.field_149765_K;
    }

    public float func_226891_m_() {
        return this.field_226886_f_;
    }

    public float func_226892_n_() {
        return this.field_226887_g_;
    }

    public void func_176208_a(World p_176208_1_, BlockPos p_176208_2_, BlockState p_176208_3_, PlayerEntity p_176208_4_) {
        p_176208_1_.func_217378_a(p_176208_4_, 2001, p_176208_2_, Block.func_196246_j(p_176208_3_));
        if (this.func_203417_a(BlockTags.field_232883_ay_)) {
            PiglinTasks.func_234478_a_(p_176208_4_, false);
        }
    }

    public void func_176224_k(World p_176224_1_, BlockPos p_176224_2_) {
    }

    @Deprecated
    public boolean func_149659_a(Explosion p_149659_1_) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
    }

    public StateContainer<Block, BlockState> func_176194_O() {
        return this.field_176227_L;
    }

    protected final void func_180632_j(BlockState p_180632_1_) {
        this.field_196275_y = p_180632_1_;
    }

    public final BlockState func_176223_P() {
        return this.field_196275_y;
    }

    @Deprecated
    public SoundType func_220072_p(BlockState p_220072_1_) {
        return this.field_149762_H;
    }

    @Override
    public Item func_199767_j() {
        if (this.field_220086_i == null) {
            this.field_220086_i = Item.func_150898_a(this);
        }
        return (Item)((Object)this.field_220086_i.delegate.get());
    }

    public boolean func_208619_r() {
        return this.field_208621_p;
    }

    public String toString() {
        return "Block{" + this.getRegistryName() + "}";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack p_190948_1_, @Nullable IBlockReader p_190948_2_, List<ITextComponent> p_190948_3_, ITooltipFlag p_190948_4_) {
    }

    @Override
    protected Block func_230328_p_() {
        return this;
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return this.harvestTool;
    }

    public int getHarvestLevel(BlockState state) {
        return this.harvestLevel;
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        BlockState plant = plantable.getPlant(world, pos.func_177972_a(facing));
        PlantType type = plantable.getPlantType(world, pos.func_177972_a(facing));
        if (plant.func_177230_c() == Blocks.field_150434_aF) {
            return state.func_203425_a(Blocks.field_150434_aF) || state.func_203425_a(Blocks.field_150354_m) || state.func_203425_a(Blocks.field_196611_F);
        }
        if (plant.func_177230_c() == Blocks.field_196608_cF && this == Blocks.field_196608_cF) {
            return true;
        }
        if (plantable instanceof BushBlock && ((BushBlock)plantable).func_200014_a_(state, world, pos)) {
            return true;
        }
        if (PlantType.DESERT.equals(type)) {
            return this.getBlock() == Blocks.field_150354_m || this.getBlock() == Blocks.field_150405_ch || this.getBlock() instanceof GlazedTerracottaBlock;
        }
        if (PlantType.NETHER.equals(type)) {
            return this.getBlock() == Blocks.field_150425_aM;
        }
        if (PlantType.CROP.equals(type)) {
            return state.func_203425_a(Blocks.field_150458_ak);
        }
        if (PlantType.CAVE.equals(type)) {
            return state.func_224755_d(world, pos, Direction.UP);
        }
        if (PlantType.PLAINS.equals(type)) {
            return this.getBlock() == Blocks.field_196658_i || Tags.Blocks.DIRT.func_230235_a_((Object)this) || this.getBlock() == Blocks.field_150458_ak;
        }
        if (PlantType.WATER.equals(type)) {
            return state.func_185904_a() == Material.field_151586_h;
        }
        if (PlantType.BEACH.equals(type)) {
            boolean isBeach = state.func_203425_a(Blocks.field_196658_i) || Tags.Blocks.DIRT.func_230235_a_((Object)this) || state.func_203425_a(Blocks.field_150354_m) || state.func_203425_a(Blocks.field_196611_F);
            boolean hasWater = false;
            for (Direction face : Direction.Plane.HORIZONTAL) {
                BlockState blockState = world.func_180495_p(pos.func_177972_a(face));
                FluidState fluidState = world.func_204610_c(pos.func_177972_a(face));
                hasWater |= blockState.func_203425_a(Blocks.field_185778_de);
                if (!(hasWater |= fluidState.func_206884_a(FluidTags.field_206959_a))) continue;
                break;
            }
            return isBeach && hasWater;
        }
        return false;
    }

    public final Set<ResourceLocation> getTags() {
        return this.reverseTags.getTagNames();
    }

    static {
        ForgeHooks.setBlockToolSetter((block, tool, level) -> {
            block.harvestTool = tool;
            block.harvestLevel = level;
        });
    }

    public static final class RenderSideCacheKey {
        private final BlockState field_212164_a;
        private final BlockState field_212165_b;
        private final Direction field_212166_c;

        public RenderSideCacheKey(BlockState p_i49791_1_, BlockState p_i49791_2_, Direction p_i49791_3_) {
            this.field_212164_a = p_i49791_1_;
            this.field_212165_b = p_i49791_2_;
            this.field_212166_c = p_i49791_3_;
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (!(p_equals_1_ instanceof RenderSideCacheKey)) {
                return false;
            }
            RenderSideCacheKey block$rendersidecachekey = (RenderSideCacheKey)p_equals_1_;
            return this.field_212164_a == block$rendersidecachekey.field_212164_a && this.field_212165_b == block$rendersidecachekey.field_212165_b && this.field_212166_c == block$rendersidecachekey.field_212166_c;
        }

        public int hashCode() {
            int i = ((Object)((Object)this.field_212164_a)).hashCode();
            i = 31 * i + ((Object)((Object)this.field_212165_b)).hashCode();
            return 31 * i + this.field_212166_c.hashCode();
        }
    }
}

